<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\CssSelector\Tests\Node;

use Symfony\Component\CssSelector\Node\ElementNode;
use Symfony\Component\CssSelector\Node\FunctionNode;
use Symfony\Component\CssSelector\Parser\Token;

class FunctionNodeTest extends AbstractNodeTest
{
    public function getToStringConversionTestData()
    {
        return [
            [new FunctionNode(new ElementNode(), 'function'), 'Function[Element[*]:function()]'],
            [new FunctionNode(new ElementNode(), 'function', [
                new Token(Token::TYPE_IDENTIFIER, 'value', 0),
            ]), "Function[Element[*]:function(['value'])]"],
            [new FunctionNode(new ElementNode(), 'function', [
                new Token(Token::TYPE_STRING, 'value1', 0),
                new Token(Token::TYPE_NUMBER, 'value2', 0),
            ]), "Function[Element[*]:function(['value1', 'value2'])]"],
        ];
    }

    public function getSpecificityValueTestData()
    {
        return [
            [new FunctionNode(new ElementNode(), 'function'), 10],
            [new FunctionNode(new ElementNode(), 'function', [
                new Token(Token::TYPE_IDENTIFIER, 'value', 0),
            ]), 10],
            [new FunctionNode(new ElementNode(), 'function', [
                new Token(Token::TYPE_STRING, 'value1', 0),
                new Token(Token::TYPE_NUMBER, 'value2', 0),
            ]), 10],
        ];
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                          <?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\CssSelector\Tests\Node;

use Symfony\Component\CssSelector\Node\AttributeNode;
use Symfony\Component\CssSelector\Node\ElementNode;

class AttributeNodeTest extends AbstractNodeTest
{
    public function getToStringConversionTestData()
    {
        return [
            [new AttributeNode(new ElementNode(), null, 'attribute', 'exists', null), 'Attribute[Element[*][attribute]]'],
            [new AttributeNode(new ElementNode(), null, 'attribute', '$=', 'value'), "Attribute[Element[*][attribute $= 'value']]"],
            [new AttributeNode(new ElementNode(), 'namespace', 'attribute', '$=', 'value'), "Attribute[Element[*][namespace|attribute $= 'value']]"],
        ];
    }

    public function getSpecificityValueTestData()
    {
        return [
            [new AttributeNode(new ElementNode(), null, 'attribute', 'exists', null), 10],
            [new AttributeNode(new ElementNode(null, 'element'), null, 'attribute', 'exists', null), 11],
            [new AttributeNode(new ElementNode(), null, 'attribute', '$=', 'value'), 10],
            [new AttributeNode(new ElementNode(), 'namespace', 'attribute', '$=', 'value'), 10],
        ];
    }
}
