<?php

/*
 Swift Mailer smoke test configuration.

 YOU ONLY NEED TO EDIT THIS FILE IF YOU WISH TO RUN THE SMOKE TESTS.

 The smoke tests are run by default when "All Tests" are run with the
 testing suite, however, without configuration options here only the unit tests
 will be run and the smoke tests will be skipped.
 */

/*
 Defines: The an address which Swift can send to (it will also send "from" this address).
 Recommended: (your own email address?)
 */
define('SWIFT_SMOKE_EMAIL_ADDRESS', 'test@swiftmailer.org');

/*
 Defines: The specific transport you want to mail with.
 Recommended: Any of 'smtp', 'sendmail' or 'mail'
 */
define('SWIFT_SMOKE_TRANSPORT_TYPE', 'smtp');

// SMTP-specific settings

/*
 Defines: An SMTP server to connect to
 Recommended: smtp.your-isp.com (varies wildly!)
 */
define('SWIFT_SMOKE_SMTP_HOST', 'localhost');

/*
 Defines: The SMTP port to connect to
 Recommended: 25
 */
define('SWIFT_SMOKE_SMTP_PORT', '4456');

/*
 Defines: A username to authenticate with SMTP (if needed).
 Recommended: (none)
 */
define('SWIFT_SMOKE_SMTP_USER', '');

/*
 Defines: A password to authenticate with SMTP (if needed).
 Recommended: (none)
 */
define('SWIFT_SMOKE_SMTP_PASS', '');

/*
 Defines: The encryption needed on your SMTP server.
 Recommended: (none), or 'tls' or 'ssl'
 */
define('SWIFT_SMOKE_SMTP_ENCRYPTION', '');

// Sendmail specific settings

/*
 Defines: The command to use when sending via sendmail
 Recommended: /usr/sbin/sendmail -bs (or "-oi -t")
 */
define('SWIFT_SMOKE_SENDMAIL_COMMAND', '/usr/sbin/sendmail -bs');
                                                                                                                                                                                                                                                                                                                                                                                                                                     <?php

/**
 * Base test for smoke tests.
 *
 * @author Rouven Weßling
 */
class SwiftMailerSmokeTestCase extends SwiftMailerTestCase
{
    protected function setUp()
    {
        if (!defined('SWIFT_SMOKE_TRANSPORT_TYPE')) {
            $this->markTestSkipped(
                'Smoke tests are skipped if tests/smoke.conf.php is not edited'
             );
        }
    }

    protected function getMailer()
    {
        switch (SWIFT_SMOKE_TRANSPORT_TYPE) {
            case 'smtp':
                $transport = Swift_DependencyContainer::getInstance()->lookup('transport.smtp')
                    ->setHost(SWIFT_SMOKE_SMTP_HOST)
                    ->setPort(SWIFT_SMOKE_SMTP_PORT)
                    ->setUsername(SWIFT_SMOKE_SMTP_USER)
                    ->setPassword(SWIFT_SMOKE_SMTP_PASS)
                    ->setEncryption(SWIFT_SMOKE_SMTP_ENCRYPTION)
                    ;
                break;
            case 'sendmail':
                $transport = Swift_DependencyContainer::getInstance()->lookup('transport.sendmail')
                    ->setCommand(SWIFT_SMOKE_SENDMAIL_COMMAND)
                    ;
                break;
            case 'mail':
            case 'nativemail':
                $transport = Swift_DependencyContainer::getInstance()->lookup('transport.mail');
                break;
            default:
                throw new Exception('Undefined transport ['.SWIFT_SMOKE_TRANSPORT_TYPE.']');
        }

        return new Swift_Mailer($transport);
    }
}
