<?php

/*
 * This file is part of SwiftMailer.
 * (c) 2004-2009 Chris Corbyn
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Wraps a standard PHP array in an iterator.
 *
 * @author Chris Corbyn
 */
class Swift_Mailer_ArrayRecipientIterator implements Swift_Mailer_RecipientIterator
{
    /**
     * The list of recipients.
     *
     * @var array
     */
    private $recipients = [];

    /**
     * Create a new ArrayRecipientIterator from $recipients.
     */
    public function __construct(array<?php

/*
 * This file is part of SwiftMailer.
 * (c) 2018 Christian Schmidt
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Email address encoder.
 *
 * @author Christian Schmidt
 */
interface Swift_AddressEncoder
{
    /**
     * Encodes an email address.
     *
     * @throws Swift_AddressEncoderException If the email cannot be represented in
     *                                       the encoding implemented by this class.
     */
    public function encodeString(string $address): string;
}
