<?php
declare(strict_types=1);
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

use PHPUnit\Framework\TestCase;

class Issue3364SetupTest extends TestCase
{
    public function setUp(): void
    {
        throw new \RuntimeException('throw exception in setUp');
    }

    public function testOneWithSetupException(): void
    {
        $this->fail();
    --TEST--
GH-2830: @runClassInSeparateProcess fails for tests with a @dataProvider
--FILE--
<?php
$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = 'Issue2830';
$_SERVER['argv'][3] = __DIR__ . '/2830/Issue2830Test.php';

require __DIR__ . '/../../../bootstrap.php';

PHPUnit\TextUI\Command::main();
?>
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

.                                                                   1 / 1 (100%)

Time: %s, Memory: %s

OK (1 test, 1 assertion)
