<?php
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
use PHPUnit\Framework\TestCase;

class Issue2380Test extends TestCase
{
    /**
     * @dataProvider generatorData
     */
    public function testGeneratorProvider($data): void
    {
        $this->assertNotEmpty($data);
    }

    /**
     * @return Generator
     */
    public function generatorData()
    {
        yield ['testing'];
    }
}
  --TEST--
#2158: Failure to run tests in separate processes if a file included into main process contains constant definition
--FILE--
<?php
$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = 'Issue2158Test';
$_SERVER['argv'][3] = __DIR__ . '/2158/Issue2158Test.php';

require __DIR__ . '/../../../bootstrap.php';
PHPUnit\TextUI\Command::main();
?>
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

..                                                                  2 / 2 (100%)

Time: %s, Memory: %s

OK (2 tests, 2 assertions)
