--TEST--
GH-2591: Test method process isolation without preserving global state and without loaded bootstrap.
Expected result is to have an error, because of no classes loaded.
--SKIPIF--
<?php
if (extension_loaded('xdebug')) {
    print 'skip: xdebug loaded';
} elseif (version_compare(PHP_VERSION, '7.3.0-dev', '<')) {
    print 'skip: PHP 7.3 required';
}
--FILE--
<?php

$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = '--bootstrap';
$_SERVER['argv'][3] = __DIR__ . '/2591/bootstrapNoBootstrap.php';
$_SERVER['argv'][4] = __DIR__ . '/2591/SeparateFunctionNoPreserveTest.php';

requ--TEST--
https://github.com/sebastianbergmann/phpunit/issues/1468
--FILE--
<?php
$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = '--disallow-todo-tests';
$_SERVER['argv'][3] = 'Issue1468Test';
$_SERVER['argv'][4] = __DIR__ . '/1468/Issue1468Test.php';

require __DIR__ . '/../../../bootstrap.php';
PHPUnit\TextUI\Command::main();
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

I                                                                   1 / 1 (100%)

Time: %s, Memory: %s

OK, but incomplete, skipped, or risky tests!
Tests: 1, Assertions: 0, Incomplete: 1.
