<?php
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * @runClassInSeparateProcess
 */
class SeparateClassRunMethodInNewProcessTest extends PHPUnit\Framework\TestCase
{
    public const PROCESS_ID_FILE_PATH = __DIR__ . '/parent_process_id.txt';

    public const INITIAL_MASTER_PID   = 0;

    public const INITIAL_PID1         = 1;

    public static $--TEST--
GH-1149: Test swallows output buffer when run in a separate process
--FILE--
<?php

$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = 'Issue1149Test';
$_SERVER['argv'][3] = __DIR__ . '/1149/Issue1149Test.php';

require __DIR__ . '/../../../bootstrap.php';
PHPUnit\TextUI\Command::main();
?>
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

.1.                                                                  2 / 2 (100%)2

Time: %s, Memory: %s

OK (2 tests, 2 assertions)
