--TEST--
phpunit -c ../_files/configuration_stop_on_defect.xml MultiDependencyTest ./tests/_files/MultiDependencyTest.php
--FILE--
<?php
$_SERVER['argv'][1] = '--debug';
$_SERVER['argv'][2] = '-c';
$_SERVER['argv'][3] = __DIR__ . '/../_files/configuration_execution_order_options.xml';
$_SERVER['argv'][4] = 'MultiDependencyTest';
$_SERVER['argv'][5] = __DIR__ . '/../_files/MultiDependencyTest.php';

require __DIR__ . '/../bootstrap.php';
PHPUnit\TextUI\Command::main();
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

Test 'MultiDependencyTest::testFive' started
Test 'MultiDependencyTest::testFive' ended
Test 'MultiDependencyTest::testTwo' started
Test 'MultiDependencyTest::testTwo' ended
Test 'MultiDependencyTest::testOne' started
Test 'MultiDependencyT--TEST--
phpunit -c ../_files/configuration_whitelist.xml --dump-xdebug-filter 'php://stdout'
--SKIPIF--
<?php
if (!extension_loaded('xdebug')) {
    print 'skip: xdebug not loaded';
}
--FILE--
<?php
$_SERVER['argv'][1] = '-c';
$_SERVER['argv'][2] = __DIR__ . '/../_files/configuration_whitelist.xml';
$_SERVER['argv'][3] = '--dump-xdebug-filter';
$_SERVER['argv'][4] = 'php://stderr';

require __DIR__ . '/../bootstrap.php';
PHPUnit\TextUI\Command::main();
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

<?php declare(strict_types=1);
if (!\function_exists('xdebug_set_filter')) {
    return;
}

\xdebug_set_filter(
    \XDEBUG_FILTER_CODE_COVERAGE,
    \XDEBUG_PATH_WHITELIST,
    [
        %s
    ]
);
Wrote Xdebug filter script to php://stderr
