--TEST--
phpunit --process-isolation --log-junit php://stdout DataProviderTest ../../_files/DataProviderTest.php
--FILE--
<?php
$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = '--process-isolation';
$_SERVER['argv'][3] = '--log-junit';
$_SERVER['argv'][4] = 'php://stdout';
$_SERVER['argv'][5] = 'DataProviderTest';
$_SERVER['argv'][6] = __DIR__ . '/../_files/DataProviderTest.php';

require __DIR__ . '/../bootstrap.php';
PHPUnit\TextUI\Command::main();
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

..F.                                                                4 / 4 (100%)<?xml version="1.0" encoding="UTF-8"?>
<testsuites>
  <testsuite name="DataProviderTest" file="%sDataProviderTest.php" tests="4" assertions="4" errors="0" failures="1" skipped="0" time="%f">
    <testsuite name="DataProviderTest::testAdd" tests="4" assertions="4" errors="0" failures="1" skipped="0" time="%f">
      <testcase name="testAdd with data set #0" class="DataProviderTest" classname="DataProviderTest" file="%sDataProviderTest.php" line="%d" assertions="1" time="%f"/>
      <testcase name="testAdd with data set #1" class="DataProviderTest" classname="DataProviderTest" file="%sDataProviderTest.php" line="%d" assertions="1" time="%f"/>
      <testcase name="testAdd with data set #2" class="DataProviderTest" classname="DataProviderTest" file="%sDataProviderTest.php" line="%d" assertions="1" time="%f">
        <failure type="PHPUnit\Framework\ExpectationFailedException">DataProviderTest::testAdd with data set #2 (1, 1, 3)
Failed asserting that 2 matches expected 3.

%s:%i
</failure>
      </testcase>
      <testcase name="testAdd with data set #3" class="DataProviderTest" classname="DataProviderTest" file="%sDataProviderTest.php" line="%d" assertions="1" time="%f"/>
    </testsuite>
  </testsuite>
</testsuites>


Time: %s, Memory: %s

There was 1 failure:

1) DataProviderTest::testAdd with data set #2 (1, 1, 3)
Failed asserting that 2 matches expected 3.

%s:%i

FAILURES!
Tests: 4, Assertions: 4, Failures: 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                             --TEST--
phpunit --colors=never --coverage-text=php://stdout ../../_files/phpt-for-coverage.phpt --whitelist ../../_files/CoveredClass.php
--SKIPIF--
<?php
if (!extension_loaded('xdebug')) {
    print 'skip: Extension xdebug is required.';
}
?>
--FILE--
<?php
$_SERVER['argv'][1] = '--no-configuration';
$_SERVER['argv'][2] = '--bootstrap';
$_SERVER['argv'][3] = __DIR__ . '/../bootstrap.php';
$_SERVER['argv'][4] = '--colors=never';
$_SERVER['argv'][5] = '--coverage-text=php://stdout';
$_SERVER['argv'][6] = __DIR__ . '/../_files/phpt-for-coverage.phpt';
$_SERVER['argv'][7] = '--whitelist';
$_SERVER['argv'][8] = __DIR__ . '/../_files/CoveredClass.php';

require __DIR__ . '/../bootstrap.php';
PHPUnit\TextUI\Command::main();
--EXPECTF--
PHPUnit %s by Sebastian Bergmann and contributors.

.                                                                   1 / 1 (100%)

Time: %s, Memory: %s

OK (1 test, 1 assertion)


Code Coverage Report:%w
%s
%w
 Summary:%w
  Classes: 100.00% (2/2)%w
  Methods: 100.00% (%d/%d)%w
  Lines:   100.00% (%d/%d)

CoveredClass
  Methods: 100.00% ( %d/ %d)   Lines: 100.00% (  %d/  %d)
CoveredParentClass
  Methods: 100.00% ( %d/ %d)   Lines: 100.00% (  %d/  %d)
