<?php
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
class TestIterator2 implements Iterator
{
    protected $data;

    public function __construct(array $array)
    {
        $this->data = $array;
    }

    public function current()
    {
        return \current($this->data);
    }

    public function next(): void
    {
        \next<?php
/*
 * This file is part of PHPUnit.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

class TestIteratorAggregate2 implements IteratorAggregate
{
    private $traversable;

    public function __construct(\Traversable $traversable)
    {
        $this->traversable = $traversable;
    }

    public function getIterator()
    {
        return $this->traversable;
    }
}
