<?php
/**
 * Nexmo Client Library for PHP
 *
 * @copyright Copyright (c) 2016 Nexmo, Inc. (http://nexmo.com)
 * @license   https://github.com/Nexmo/nexmo-php/blob/master/LICENSE.txt MIT License
 */

namespace Nexmo\Client\Response;


class Error extends Response
{
    public function __construct($data)
    {
        //normalize the data
        if(isset($data['error_text'])){
            $data['error-text'] = $data['error_text'];
        }

        $this->expected = ['status', 'error-text'];

        return parent::__construct($data);
    }

    public function isError()
    {
      <?php
/**
 * Nexmo Client Library for PHP
 *
 * @copyright Copyright (c) 2016 Nexmo, Inc. (http://nexmo.com)
 * @license   https://github.com/Nexmo/nexmo-php/blob/master/LICENSE.txt MIT License
 */

namespace Nexmo\Client\Response;


abstract class AbstractResponse implements ResponseInterface
{
    protected $data;

    public function getData()
    {
        return $this->data;
    }

    public function isSuccess()
    {
        return isset($this->data['status']) AND $this->data['status'] == 0;
    }

    public function isError()
    {
        return !$this->isSuccess();
    }
}