<?php
namespace JmesPath\Tests\Tree;

use JmesPath\TreeCompiler;

/**
 * @covers JmesPath\Tree\TreeCompiler
 */
class TreeCompilerTest extends \PHPUnit_Framework_TestCase
{
    public function testCreatesSourceCode()
    {
        $t = new TreeCompiler();
        $source = $t->visit(
            ['type' => 'field', 'value' => 'foo'],
            'testing',
            'foo'
        );
        $this->assertContains('<?php', $source);
        $this->assertContains('$value = isset($value->{\'foo\'}) ? $value->{\'foo\'} : null;', $source);
        $this->assertContains('$value = isset($value[\'foo\']) ? $value[\'foo\'] : null;', $source);
    }
}
                                                                                                                                                                                                                                                                                                                                   <?php
namespace JmesPath\Tests;

use JmesPath\SyntaxErrorException;

/**
 * @covers JmesPath\SyntaxErrorException
 */
class SyntaxErrorExceptionTest extends \PHPUnit_Framework_TestCase
{
    public function testCreatesWithNoArray()
    {
        $e = new SyntaxErrorException(
            'Found comma',
            ['type' => 'comma', 'pos' => 3, 'value' => ','],
            'abc,def'
        );
        $expected = <<<EOT
Syntax error at character 3
abc,def
   ^
Found comma
EOT;
        $this->assertContains($expected, $e->getMessage());
    }

    public function testCreatesWithArray()
    {
        $e = new SyntaxErrorException(
            ['dot' => true, 'eof' => true],
            ['type' => 'comma', 'pos' => 3, 'value' => ','],
            'abc,def'
        );
        $expected = <<<EOT
Syntax error at character 3
abc,def
   ^
Expected one of the following: dot, eof; found comma ","
EOT;
        $this->assertContains($expected, $e->getMessage());
    }
}
