<?php
namespace Hamcrest;

class UtilTest extends \PhpUnit_Framework_TestCase
{

    public function testWrapValueWithIsEqualLeavesMatchersUntouched()
    {
        $matcher = new \Hamcrest\Text\MatchesPattern('/fo+/');
        $newMatcher = \Hamcrest\Util::wrapValueWithIsEqual($matcher);
        $this->assertSame($matcher, $newMatcher);
    }

    public function testWrapValueWithIsEqualWrapsPrimitive()
    {
        $matcher = \Hamcrest\Util::wrapValueWithIsEqual('foo');
        $this->assertInstanceOf('Hamcrest\Core\IsEqual', $matcher);
        $this->assertTrue($matcher->matches('foo'));
    }

    public function testCheckAllAreMatchersAcceptsMatchers()
    {
        \Hamcrest\Util::checkAllAreMatchers(array(
            new \Hamcrest\Text\MatchesPattern('/fo+/'),
            new \Hamcrest\Core\IsEqual('foo'),
        ));
    }

    /**
     * @expectedException InvalidArgumentException
     */
    public function testCheckAllAreMatchersFailsForPrimitive()
    {
        \Hamcrest\Util::checkAllAreMatchers(array(
            new \Hamcrest\Text\MatchesPattern('/fo+/'),
            'foo',
        ));
    }

    private function callAndAssertCreateMatcherArray($items)
    {
        $matchers = \Hamcrest\Util::createMatcherArray($items);
        $this->assertInternalType('array', $matchers);
        $this->assertSameSize($items, $matchers);
        foreach ($matchers as $matcher) {
            $this->assertInstanceOf('\Hamcrest\Matcher', $matcher);
        }

        return $matchers;
    }

    public function testCreateMatcherArrayLeavesMatchersUntouched()
    {
        $matcher = new \Hamcrest\Text\MatchesPattern('/fo+/');
        $items = array($matcher);
        $matchers = $this->callAndAssertCreateMatcherArray($items);
        $this->assertSame($matcher, $matchers[0]);
    }

    public function testCreateMatcherArrayWrapsPrimitiveWithIsEqualMatcher()
    {
        $matchers = $this->callAndAssertCreateMatcherArray(array('foo'));
        $this->assertInstanceOf('Hamcrest\Core\IsEqual', $matchers[0]);
        $this->assertTrue($matchers[0]->matches('foo'));
    }

    public function testCreateMatcherArrayDoesntModifyOriginalArray()
    {
        $items = array('foo');
        $this->callAndAssertCreateMatcherArray($items);
        $this->assertSame('foo', $items[0]);
    }

    public function testCreateMatcherArrayUnwrapsSingleArrayElement()
    {
        $matchers = $this->callAndAssertCreateMatcherArray(array(array('foo')));
        $this->assertInstanceOf('Hamcrest\Core\IsEqual', $matchers[0]);
        $this->assertTrue($matchers[0]->matches('foo'));
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <?php
namespace Hamcrest;

class Thingy
{
    private $_result;
    public function __construct($result)
    {
        $this->_result = $result;
    }
    public function getResult()
    {
        return $this->_result;
    }
}

/* Test-specific subclass only */
class ResultMatcher extends \Hamcrest\FeatureMatcher
{
    public function __construct()
    {
        parent::__construct(self::TYPE_ANY, null, equalTo('bar'), 'Thingy with result', 'result');
    }
    public function featureValueOf($actual)
    {
        if ($actual instanceof \Hamcrest\Thingy) {
            return $actual->getResult();
        }
    }
}

class FeatureMatcherTest extends \Hamcrest\AbstractMatcherTest
{

    private $_resultMatcher;

    public function setUp()
    {
        $this->_resultMatcher = $this->_resultMatcher();
    }

    protected function createMatcher()
    {
        return $this->_resultMatcher();
    }

    public function testMatchesPartOfAnObject()
    {
        $this->assertMatches($this->_resultMatcher, new \Hamcrest\Thingy('bar'), 'feature');
        $this->assertDescription('Thingy with result "bar"', $this->_resultMatcher);
    }

    public function testMismatchesPartOfAnObject()
    {
        $this->assertMismatchDescription(
            'result was "foo"',
            $this->_resultMatcher,
            new \Hamcrest\Thingy('foo')
        );
    }

    public function testDoesNotGenerateNoticesForNull()
    {
        $this->assertMismatchDescription('result was null', $this->_resultMatcher, null);
    }

    // -- Creation Methods

    private function _resultMatcher()
    {
        return new \Hamcrest\ResultMatcher();
    }
}
