<?php
namespace Hamcrest\Core;

class PhpForm
{
    public function __toString()
    {
        return 'php';
    }
}

class JavaForm
{
    public function toString()
    {
        return 'java';
    }
}

class BothForms
{
    public function __toString()
    {
        return 'php';
    }

    public function toString()
    {
        return 'java';
    }
}

class HasToStringTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Core\HasToString::hasToString('foo');
    }

    public function testMatchesWhenToStringMatches()
    {
        $this->assertMatches(
            hasToString(equalTo('php')),
            new \Hamcrest\Core\PhpForm(),
            'correct __toString'
        );
        $this->assertMatches(
            hasToString(equalTo('java')),
            new \Hamcrest\Core\JavaForm(),
            'correct toString'
        );
    }

    public function testPicksJavaOverPhpToString()
    {
        $this->assertMatches(
            hasToString(equalTo('java')),
            new \Hamcrest\Core\BothForms(),
            'correct toString'
        );
    }

    public function testDoesNotMatchWhenToStringDoesNotMatch()
    {
        $this->assertDoesNotMatch(
            hasToString(equalTo('mismatch')),
            new \Hamcrest\Core\PhpForm(),
            'incorrect __toString'
        );
        $this->assertDoesNotMatch(
            hasToString(equalTo('mismatch')),
            new \Hamcrest\Core\JavaForm(),
            'incorrect toString'
        );
        $this->assertDoesNotMatch(
            hasToString(equalTo('mismatch')),
            new \Hamcrest\Core\BothForms(),
            'incorrect __toString'
        );
    }

    public function testDoesNotMatchNull()
    {
        $this->assertDoesNotMatch(
            hasToString(equalTo('a')),
            null,
            'should not match null'
        );
    }

    public function testProvidesConvenientShortcutForTraversableWithSizeEqualTo()
    {
        $this->assertMatches(
            hasToString(equalTo('php')),
            new \Hamcrest\Core\PhpForm(),
            'correct __toString'
        );
    }

    public function testHasAReadableDescription()
    {
        $this->assertDescription(
            'an object with toString() "php"',
            hasToString(equalTo('php'))
        );
    }
}
                                                                                                                                                                                                  <?php
namespace Hamcrest\Core;

class SetTest extends \Hamcrest\AbstractMatcherTest
{

    public static $_classProperty;
    public $_instanceProperty;

    protected function setUp()
    {
        self::$_classProperty = null;
        unset($this->_instanceProperty);
    }

    protected function createMatcher()
    {
        return \Hamcrest\Core\Set::set('property_name');
    }

    public function testEvaluatesToTrueIfArrayPropertyIsSet()
    {
        assertThat(array('foo' => 'bar'), set('foo'));
    }

    public function testNegatedEvaluatesToFalseIfArrayPropertyIsSet()
    {
        assertThat(array('foo' => 'bar'), not(notSet('foo')));
    }

    public function testEvaluatesToTrueIfClassPropertyIsSet()
    {
        self::$_classProperty = 'bar';
        assertThat('Hamcrest\Core\SetTest', set('_classProperty'));
    }

    public function testNegatedEvaluatesToFalseIfClassPropertyIsSet()
    {
        self::$_classProperty = 'bar';
        assertThat('Hamcrest\Core\SetTest', not(notSet('_classProperty')));
    }

    public function testEvaluatesToTrueIfObjectPropertyIsSet()
    {
        $this->_instanceProperty = 'bar';
        assertThat($this, set('_instanceProperty'));
    }

    public function testNegatedEvaluatesToFalseIfObjectPropertyIsSet()
    {
        $this->_instanceProperty = 'bar';
        assertThat($this, not(notSet('_instanceProperty')));
    }

    public function testEvaluatesToFalseIfArrayPropertyIsNotSet()
    {
        assertThat(array('foo' => 'bar'), not(set('baz')));
    }

    public function testNegatedEvaluatesToTrueIfArrayPropertyIsNotSet()
    {
        assertThat(array('foo' => 'bar'), notSet('baz'));
    }

    public function testEvaluatesToFalseIfClassPropertyIsNotSet()
    {
        assertThat('Hamcrest\Core\SetTest', not(set('_classProperty')));
    }

    public function testNegatedEvaluatesToTrueIfClassPropertyIsNotSet()
    {
        assertThat('Hamcrest\Core\SetTest', notSet('_classProperty'));
    }

    public function testEvaluatesToFalseIfObjectPropertyIsNotSet()
    {
        assertThat($this, not(set('_instanceProperty')));
    }

    public function testNegatedEvaluatesToTrueIfObjectPropertyIsNotSet()
    {
        assertThat($this, notSet('_instanceProperty'));
    }

    public function testHasAReadableDescription()
    {
        $this->assertDescription('set property foo', set('foo'));
        $this->assertDescription('unset property bar', notSet('bar'));
    }

    public function testDecribesPropertySettingInMismatchMessage()
    {
        $this->assertMismatchDescription(
            'was not set',
            set('bar'),
            array('foo' => 'bar')
        );
        $this->assertMismatchDescription(
            'was "bar"',
            notSet('foo'),
            array('foo' => 'bar')
        );
        self::$_classProperty = 'bar';
        $this->assertMismatchDescription(
            'was "bar"',
            notSet('_classProperty'),
            'Hamcrest\Core\SetTest'
        );
        $this->_instanceProperty = 'bar';
        $this->assertMismatchDescription(
            'was "bar"',
            notSet('_instanceProperty'),
            $this
        );
    }
}
