<?php
namespace Hamcrest\Number;

class OrderingComparisonTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Number\OrderingComparison::greaterThan(1);
    }

    public function testComparesValuesForGreaterThan()
    {
        assertThat(2, greaterThan(1));
        assertThat(0, not(greaterThan(1)));
    }

    public function testComparesValuesForLessThan()
    {
        assertThat(2, lessThan(3));
        assertT<?php
namespace Hamcrest\Core;

class IsNullTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Core\IsNull::nullValue();
    }

    public function testEvaluatesToTrueIfArgumentIsNull()
    {
        assertThat(null, nullValue());
        assertThat(self::ANY_NON_NULL_ARGUMENT, not(nullValue()));

        assertThat(self::ANY_NON_NULL_ARGUMENT, notNullValue());
        assertThat(null, not(notNullValue()));
    }
}
