<?php
namespace Hamcrest\Core;

class IsCollectionContainingTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Core\IsCollectionContaining::hasItem(equalTo('irrelevant'));
    }

    public function testMatchesACollectionThatContainsAnElementMatchingTheGivenMatcher()
    {
        $itemMatcher = hasItem(equalTo('a'));

        $this->assertMatches(
            $itemMatcher,
            array('a', 'b', 'c'),
            "should match list that contains 'a'"
        );
    }

    public function testDoesNotMatchCollectionThatDoesntContainAnElementMatchingTheGivenMatcher()
    {
        $matcher1 = hasItem(equalTo('a'));
        $this->assertDoesNotMatch(
            $matcher1,
            array('b', 'c'),
            "should not match list that doesn't contain <?php
namespace Hamcrest\Core;

class EveryTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Core\Every::everyItem(anything());
    }

    public function testIsTrueWhenEveryValueMatches()
    {
        assertThat(array('AaA', 'BaB', 'CaC'), everyItem(containsString('a')));
        assertThat(array('AbA', 'BbB', 'CbC'), not(everyItem(containsString('a'))));
    }

    public function testIsAlwaysTrueForEmptyLists()
    {
        assertThat(array(), everyItem(containsString('a')));
    }

    public function testDescribesItself()
    {
        $each = everyItem(containsString('a'));
        $this->assertEquals('every item is a string containing "a"', (string) $each);

        $this->assertMismatchDescription('an item was "BbB"', $each, array('BbB'));
    }
}
