<?php
namespace Hamcrest\Core;

class DescribedAsTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Core\DescribedAs::describedAs('irrelevant', anything());
    }

    public function testOverridesDescriptionOfOtherMatcherWithThatPassedToConstructor()
    {
        $m1 = describedAs('m1 description', anything());
        $m2 = describedAs('m2 description', not(anything()));

        $this->assertDescription('m1 description', $m1);
        $this->assertDescription('m2 description', $m2);
    }

    public function testAppendsValuesToDescription()
    {
        $m = describedAs('value 1 = %0, value 2 = %1', anything(), 33, 97);

        $this->assertDescription('value 1 = <33>, value 2 = <97>', $m);
    }

    public function testDelegatesMatchingToAnotherMatcher()
    {
        $m1 = describedAs('irrelevant', anything());
        $m2 = describedAs('irrelevant', not(anything()));

        $this->assertTrue($m1->matches(new \stdClass()));
        $this->assertFalse($m2->matches('hi'));
    }
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 <?php
namespace Hamcrest\Core;

class AllOfTest extends \Hamcrest\AbstractMatcherTest
{

    protected function createMatcher()
    {
        return \Hamcrest\Core\AllOf::allOf('irrelevant');
    }

    public function testEvaluatesToTheLogicalConjunctionOfTwoOtherMatchers()
    {
        assertThat('good', allOf('good', 'good'));

        assertThat('good', not(allOf('bad', 'good')));
        assertThat('good', not(allOf('good', 'bad')));
        assertThat('good', not(allOf('bad', 'bad')));
    }

    public function testEvaluatesToTheLogicalConjunctionOfManyOtherMatchers()
    {
        assertThat('good', allOf('good', 'good', 'good', 'good', 'good'));
        assertThat('good', not(allOf('good', endsWith('d'), 'bad', 'good', 'good')));
    }

    public function testSupportsMixedTypes()
    {
        $all = allOf(
            equalTo(new \Hamcrest\Core\SampleBaseClass('good')),
            equalTo(new \Hamcrest\Core\SampleBaseClass('good')),
            equalTo(new \Hamcrest\Core\SampleSubClass('ugly'))
        );

        $negated = not($all);

        assertThat(new \Hamcrest\Core\SampleSubClass('good'), $negated);
    }

    public function testHasAReadableDescription()
    {
        $this->assertDescription(
            '("good" and "bad" and "ugly")',
            allOf('good', 'bad', 'ugly')
        );
    }

    public function testMismatchDescriptionDescribesFirstFailingMatch()
    {
        $this->assertMismatchDescription(
            '"good" was "bad"',
            allOf('bad', 'good'),
            'bad'
        );
    }
}
