<?php
namespace Hamcrest\Collection;

use Hamcrest\AbstractMatcherTest;

class IsEmptyTraversableTest extends AbstractMatcherTest
{

    protected function createMatcher()
    {
        return IsEmptyTraversable::emptyTraversable();
    }

    public function testEmptyMatcherMatchesWhenEmpty()
    {
        $this->assertMatches(
            emptyTraversable(),
            new \ArrayObject(array()),
            'an empty traversable'
        );
    }

    public function testEmptyMatcherDoesNotMatchWhenNotEmpty()
    {
        $th<?php
namespace Hamcrest;

/* Test-specific subclass only */
class BaseMatcherTest extends \Hamcrest\BaseMatcher
{

    public function matches($item)
    {
        throw new \RuntimeException();
    }

    public function describeTo(\Hamcrest\Description $description)
    {
        $description->appendText('SOME DESCRIPTION');
    }

    public function testDescribesItselfWithToStringMethod()
    {
        $someMatcher = new \Hamcrest\SomeMatcher();
        $this->assertEquals('SOME DESCRIPTION', (string) $someMatcher);
    }
}
