<?php
namespace Hamcrest;

/*
 Copyright (c) 2009 hamcrest.org
 */

/**
 * A matcher over acceptable values.
 * A matcher is able to describe itself to give feedback when it fails.
 * <p/>
 * Matcher implementations should <b>NOT directly implement this interface</b>.
 * Instead, <b>extend</b> the {@link Hamcrest\BaseMatcher} abstract class,
 * which will ensure that the Matcher API can grow to support
 * new features and remain compatibl<?php
namespace Hamcrest;

/*
 Copyright (c) 2009 hamcrest.org
 */

/**
 * BaseClass for all Matcher implementations.
 *
 * @see Hamcrest\Matcher
 */
abstract class BaseMatcher implements Matcher
{

    public function describeMismatch($item, Description $description)
    {
        $description->appendText('was ')->appendValue($item);
    }

    public function __toString()
    {
        return StringDescription::toString($this);
    }
}
