<?php

/*
 Copyright (c) 2009 hamcrest.org
 */

class FactoryClass
{
    /**
     * @var string
     */
    private $file;

    /**
     * @var ReflectionClass
     */
    private $reflector;

    /**
     * @var array
     */
    private $methods;

    public function __construct($file, ReflectionClass $class)
    {
        $this->file = $file;
        $this->reflector = $class;
        $this->extractFactoryMethods();
    }

    public function extractFactoryMethods()
    {
        $this->methods = array();
        foreach ($this->getPublicStaticMethods() as $method) {
            if ($method->isFactory()) {
//                echo $this->getName() . '::' . $method->getName() . ' : ' . count($method->getCalls()) . PHP_EOL;
                $this->methods[] = $method;
            }
        }
    }

    public function getPublicStaticMethods()
    {
        $methods = array();
        foreach ($this->reflector->getMethod<?php

/*
 Copyright (c) 2009 hamcrest.org
 */

class GlobalFunctionFile extends FactoryFile
{
    /**
     * @var string containing function definitions
     */
    private $functions;

    public function __construct($file)
    {
        parent::__construct($file, '    ');
        $this->functions = '';
    }

    public function addCall(FactoryCall $call)
    {
        $this->functions .= PHP_EOL . $this->generateFactoryCall($call);
    }

    public function build()
    {
        $this->addFileHeader();
        $this->addPart('functions_imports');
        $this->addPart('functions_header');
        $this->addCode($this->functions);
        $this->addPart('functions_footer');
    }

    public function generateFactoryCall(FactoryCall $call)
    {
        $code = "if (!function_exists('{$call->getName()}')) {";
        $code.= parent::generateFactoryCall($call);
        $code.= "}\n";

        return $code;
    }
}
