<?php

namespace Faker\Provider\zh_CN;

class Color extends \Faker\Provider\Color
{
    /**
     * @link https://zh.wikipedia.org/zh-cn/%E9%A2%9C%E8%89%B2%E5%88%97%E8%A1%A8
     */
    protected static $safeColorNames = array(
        '黑色', '粟色', '绿色', '藏青', '橄榄色',
        '紫', '凫绿', '鲜绿色', '蓝色', '银色',
        '灰色', '黄色', '品红', '水色', '白色'
    );

    protected static $allColorNames = array(
        '黑色', '昏灰', '灰色', '暗灰', '银色', '亮灰色',
        '庚斯博罗灰', '白烟色', '白色', '雪色', '铁灰色',
        '沙棕', '玫瑰褐', '亮珊瑚色', '印度红', '褐色',
        '耐火砖红', '栗色', '暗红', '鲜红', '红色', '柿子橙',
        '雾玫瑰色', '鲑红', '腥红', '蕃茄红', '暗鲑红',
        '珊瑚红', '橙红', '亮鲑红', '朱红', '赭黄', '热带橙',
        '驼色', '杏黄', '椰褐', '海贝色', '鞍褐', '<?php

namespace Faker\Provider\zh_CN;

class Payment extends \Faker\Provider\Payment
{
    /**
     * @see https://zh.wikipedia.org/wiki/%E4%B8%AD%E5%9B%BD%E9%93%B6%E8%A1%8C%E5%88%97%E8%A1%A8
     * @var array
     */
    protected static $banks = array(
        '渤海银行',
        '广发银行',
        '国家开发银行',
        '恒丰银行',
        '华夏银行',
        '交通银行',
        '平安银行',
        '上海浦东发展银行',
        '兴业银行',
        '招商银行',
        '浙商银行',
        '中国工商银行',
        '中国光大银行',
        '中国建设银行',
        '中国民生银行',
        '中国农业银行',
        '中国银行',
        '中国邮政储蓄银行',
        '中信银行',
    );

    /**
     * @example '中国建设银行'
     * @return string
     */
    public static function bank()
    {
        return static::randomElement(static::$banks);
    }
}
