<?php

namespace Faker\Provider\zh_CN;

class Person extends \Faker\Provider\Person
{
    protected static $maleNameFormats = array(
        '{{lastName}}{{firstNameMale}}',
    );

    protected static $femaleNameFormats = array(
        '{{lastName}}{{firstNameFemale}}',
    );

    /**
     * According to http://baike.baidu.com/view/6109935.htm,
     * these are the top 300 lastnames from the 6th Chinese national census of population,
     * containing 299 single-character surname and 1 double-character surname '欧阳',
     * so you can get random names including double-character surname but not too many.
     */
    protected static $lastName = array(
        '李','王','张','<?php

namespace Faker\Provider\zh_CN;

class Internet extends \Faker\Provider\Internet
{
    protected static $freeEmailDomain = array(
        'gmail.com', 'yahoo.com', 'hotmail.com', '126.com', '163.com', 'qq.com', 'sohu.com', 'sina.com'
    );
    protected static $tld = array(
        'com', 'com', 'com', 'com', 'com', 'com', 'biz', 'info', 'net', 'org', 'cn',
        'com.cn', 'edu.cn', 'net.cn', 'biz.cn', 'gov.cn', 'org.cn'
    );

    protected static $userNameFormats = array(
        '{{word}}.{{word}}',
        '{{word}}_{{word}}',
        '{{word}}##',
        '?{{word}}',
    );
    protected static $emailFormats = array(
        '{{userName}}@{{freeEmailDomain}}',
    );
}
