<?php

namespace Faker\Provider\nl_NL;

class Text extends \Faker\Provider\Text
{
    /**
     * Project Gutenberg's Dichtertje - De Uitvreter - Titaantjes, by Nescio
     *
     * This eBook is for the use of anyone anywhere at no cost and with
     * almost no restrictions whatsoever.  You may copy it, give it away or
     * re-use it under the terms of the Project Gutenberg License included
     * with this eBook or online at www.gutenberg.org
     *
     * Title: Dichtertje - De Uitvreter - Titaantjes
     *
     * Author: Nescio
     *
     * Release Date: August 17, 2009 [EBook #29719]
     *
     * Language: Dutch
     *
     * *** START OF THIS PROJECT GUTENBERG EBOOK DICHTERTJE - DE UITVRETER  ***
     *
     * Produced by Mark C. Orton and the Online Distributed
     * Proofreading Team at http://www.pgdp.net/
     *
     * Nescio
     *
     * Dichtertje
     *
     * De Uitvreter
     *
     * Titaantjes
     *
     * J. H. de Bois - Haarlem.
     *
     * "Dichtertje" is hier voor het eerst gepubliceerd.
     * "De Uitvreter" verscheen in "De Gids" van Januari
     * 1911. "Titaantjes" in "Groot-Nederland" van Juni 1915.
     *
     * @see http://www.gutenberg.org/cache/epub/29719/pg29719.txt
     * @var string
     */
    protected static $baseText = <<<'EOT'
DICHTERTJE.

                                            In 't derde oorlogsjaar.
                                            Bellum transit, amor manet.


I.


Tweemaal schudde de God van Nederland zijn eerbiedwaardig hoofd en
tweemaal schoven z'n eerbiedwaardige grauwe bakkebaarden heen en weer
over z'n vest.

't Klopte niet. Ergens moest een fout zijn. Een dichter met nergens
haar, dat was heel vreemd. Sedert dertig jaar hield de God van
Nederland niet van dichters. Je wist niet meer, wat je er aan
had. Fatsoenlijk of onfatsoenlijk, je kon er niet uit wijs. En nu dit.

"Hij heeft gezegd, dat hij vol van mij is. Vroeger kon je daar op aan."

God zuchtte. Hij zou er morgen eens met Potgieter over spreken. Je
had tegenwoordig niets dan narigheid aan je hoofd.

Daar beneden in de Leidsche straat liep een meisje. Met vaderlijk
welgevallen zag God op haar neer. Het meisje was als honderde andere
meisjes dien zomer, heelemaal in 't wit, zijden blouse, korte frotté
rok, witte kousen, fijne enkeltjes en lage witte schoentjes en had
lieve oogen als honderde andere meisjes in Amsterdam. Oogen die kijken
alsof ze iets heel bijzonders weten. Dat vonden ze ook weer niet
goed. Nooit had ons Lieve Heer daar vroeger iets bij gedacht. En nu
hatti kwestie. 't Was begonnen met versjes over "wetende oogen." Toen
zei er één, dat 't allemaal bedrog was, een vroom bedrog van God. Dat
ze niets wisten en alleen maar keken alsof, zonder dat ze 't konden
helpen. Nooit had God er over nagedacht.

Tegenwoordig brachten ze hem over alles aan 't denken. En 't was toch
zoo noodig, dat de hoofden bij de zaken werden gehouden. De keizer had
't nog onlangs weer gezegd: "Der Tüchtigkeit ist die Welt".

Maar als je eenmaal over iets aan 't prakkizeeren raakte kwam je er
zoo makkelijk niet weer af. Nu i er eenmaal op lette, zag i honderde,
duizende van die meisjes, telkens weer anderen en telkens weer
dezelfden. Zoodat i soms niet meer wist of i er tienduizend had gezien
of één, tienduizendmaal. "Heer in den hemel had hij al die meisjes
geschapen? Of was 't een grapje van den duivel, al die wetende oogen?"

Kijk, daar gaat 't dichtertje. Toch wel een knap, jong ventje,
zoo slank, zoo'n aardig gladgeschoren jongensgezicht, alleen een
paar stutten voor de ooren, en zoo verbrand door de zon. Hij groet
iemand. Z'n strooien hoedje lichtten-i even op van zijn kort geknipte
haren.

Raar toch, zoo kaal, maar 't was toch vast wel een dichtertje, want
God begreep niets van 'm en Potgieter ook niet. En professor Volmer
verachttenem.

En hij leed ijselijk van die wetende oogen, zooals geen rechtschapen
mensch. De duivel hattem leelijk te pakken. Hij was een zwak
dichtertje, kindsch werti er van. Hij bleef fatsoenlijk van zwakte. Dat
was weer zoo iets raars, waar God vroeger nooit over gedacht had,
fatsoenlijk was fatsoenlijk en daarmee uit. 't Dichtertje wist niet
op wie hij verliefd moest worden. Als hij in twee wetende oogen
had gekeken, zag hij er dadelijk weer twee. Hij was zoo zwak, zoo
lekker zwak. Maar als i 't vijfentwintigste meisje zag, voeldeni zoo
iets raars in z'n hersens. Hij had al eens in 't voorbijloopen op 't
terras van een café een stoeltje omgeschopt van kwaadaardigheid. Want
hij wist wel, dat ze niets wisten, dat ze dom giggelden, alleen al
als i z'n hoed voor hen af nam, of strak keken, omdat ze stonken van
burgerjuffrouwen-ingebeeldheid. En toch kon i 't niet laten. En dan
moest i vluchten naar ergens, waar geen vrouwen waren en dan maakteni
zich kwaad op God en den duivel tegelijk en zei datti idioot werd
en datti nog eens met open mond jaren lang kwijlen zou, een leeren
slabbetje voor, zonder datti 't zelf wist. Maar den volgenden dag
keeki weer en dacht daarbij: "Mon âme prend son élan vers l'infini."

Potgieter zei dat de vent gek was en dat in den tijd van Piet
Hein........

Dichtend vervolgde 't dichtertje z'n tocht door de woestenijen van
Amsterdam. Zoover 't oog reikte, niets dan Nederlandsche menschen. Weer
groette-n-i iemand, een heer met hoogen hoed en gekleede jas, uit
een stuk van Verkade. Nu spraken ze elkaar aan. Daar stonden ze, op
't plein voor 't Centraalstation.

Op den beganen grond liep God nu met z'n gelen strooien deukhoed,
z'n wandelstok met zilveren greep, z'n jas hing slobberig en breed
en ondefinieerbaar bruinig over z'n rug, op z'n kraag lag roos,
z'n broekspijpen waren te wijd en te lang en lagen met plooien op
z'n schoenen. Z'n bakkebaarden kon je van achteren zien en toen i
bezadiglijk de twee treden opstapte om in 't station te gaan, glom
de lage avondzon in Gods gepoetsten linkerschoen.

"Wie was die meneer?" vroeg 't dichtertje. "God" zei de duivel en
de knobbels op z'n voorhoofd werden grooter. 't Dichtertje sprak
niet. "Jouw God, de God van je baas en van je schoonvader en van je
baas z'n boekhouder en van den gérant van de "Nieuwe Karseboom". De
God van je tante, die zei, dat je moest groeten als je langs 't
huis van je baas kwam in Delft of Oldenzaal, waar was 't ook weer,
ook al zag je niemand, je kon nooit weten wie 't zag. Van je tante,
die je zuster altijd liet breien. "Een vrouw mag niet stilzitten." De
God van al die menschen, die zullen zeggen: "Dat had ik van jou niet
gedacht," als je nog eens probeert te leven en die zullen zeggen:
"Dat had ik altijd wel gedacht, dat kon niet goed gaan," als je
later in 't werkhuis moet. De God, die niet hebben kan, dat je 's
Zaterdagsmiddags vrij bent, de God van meneer Volmer, hoogleeraar in
't boekhouden en de bedrijfsleer, die vindt, dat je veel te veel
naar de lucht kijkt. De God van allen die geen andere keus hebben
dan werken of vervelen. De God van Nederland, van heel Nederland,
van Surhuisterveen en Spekholzerheide, donateur van den Bond van
hoofden van groote gezinnen en van de Vereeniging tot opheffing van
gevallen vrouwen. Dat noemen ze vallen. Ik ben ook gevallen."

"De beeldspraak is inderdaad gebrekkig", zei  't dichtertje, absent.

Hij had al dien tijd gekeken naar een dame, die daar stond te
wachten. Naar de aardige scherpe achterkantjes van haar beenen,
vlak boven de lage witte schoentjes. Natuurlijk had ze lage witte
schoentjes aan met korte rokken en erg open geweven kousen, waar haar
beenen wit doorheen schemerden. "Nu vallen", dacht 't dichtertje.

"Mon âme prend son élan vers l'infini," zei de Duivel en glimlachte
ironisch, zooals hij een eeuwigheid lang geglimlacht had.

Toen zag 't dichtertje 't stationsplein weer en den duivel en hoorde
wat die gezegd had.

"Duivel" zei-di, "mij belazer je niet."

De duivel haalde even z'n schouders op en keek naar de
stationsklok. Tien minuten over zevenen. Hij gaapte achter z'n
hand. De eeuwigheid schoot niet op. En eigenlijk hatti ook al zooveel
dichtertjes gekend. Waarom sprak i nog zooveel?

't Dichtertje liep naar huis en keek in de hoogte naar 't gevleugelde
wiel, dat midden op de leuning van de hooge spoorbrug over de
westelijke doorvaart op een kleine ijzeren zuil staat en vliegen
wil en nooit van z'n plaats komt en gezien wordt uit vertetjes waar
't nooit komt, wel heel van de Torensluis, 't Singel af. De blauwe
lucht was er nog zoo hopeloos ver boven. Zelfs de palen met de
booglampen, aan 't begin en 't eind van de brug, staken hoog boven
't wieltje uit. 't Geeft niet veel of je op een spoorbrug staat op
een ijzeren zuiltje. Je kunt er hoogstens van aan 't denken raken
en dat deugt heelemaal niet. En 't dichtertje dacht, dat je beter
zoo'n wiel kunt wezen dan een dichtertje. Zoo'n wiel is van ijzer,
maar een dichtertje niet.

Onderwijl zat God alleen in een coupé eerste klas in den trein naar
Delft en staarde uit 't raampje, maar zag niets. Uitkijken deed hij
nooit. In z'n hand hielti een rapport. Naast 'm lagen dossiers.

De God van Nederland dacht. Het was een rare tijd. Weer las God:

"Het lot van den mensch is verdriet te hebben, wanneer hij z'n doel
niet bereikt en wanneer hij z'n doel bereikt heeft.

"Er is geen troost in de deugd en er is geen troost in de zonde.

"Daarom laat blijmoediglijk af van alle verwachting. Stel uw hoop op
de eeuwigheid: uit dezen droom is geen ontwaken."

Het was wel een rare tijd. Zoo kon 't niet goed gaan. En nou hatti
nog wel gezegd, dat een nieuw tijdvak was aangebroken. De tijd van het
"ironisch dilettantisme" was voorbij, een nieuwe tijd van "baanbrekend
optimisme" en "frissche daadkracht" was begonnen. Dat hatti zoo maar
's gezegd. En weer zuchtend begon God toen 't manuscript te lezen
van een dik boek over 't Taylor systeem.




II.


't Dichtertje was nooit gevallen.

Een groot dichter te zijn en dan te vallen. Als 't dichtertje er over
dacht, wat hij eigenlijk 't liefst zou willen, dan was 't dat. De
wereld ééns te verbazen en ééns een liaisonnetje te hebben met een
dichteres. Jarenlang had hij dit telkens weer gedacht, naïvelijk.

't Dichtertje was fatsoenlijk getrouwd met een lief, jong, levendig,
natuurlijk vrouwtje. Natuurlijk was hij onmiddellijk verliefd geworden,
toen hij de wereld begon te zien. 's Morgens zag hij haar als hij naar
kantoor ging en zij naar school, en 's middags om kwart over eenen "in
't beursuur", als hij op straat mocht en zij uit de melkinrichting
kwam, waar zij haar boterhammen met een glas melk at en soms een
roomhorentje of een taartje met slagroom, haar boterhammen.

En ze was wat kwaad op 'm, omdat i daar altijd zoo stond, gewoon
bespottelijk. De andere meisjes noemden 'm "'t Ideaaltje", omdat
i een keep droeg en zulk mooi zwart haar had, (toen liet-i 't nog
niet kortknippen). En ze keken naar 'm, als ze met hun drieën gearmd
langs hem heen liepen, heel even keken ze en giggelden tegen elkaar,
de beide buitensten de hoofden gebogen naar de binnenste, die ook
giggelde en naar den grond keek. Maar zij liep statig voorbij en zag
hem niet en zei tegen Mien Bus datti om haar kwam en dan lachten ze
allemaal, want ze wist wel beter. Op den grond stampte ze met haar
schoolmeisjesvoetje van zeventien jaar. "Om mij? die engert?" en
hield haar hoofd achterover.

En hij was ongelukkig en telde de uren. 's Avonds om elf uur keek
i naar de lucht, de helft was om tusschen 's middags half twee en
's morgens half negen. En hij dichtte.

Hij maakte gedichten naar Heine, Hollandsche en Duitsche, en naar
Héléne Swarth en naar Kloos en van Eeden. "De Uren":


    "Hoe gaan de uren zoo zwaar met loggen tred".


"Die Kreuzfahrer":


    "Dort unten lag die heilge Stadt in ihrer Glorie".


Dat was zij. Maar de poorten waren dicht. En hij vroeg zich af waarom
hij verder leefde. En hij werd opstandig tegen God.


    "Mijn God, zal dan mijn kwelling nimmer einden?"


En de lui op kantoor kon i niet zien en hooren, als i om kwart over
negenen op kantoor kwam hatti er wel een willen slaan, zoo maar. En
van somber werti extatisch. En dichtte weer. "Mijn heilig lief". "Nu
is de wereld een groot zomerland".


    "God gooide de poorten des hemels open,
    Mijn zoete lief zat op een gouden troon".


Dat duurde zoo elf maanden. Daar kwamen nog drie maanden bij datti
buiten was, een klein betrekkingkje had in een stadje, waar ze nu
nog praten over dien mallen kerel.

Toen kreeg i haar. Negentien jaar was i. Hij schreef haar een briefje
datti twee dagen in Amsterdam was en datti haar graag wilde spreken. Ze
kenden elkaars namen, Amsterdam is ten slotte ook maar een dorp. Ze
hattem die honderd dagen erg gemist en ze kwam. Haar moe vond 't goed,
"als 't een nette burgerjongen was en ze hield van 'm....., maar
geen scharrelpartij." Ze kwam, 's avonds bij de Muiderpoort en hij
zei dat ze zeker wel begreep, watti haar vragen wou. 't Was zoo raar,
zoo gewoon, hij kon heelemaal niet dichten. En ze zei natuurlijk dat
ze 't niet begreep, maar toch liepen ze samen maar de Sarphatistraat
op. 't Gesprek liep wat moeilijk, wat moest je mekaar vertellen, je
kende mekaar nog zoo heelemaal niet. Hij had gedacht, dat i wonder
wat zeggen zou, dat de woorden zóó maar zouden komen met geweld,
zooals de breede Waal jaagt langs de schuitjes van den ponton-steiger
bij Nijmegen.

En nu spraken ze over z'n betrekking in dat stadje en over hun
ouders. En voor haar huis namen ze afscheid en hij gaf haar een zoen,
heel links, op haar voorhoofd. En ze was wat in haar schik, ze had een
vrijer en zoo'n knappe, wat zou Loe wel zeggen. Jammer datti buiten
woonde. Zoo vervelend, vooral 's Zondagsmiddags als i dan niet over
kwam, dan moest je thuis blijven.

Den tweeden avond mochti boven komen, 't moest gauw gaan, want hij
had maar twee dagen vrij.

Z'n pa was bij haar vader op bezoek geweest en nu mochti
bovenkomen. Daar zaten haar vader en de zijne en haar moeder en een
grootmoeder en een tante. Haar twee kleine zusjes waren vroeg naar
bed gestuurd. En toen kreeg i haar en de tante zei later "wat een
nette jongen".

's Zondagsmiddags natuurlijk zij op visite bij hem thuis en daar
was toevallig een nicht met scheeve schouders in een scheeve groene
hobbezak en een lorgnet op, die bier dronk en Coba was allerliefst
voor haar aanstaande schoonmoeder en die was allerliefst voor Coba.

"Wat heb je daar een snoezig taschje." "Uit 't City-magazijn?" "Nee,
van Liberty". "Je ziet tegenwoordig heel veel van die taschjes met
een klein taschje buitenop." "Nee, die vind ik om de waarheid te
zeggen niet zoo aardig." "Och, ieder z'n smaak. Onze Riek heeft zoo
één en die vind ik ook heel aardig". En hij zat er bij en begreep er
niets van. Had hij 's nachts op straat geloopen en gezegd, dat God
de poorten des hemels open gooide? Wat raar.

Maar ze was heel lief, jong, levendig en natuurlijk en zoende 'm niet
op z'n voorhoofd, maar flink op z'n lippen en op zij in z'n nek, in
den gang, voor ze de kamer binnen gingen. Daar moest ze voor op haar
teenen gaan staan en z'n schouders beetpakken. En ze ging heel veel van
'm houden en hij hield ook veel van haar en drukte haar tegen zich aan.

Maar de zaak bleef 'm duister en dichten deedi niet meer tot i
getrouwd was.

En nu waren ze zes jaar getrouwd en hadden een kindje, een meisje van
vijf jaar, een snoes die door alle tantes geknuffeld werd. Zij had
een beetje geld en hij had een beetje geld en hij had in Amsterdam
een baantje gevonden, datti niet al te slecht waarnam en ze waren
ten naaste bij gelukkig.

Maar daar i een echt dichtertje was, moest hem iets ontbreken. Wat is
voor een dichtertje iets dat hij heeft? Datti zoo maar heeft, dag in,
dag uit. Al die dagen. En altijd getrouwd is zoo erg lang. En een
heel lief, jong, levendig en natuurlijk vrouwtje, dat veel van haar
man houdt en zijn manuscripten in 't net schrijft, maar tweeduizend
nachten naast 'm heeft geslapen  en weet datti niet tegen tocht kan
en 's morgens niet uit zijn bed kan komen en niet van de jam af kan
blijven, al is i een dichter, dat is nu echt iets voor den Duivel.




III.


Een groot dichter zijn en dan te vallen. Maar er kwam nooit wat
van, want als je een dichtertje bent, dan loopen de mooiste meisjes
altijd aan den overkant van de gracht. En zoo werd z'n heele leven
één gedicht, wat ook vervelend wordt.

In de tram zat hij en dichtte zoo stilletjes voor zich heen, met
z'n twee handen op den knop van z'n wandelstok zatti te staren en
onderwijl te denken, datti zulke mooie blanke, fijne en slanke handen
had, zooals dichtertjes dat doen. 't Was Zondagavond in November
tegen zessen, de straten waren donker en verlaten. Een dame van een
jaar of zes en twintig kwam de tram binnen, statiglijk, rijzig in
haar bruine mantelpak, de opstaande kraag, manchetten en onderkant
van mantel en rok afgezet met zwart bont, de handen in een groote,
afhangende mof van 't zelfde bruine laken met 't zelfde bont bezet,
klein bruin hoedje met zwart bont op 't fijne gezichtje. Alles echt
lijn 2, Museumkwartier.

't Dichtertje keek even op, recht in haar oogen, maar zij zag alleen
't leege plaatsje in den hoek en ging hem voorbij, statiglijk. Achter
haar kwam haar man, gladgeschoren, in 't zwart, met een hoogen hoed
op z'n grijzend, kort geknipt haar.

Toen ze zat kon 't dichtertje haar niet zien, want hij zat op de
zelfde bank vooraan en er waren vier menschen tusschen.

Meneer zat correct rechtop tegenover haar, keek op z'n horloge en
zei iets, hoe laat 't was natuurlijk. Daarna spraken ze niet meer. Ze
waren ongetwijfeld getrouwd.

't Dichtertje dacht, dat ze op bezoek waren geweest en naar huis gingen
om te eten. En of ze een kindje zou hebben of kindertjes. En of haar
man zich correct zou gedragen in de slaapkamer. God liet 't gebeuren,
dat hij hem duidelijk voor zich zag, daar in die tram, in z'n enkele
hemd en sokken, een jaegerhemd, ja natuurlijk jaeger, grijs, niet
mooi wit, hij was zeker in de veertig en met wat malle, uitstekende
haartjes op z'n bloote beenen, en z'n hooge dop op. Jammer dat i
niet brilde. En hij hoorde hem vragen met z'n correcte Museumkwartier
geluid: "Zal ik 't licht aan laten, Clara?" Want ze heette natuurlijk
Clara, de schitterende. En 't dichtertje dacht datti "pardon" tegen
haar zou zeggen op een gegeven oogenblik. Ja, God laat de gedachten
van een mensch raar dolen en er komen vreemde passages voor in zoo'n
gedicht zonder eind.

Toen keek 't dichtertje op door 't ruit van de tram tegenover hem. De
huizen waren alle donker en de dames die dit lezen weten wel, dat je
dan alle passagiers heel duidelijk weerspiegeld ziet, buiten.

En de peinzende oogen van 't dichtertje zagen toen recht in de
peinzende oogen van Clara, de schitterende, die keken alsof ze iets
heel bijzonders wisten, wat bedrog is. Even werden de vier peinzende
oogen grooter en schitterden, toen dorst 't dichtertje niet meer,
want hij was een welopgevoed mannetje, al hatti rare kronkels in z'n
eindelooze gedicht en hij keek naar 't bruine laken en 't zwarte bont
en naar den vagen vorm van haar beenen in den rok en toen keek hij
met geweld naar een onderhuis, waar een melkboer woonde, 't gordijn
was neer om den Zondag. Als je wilt kun je door die weerspiegeling
heen kijken en de P. C. Hooftstraat is erg achteruitgegaan, jaren
geleden had je daar geen melkboer, nu is er zelfs een aardappelen
en groentenwinkel.

Maar toeni daarna weer keek hoe een van haar haren los was gegaan en
voor haar linkerslaap hing, zoo lief, zoo gegolfd, toen ontmoetten hun
oogen elkaar weer, even. "Ik vind jou mooi, vind jij mij mooi?" "Ik
wil je hebben als ik durf, wil jij mij hebben als je durft?" "Even
wil ik een levend mensch zijn, even vrij, een Godin, geen dame van 't
Museumkwartier, geen dochter van die, zuster van die, vrouw van die,
moeder van die, vriendin van Mevr. die. Even, in mijn gedachten. Mijn
gedachten gaan naar jou door mijn oogen, mijn gedachten kunnen wijd
en zijd gaan, vooruit en achteruit in den tijd, door alle bedeksels
gaan mijn gedachten. Niemand kan hen vatten of deeren, naar jou gaan
mijn gedachten door mijn oogen."

En zoo gingen zijn gedachten naar haar, door zijn oogen in de hare
in deze luttele seconden. En niemand wist er van.

En een hooge toren verrees uit zijn geest en een hooge toren uit
den hare. En ze zagen wijd en zijd over alles heen en alleen elkaar
zagen ze.

Zoo dichtte 't dichtertje z'n eindelooze gedicht verder en de domste
vrouw kan dat meedichten.

Maar bij elkaar komen konden ze niet en dat was misschien juist
't mooie.

Bij de Hobbemastraat keek haar man even naar den conducteur en direct
ging die z'n hand naar de schel. En ze stond op en liep achter haar
man door de tram, correct en statig en zag niemand.

Maar terwijl meneer afstapte en zij wachten moest op 't balcon voor
den ingang, haar linkerschouder naar 't dichtertje, en toen 't bijna
gedaan was, toen overwon ze nog even één ondeelbaar oogenblik 't
Museumkwartier en keek.

"Ik vind je mooi en jij vindt mij ook mooi. Mijn hart zingt in mijn
lijf en m'n hersens zingen onder m'n haren. Mooi haar, hé?"

En 't dichtertje dichtte z'n gedicht voort, eindeloos. Maar 't werd een
somber gedicht, zoolang 't duurde, en Amsterdam was donker en ledig.

Als een echt belachelijk dichtertje heeft i daarna nog een paar maal
's middags in 't Museumkwartier gedwaald, waar i zich altijd erg arm
voelde en nooit zeker was of z'n das wel goed zat en z'n boordje wel
schoon was en of i er heelemaal wel beschaafd genoeg uitzag. Maar hij
zag haar natuurlijk niet meer, mogelijk woonde ze heelemaal niet eens
in Amsterdam. Er was een huis op een hoek met een klein tuintje er
om en daar groeide een klimstruik tegen den muur. Die bloeide in 't
zachte Novemberweer zonder blad, met kleine gele sterbloemetjes. En
hij maakte voor zich zelf uit, dat ze daar woonde en de bloeiende
struik noemde hij "Clara".

Toch hield i wel van z'n vrouwtje en z'n vrouwtje hield veel van hem
en ze lieten 't mekaar aan niets ontbreken.

Waarom heeft God ook een mensch tot dichtertje gemaakt?




IV.


De duivel heeft altijd schik in lieve, jonge, natuurlijke vrouwtjes,
die veel van hun wettigen man houden. Als ze een jaar of wat getrouwd
zijn krijgen ze een vreemd heimwee naar een land, dat ze kennen. Maar
ze zijn er toch nooit geweest. Hoe kunnen ze verlangen naar iets dat ze
niet kennen? Hoe kun je iets kennen dat je toch niet kent? Vreemd, wat
missen ze? En zingende zetten ze in den voorjaarsmorgen de balkondeuren
open en ineens zijn ze weer vaag droevig. Waarom toch? C'est là,
c'est là qu'il faut être. La? Waar? "'k Ben mal". En ze drukken hun
kindje tegen zich aan en zoenen 't erg.

Coba zit op 't terras van de "Beursbengel", op 't Damrak, aan zoo'n
tafeltje met zwaar rond marmeren blad, met een koperen band om den
kant. Haar kindje zit tegenover haar, de bloote beentjes van het kindje
met witte halve kousjes bengelen voor haar stoeltje. Het krijgt een
taartje met een glas melk. 't Eet met haar kleine vingertjes, haar
lekkere oogen zijn zoo groot en kijken zoo overal heen. 't Kindje
is onder den indruk van zoo iets heerlijks en al die menschen, maar
't is erg blij. Moedertje kijkt of 't kleintje niet morst en helpt
haar zachtjes, maar zegt niet veel.

In den hoek zit de duivel en draait z'n snor op. Eens heb ik een
vrouw hooren zeggen, een hoogstaande vrouw: "Zoo'n vent, wat verbeeldt
zich die wel? Een man die denkt dat ik verliefd zal worden, omdat i
zich zelf aan een brok haar trekt, bah." Vertrouw die vrouw niet te
veel. Nu ligt ze 's nachts wakker en bijt in haar natte kussen.

Coba trekt haar manteltje uit, legt 't over haar knieën, 't is te
warm voor een blauw cheviotten mantelpakje. Een wit bloesje heeft ze
aan, haar armen schijnen er door, zoo rose-bruin en 't allerbovenste
van haar rug en borst. Je ziet waar haar hemd eindigt en dat 't
met kanten strooken van haar schoudertjes hangt. Nu trekt ze haar
bovenlip even naar binnen en maakt haar onderkaak langer en strijkt
met de rechterhand haar haar glad, ze draait even met haar hoofd en
't puntje van haar tong komt te zien en strijkt langs haar bovenlip en
verdwijnt schielijk. De duivel draait aan z'n snor. Nu praat ze lief
met haar kindje, ze lacht, al haar tanden laat ze zien; ze heeft een
sterk gebit, alle tanden staan aangesloten en ze zijn schitterend wit,
om haar zoo je hand voor te houden, dat ze er in bijten kan, aan den
buitenkant tusschen pink en pols. Het is in 't begin van Mei. Voor 't
eerst van 't jaar heeft ze een bloese aan die driehoekig is uitgesneden
en ook haar borst is wit, zoo erg wit, dat de duivel moet denken aan
het licht uit den hemel. En de hoeken van haar sleutelbeenderen bij 't
kuiltje van haar hals staan zoo pittig. Met haar slanke vingers strijkt
ze langs den rand van haar bloese. Nu veegt ze de handjes van haar
kindje af en haar toetje, met haar zakdoekje, dat een opengewerkten
rand heeft. En ze neemt 't handje van 't kind in haar twee handen
en drukt 't en geeft haar een zoentje op haar groote oogjes en 't
kindje vraagt: "Maatje, waarom doet u dat?" En ze kleurt en vraagt:
"Wat, Bobi?" "Waarom zoent u me ineens?" "Maar kindje, maatje zoent
je toch wel meer ineens? Wil Bobi nog een taartje? Maar dan moet
je je niet zoo vuil maken, hoor. Zal mammi 't zelf gaan uitzoeken
voor kindje? Zoet blijven zitten hoor!" En maatje gaat naar binnen,
haar heupen draaien heel even en haar blauw cheviotten rok gaat heen
en weer. En dan komt ze terug met 't taartje op een schaaltje en uit
de deur lacht ze tegen haar kindje en ze gaat weer zitten. De duivel
draait aan z'n snor. En dan in eens wordt ze bang. Als i haar eens
aansprak? Wat moest ze doen? "Kom Bobi, maak voort, wacht, zal ik je
helpen?" En op de punt van 't vorkje steekt ze haar 't halve taartje in
't mondje, 't is of de dikke dame naast haar draait. 't Kindje heeft
't toetje vol slagroom. "Bah, wat een vies kindje." "Mammi, dat doe
je zelf." Daar is Pa. Hij groet en neemt z'n hoed af voor den duivel
en de duivel neemt z'n hoed af voor Pa. Maatje kleurt weer, nu tot
't kuiltje van haar hals. Maar 't dichtertje ziet dat niet, hij is
te lang getrouwd.

Ze staat op en helpt 't kindje van haar stoel. "Wil je meteen weg?" "Ik
moet nog wol koopen om mijn manteltje af te breien. Ik kan nergens de
kleur krijgen. 'k Ben in wel vier winkels geweest en toen dacht ik,
ik zal maar eerst hier naar toe gaan, want 't werd zoo laat." De oogen
van 't kindje worden heel groot en kijken naar boven naar maatje. "Nou
vooruit dan maar, heb je betaald? aanneme!" Dichtertje dopt, de duivel
dopt, maatje knikt stijf. Bobi wuift met haar handje en zegt met een
hoog stemmetje: "Dag meneer." De duivel knikt en lacht en knijpt een
oog dicht. "Maatje, die meneer heeft al dien tijd naar u gekeken."

Gelukkig, 't dichtertje hoort niets, zijn gedicht zonder eind is weer
in een stadium datti er stapel zot van wordt. Hij ziet op dat terras al
die vrouwen zitten en er gaan er voorbij op straat. "O God," denkt i,
"als er nu eens een wonder gebeurde, als nu eens in eens van al die
vrouwen al de kleeren afvielen?" Een dichtertje dat den waanzin nabij
is denkt rare dingen. U en ik lezer denken nooit zoo iets. En mijn
lezeressen..... heilige onschuld, ik moet er niet aan denken.




V.


Zes jaar waren ze getrouwd. En terwijl zij iederen morgen brood sneed
en boterhammen smeerde en thee schonk voor hem, voor kleine Bobi, voor
't dienstmeisje en soms voor de werkster.... Snijd eens één keer brood
en smeer eens boterhammen voor vier kinderen, als je 't niet gewend
bent, wat de ongelukkige schrijver van deze geschiedenis eens gedaan
heeft, volslagen uitzinnig word je d'r van. Op d'n duur zal 't wel
wennen, maar o lieve Heer, op den duur moet 't toch ook afgrijselijk
vervelend wezen, als je 't ongeluk hebt er over na te denken.

Nu dan, terwijl zij voortdurend dit alles weer deed, behaagde 't
God, den echten God van hemel en aarde, Dora, haar zusje, te doen
opgroeien en vrouw worden, zoo mooi als een renpaardje. Zij was een
van die twee zusjes, die in bed waren gestopt, toen i voor 't eerst
boven mocht komen.

Het duurde lang voor hij haar zag. Maar zij had hem allang
gezien. Vijftien jaar was ze toen. Hij was pas getrouwd, iets meer
dan een jaar en kwam van een reis terug, heelemaal verbrand. Een
licht grijs pak had hij aan en bruine schoenen en een wit hoedje
met heelemaal neergeslagen rand. Toendertijd gooiden ze je in de
Reinwardtstraat nog met steenen als je den rand van je hoed heelemaal
neergeslagen had, nu mag 't. Zijn schoonouders woonden toen op 't
land, ergens bij den IJsel in een wit huisje met een serre, en een
weranda langs de bovenverdieping. Ze was nog nauwelijks meer dan een
kind, haar rokje kwam maar halverwege tusschen knie en enkel. Nu
loopen de volwassen vrouwen zoo. Ze had een jurkje aan met banden
over de schouders, met dikke roode strepen verticaal, daartusschen
smalle witte strepen. De schouderbanden waren enkel rood. In dit
hooge jurkje dat over de borsten reikte, droeg ze een wit bloesje
met stijven opstaanden kraag. Ook haar gezichtje was gebruind. 't
Donkere haar droeg ze met een scheiding en van achteren loshangend
in een zwarten strik. Ze was blootshoofds en speelde op 't gras voor
't huis als een kind diabolo, voor 't laatst, maar dat wist ze niet.

't Was in 't begin van Juni, de hooge boomen achter en op zij van
't huis waren een groene berg, massief. Hier en daar stond er een
bruine beuk tusschen. De roode meidoorn was uitgebloeid, de roode
bloemen van de kastanjes waren afgevallen, de ijle kaarsjes, die er
van waren overgebleven, stonden rechtop. De accaciá's bloeiden en
de jasmijn. De serre en alle drie de deuren aan de weranda stonden
wijd open. Er was een klein rond vijvertje voor 't huis met bladen
en witte bloemen van de waterlelie er in en riet en gele irissen aan
den kant. Voor den tuin liep de grindweg en aan den overkant van
den weg en ook aan deze zij er van, links en rechts van den tuin,
stond alom de groene rog manshoog.

Met de geheven armen wijduit ving ze de diabolo op 't touw, maar hij
viel en toen ze zich bukken wilde zag ze den man van haar zuster.

"Dag Dora, ken je me niet meer?"

Hij zag een kind en 't grasveld, en 't vijvertje en 't witte huis en
de hooge boomen en de accacia's en jasmijn in bloei, op zij. Hij was
pas getrouwd en nog niet begonnen aan z'n gedicht zonder einde. Maar
zij zag hem, haar oogen werden groot, 't bloed gutste in haar lijf
naar boven. Waarom vloog ze haar zwagertje niet om z'n hals en zoende
'm? Dat had ze altijd gedaan, want hij was een lief zwagertje, die
bonbons en brochjes meebracht en rumboonen, de rumboonen stilletjes.

"Dag Ee," zei ze en gaf 'm een hand.

"Dora, wat zie je d'r lief uit, is m'n schoonmama thuis en m'n
schoonvader?" Hij wilde in haar wang knijpen, zooals hij dat "de
kinderen" altijd gedaan had, maar ze liep hard weg en viel 't huis
binnen. "Daar is Ee."

De diabolo lag op 't pad en de stokjes met 't touw op 't grasveld. Hij
raapte ze op en zoende z'n schoonmoeder en schudde den ouden heer de
hand met geweld. "Hier zusje, daar heb je je speelgoed! Is Em nog op
de kostschool?" En schoonmama, die graag zag zoenen in eer en deugd,
vroeg: "Hebben jelui mekaar al behoorlijk goeien dag gezegd?" Maar
zij ging haastig de kamer uit met 't speelgoed en liep naar boven en
stond op haar kamertje voor 't open raam. Gek, ze hijgde anders nooit,
nu haalde ze diep adem. En ze voelde met haar handen dat haar borsten
groot werden. En 't grasveld voor 't huis en 't vijvertje met de bladen
en de witte bloemen, met 't riet, dat zachtjes heen en weer ging en de
gele lissen en links aan den kant van den tuin de bloeiende accacia's
en de jasmijn bij het rhododendronboschje, dat uitgebloeid was en de
rogge over den weg, die golvend glansde, al die dingen leken zoo nieuw
en zoo mooi. De leeuwerikken zongen overal, een reiger vloog, de lucht
was zoo hoog en de boomen ruischten om 't huis en 't licht--kun je 't
licht pakken en aan je drukken en in je? Ze deed haar handen samen om
haar achterhoofd en voelde haar borsten optrekken. Toen rekte ze zich
heelemaal uit. De armen wijduit omhoog, als bij 't diabolospel. En
ze voelde de lucht doordringen tot onder in haar longen.

Kalm kwam ze de trap af en zong 't koor uit de Maccabeeën: "Dag vol
licht en hemelgloed," wat ze vaak had gezongen, zonder er veel bij
te denken. Toen ging ze de kamer binnen en zei: "Dag Ee", en ging
op haar teenen staan en rekte zich uit en zoende 'm op z'n mond, als
vroeger, zusterlijk. En hij, die een gesprek had met z'n schoonvader
over lijnolie, pas van de reis terug, wat moet een dichtertje al niet
doen, hij zei enkel:

"Kind, wat wor je groot, ik hoef je waarachtig niet eens meer op
te tillen."

En toen hield ze al zooveel van 'm, dat ze niet eens kwaad was omdat
ie dat zei. "Haar borsten werden immers al groot, wacht maar."

"Dora, de melk kookt over, Maartje is naar 't dorp." En Dora vlug
naar de keuken om 't stel uit te draaien.




VI.


Voor ik verder ga wil ik even vertellen dat ook mijn manuscripten door
m'n vrouw worden overgeschreven en dat ze de poëzie in dit verhaal
niet begrijpt. Dat Coba coquetteerde vindt ze niet zoo erg, dat kwam
doordat 't dichtertje haar verwaarloosde. Die dame in de tram had
een klap op haar gezicht moeten hebben en 't dichtertje ook. Gek,
in andere verhalen vindt ze zulke dingen niet zoo erg. 'k Denk dat
't komt doordat ik dit geschreven heb. Ze moet toch den auteur weten
te onderscheiden van meneer Nescio, maar dat gaat haar te hoog. De
situatie is voor mij pijnlijk, mijn huiselijk geluk is ietwat gestoord,
toch ga ik door.

Daar wandelt de God van Nederland weer op 't Damrak over 't gloeiende
asfalt. Weer heeft hij 't zelfde bruinige pak aan en denzelfden hoed
op en schilfertjes op z'n kraag. Nu heeft hij een zakdoek om z'n
boordje gelegd, voor 't zweten. Z'n wandelstok zetti een heel eind
van z'n lichaam neer. Z'n grauwige bakkebaarden wandelen mee.

God van hemel en aarde, van land en zee, neem deze benauwenis van mij
weg, schep 'm op uw ééne hand van 't Damrak en leg 'm zoetjes neer
op een belt, bij blauwe pannen zonder bodems en vertrapte blikjes en
verroeste hoepels van vaten en asch en garnalendoppen, ergens waar
ik nooit kom.

Nu kan mijn geest mijn verdomde zelf verlaten en recht naar boven
gaan als blauwe rook in een stillen zomeravond, als een verre koe
klagelijk loeit.

En nu is alles weg dat geweest is en ik ben Dora en in een nieuwe
wereld, die dezelfde is als de oude, maar gezien van de voeten des
Vaders, van waar ik ook neerzie op Dora, die ikzelf ben, een vrouw nu,
een meisje, zoolang de genade duurt.

En zooals de wereld thans nieuw is voor mij, zoo lag ze nieuw en
maagdelijk en goedertieren uitgespreid voor Dora na dien dag. O,
ze aanvaardde 't wonder, maar ze begreep 't niet en ze begreep zich
zelven niet, zooals de aarde zich zelve niet begrijpt, waaruit 't
koren groeit, dat groen is en geel wordt en wordt gemaaid en de hooge
garven staan op de gele stoppels en de aarde weet er niet van.

En haar borsten werden grooter, ze bewogen bij 't loopen. Toch was
ze een tenger meisje met een duidelijk kuiltje in haar hals, met
duidelijke peesjes en 't begin van haar sleutelbeenderen duidelijk
afgeteekend, net als haar zuster. En als ze 't hoofd op zij deed, zag
je een diep kuiltje op haar schouder als ze haar losse kiel aan had,
die vierkant was uitgesneden. In haar bruine gezichtje waren haar oogen
zoo wit en zoo donker blauw. Het wit was zooals ik eens de bevroren
Zuiderzee gezien heb. Maar uit 't blauw scheen al de warmte van haar
lijfje, dat toch niet koeler werd. En als ze dan met haar handjes op
haar rug stond, stevig op de beenen, de voeten een eindje van elkaar,
dan zag je de punten van haar schouderbladen en een holte daartusschen,
als een gedicht, die de gedachten trok naar verten, als een rivier,
die gestrekt ligt, ver, en zich dan wendt en waarvan je 't eind niet
ziet. En als ze haar hals boog, ze droeg 't haar nu opgenomen, dan
keek de God van hemel en aarde even op van z'n eeuwige contemplatie
der eeuwige landen en zeeën en leunde z'n hoofd op z'n rechterhand,
die steunde op z'n dij, de duim onder den kin en de wijsvinger langs
zijn wang en aanschouwde het bruine knobbeltje boven de holte, die
een gedicht was en de kleine haartjes die glinsterden in de zon en
glimlachte. Daarna keek hij weer ernstig langs z'n voeten en zag zijn
Rijn wenden tusschen zijn bergen en peinsde: "Hoe was hij er ook weer
toe gekomen, 't Duitsche rijk te laten stichten? Die Pruisen....."

En z'n edel, hareloos gelaat versomberde, er kwamen twee diepe plooien
boven z'n rechten sterken neus.

Maar zij dacht aan geen Pruisen. Zij dacht hoe een lieven man haar
zuster had en dat 't goed was van haar zwager te houden. Hij was toch
haar broer. En een dichter. Dat had Coba haar verteld. En een dichter
dat was een van hen, die God lief had. Dat had ze in een boek gelezen.

Ze was nu zoo oud, dat ze verheven boeken las met een mondje vol
chocola en de rest van de reep op 't tafeltje.

Als zij ook eens dichten kon of--schrijven. Een boek over jonge
liefde. Jonge liefde, daar las je toen veel van. En als ze 's avonds
aan den IJseldijk lag, de fiets naast haar plat in 't gras, met een
grasje in haar mond, dat ze om en om draaide en over 't water keek,
waar 't zeil van een tjalk met geraas zakte langs den mast en slap
viel, dan probeerde ze het. Maar er kwam niet veel. Ze werd wel heel
week van binnen, haar hartje en haar longetjes werden zoo groot en
zoo weemoedig vol. Ze voelde 't avondlandschap in haar ruggestreng
van boven tot onder. De koeien, die in 't water stonden en dronken
en zichzelf zagen, 't rammelen van de ankerketting, 't licht dat
opgetrokken werd aan den mast van de tjalk, ze brachten tranen in
haar groote oogen. Maar er kwam niets. 't Grasje in haar mond spleet
ze in de lengte met haar twee nageltjes, maar er kwam niets.

Ze stond op. Aan de bleeke lucht schenen de sterren, 't water rimpelde
en warrelde en draaide en stroomde alsof er geen Dora stond in den
kleureloozen zomeravond. Een zware wagen kraakte moeizaam over den
grindweg in de verte. Weemoed steeg op uit 't duisterende land,
't water hield nog wat licht.

Toen strekte ze de handen uit, maar er was niemand die antwoordde. Toen
wist ze niet of ze sterven wilde of leven en reed langzaam op haar
fiets naar huis terug, waar moeder zat te gapen met 't Nieuws van den
Dag onder de petroleumlamp en haar bril op de punt van haar neus. Zoo
keek ze Dora strak aan. Daarna zette ze haar bril af, vouwde 'm op,
voelde op de krant naar 't huisje er van en bukte omdat 't andere stuk
wel onder tafel zou liggen. "Hier moe." Toen stond moe op, vouwde
gapend de krant dubbel, keek op 't wekkertje dat op den schoorsteen
stond en zei geeuwend: "Kwart-over tienen."

Op haar kamertje kleedde Dora zich uit en rook de geur van haar eigen
warme schoone lichaampje. En een groot verlangen vulde haar opnieuw,
zooals 't avondlijke land haar met een groot verlangen had vervuld,
en ook de donkere rivier, die uitliep in een punt, die even lichtte
waar i zich wendde en verdween. Maar wat 't was, wist ze niet.

En in eens zag ze alles weer voor zich in 't donker van de kamer,
't water met de tjalk die geankerd lag met z'n licht in de mast,
de koeien aan 't water aan den overkant, dichterbij. Ze zag dat de
avond niet viel, maar opkroop uit 't land, voor 't eerst gaf ze zich
daarvan rekenschap. En ze zag vooral 't end van de rivier, de bocht,
die in een punt uitliep, waar een groenige lichte plek in 't water
was, daar waar de oever rondboog. En ze hoorde 't verre kraken van
den zwaren wagen over den grindweg.

"God, als 't eens waar was, dat U mij lief heeft," zei ze kinderlijk.

En ze droomde dien nacht, dat Ee wandelde met Coba op een wei, zij
in een wit linnen mantelpakje en hij heelemaal in wit flanel, met een
omgeslagen rand aan zijn broek en een platten stroohoed op en bruine
schoenen. En dat ze tegen elkaar lachten en hij haar zoende op haar
mond, vier zoenen achter elkaar en dat ze zich lachend losmaakte. En
dat zij, Dora, op haar zuster toeliep en haar armen om haar hals
sloeg en haar hoofd tegen haar schouder legde en zei: "Coba wat ben
je toch lief." En toen stond daar in eens haar moeder, nu met haar
bril boven op haar voorhoofd en zei, "dertien minuten over half twee."




VII.


Intusschen liep 't beminde dichtertje kalmpjes als een net
burgerheertje zijn wegje af naar z'n graf en op 't Damrak en op
't Rokin en in heel Amsterdam en overal ging 't verkeer z'n gang,
alsof er aan 't dichtertje niets gelegen was.

Hij maakte wat promotie in z'n betrekking en erfde een kleinigheid,
veranderde gaandeweg van kleermaker en schoenenwinkel, kocht toen ook
dat witte flanellen pak, rookte geregeld sigaren van vier cent inplaats
van tweeëneenhalf, had ten slotte zelfs een kistje in huis, droeg fijne
overhemden en niet meer van die dikke wollen sokken, waschte z'n handen
voor en na 't eten, en gaf iedere week enkele guldens uit in cafés,
alleen en met z'n vrouw. Hij verheugde zich in den beleefden groet
van z'n sigarenwinkelier en in de eerbiedige familiariteit van den
conducteur op lijn twee. Op kantoor werti door de jaren wat ijveriger,
begon wat van z'n werk te maken en het gebeurde zelfs datti 's avonds
terugkwam, ofschoon z'n baas de lui daar nooit om vroeg. De concierge
respecteerde hem steeds meer, hield 'm voor een heele geleerde. Zelfs
zijn tante uit Delft of Oldenzaal begon tegen 'm op te zien en knikte
goedkeurend als Coba haar verhaalde hoe haar neef vooruitging. Hij zelf
sprak er nooit over. Hij was nu geabonneerd op 't Volk, 't Handelsblad
en de Groene, lid van de Partij en den Algemeenen Nederlandschen Bond
van Handels en Kantoorbedienden. Op vergaderingen kwam i niet, maar
als ze bij hem kwamen met een steunlijst voor een werkstaking of om een
uur loon voor de Partijkas, dan gaf hij hun een sigaar en Coba schonk
een kopje thee en dan praatte-n-i heelemaal niet uit de hoogte met ze
en teekende voor een riks of vijf gulden en bracht ze tot de trap en
trok de deur voor hen open. Hij was toch zelf ook maar in loondienst en
had als jongen ook zoolbeslag en hoefijzers onder z'n schoenen gehad
en heel vroeger in een huis gewoond waar de buren altijd de trapdeur
open lieten staan en aan tafel gezeten met een pan rijst, voor dat
z'n vader dat werk had gehad waar i zoo aardig aan had verdiend.

En toen i weer opslag had gekregen aten ze voortaan iederen dag soep
vooraf en Coba kocht drie zilveren servetringen, voor Bobi ook één,
en wilde voortaan geen brood meer meenemen als ze 's Zondags de stad
uitgingen, wat ze nog heel lang gedaan hadden.

Ook z'n vrinden waren vooruitgekomen in de wereld. Bonger, de dokter
en Graafland, die hoofdcommies was bij de post en 't boekenschrijven
had opgegeven en van der Meer, die in automobielen dee en 't dichten
verachtte. Die niet vooruitgekomen waren zag je heelemaal niet
meer. Daar had je Kool, die altijd z'n brood met z'n twee handen at
en die zoo lang had geprakkizeerd om de wereld te hervormen, datti
koloniaal was geworden. God weet waar die nu zat, eerst hadden ze
mekaar geschreven, maar toen had dat opgehouden, je wist niet meer wat
je schrijven moest. Hein hatti een tijdje geleden nog eens ontmoet. Die
moest en die zou schilderen. De ziel der dingen schilderdeni, maar
't bracht nix op en toen z'n vader was gestorven hatti heelemaal
nix. In jaren had 't dichtertje hem niet gezien.

Op een dag loopti door de Pietervlamingstraat en daar ziet i 'm, als
kraai verkleed. Hein, die één maal geexposeerd had: "Portrait d'un
jeune homme poitrinaire et syphilitique," theosofisch "opgevat." Er
moest een groenteboer begraven worden. De kraaien stonden op de kleine
steentjes te wachten, ze hadden parapluies bij zich, Hein ook. 't Was
druilerig weer. Scheef op z'n kop stond een rouwhoogehoed, die 'm te
klein was. Z'n gekleede rouwjas met tressen hatti dicht geknoopt. 't
Ding was veel te nauw en barstte haast open en zat vol malle plooien
om z'n ribbekast. "Jonge," zegt Hein, "wat ben jij een fijne man
geworden." Meteen dragen ze, Goddank, den dooien groenteboer z'n deur
uit. 't Is niet zoo makkelijk iets te wezen in de wereld, ook al ben je
een dichtertje en heb je jezelf wel zoo wat in de gaten. Hij liep toch
al niet zoo graag meer in die straten, na dien tijd kwam i er liever
heelemaal niet meer. En dan moet je mee uit eten genomen worden en een
spijskaart voor je krijgen waar geen regel op staat die je begrijpt. En
dan neem je den eersten keer overal te veel van omdat je niet precies
weet wat er komt en nooit weet hoe ver je bent. En de volgende maal
zal je 't beter doen en dan krijg je lang niet genoeg en moet een
groote zware sigaar rooken met een leege maag. Dan wensch je dat je
vader je maar bij de stadsreiniging had gedaan indertijd, om met een
blauwe kiel en een ratel en een glimmende leeren pet met een koperen
nummer op een stil, zonnig grachtje te loopen ratelen in de vroegte,
zonder er wat bij te denken, op schoenklompen met dubbele zoolen.

En achtentwintig jaar voor hem uit, op 't wegje naar z'n graf zag i
't grijze hoofd van z'n vader loopen, dien 't ook altijd goed was
gegaan en die ook nooit iets bijzonders had bereikt. Hij zag zichzelf
al loopen over 28 jaar, met net zoo'n hoofd en kreeg 't gevoel of i
z'n eigen vader was. En drieentwintig jaar achter 'm liep z'n dochter,
nu nog z'n dochtertje. Z'n Bobi van nu zou over drieentwintig jaar
nergens wezen en toch zou ze den weg afloopen dan, dezelfde en toch
een ander. En 't dichtertje vond 't een zinnelooze optocht, die
'm droefgeestig maakte.

Maar in dit nette, onschadelijke, jonge burgerheertje leefde nog
iets, dat geen heertje was, maar een mensch, die niet zoo maar dood
wou gaan, die zichzelf een toren wou oprichten tot de blauwe lucht,
om te staan in eeuwigheid. En een beest dat zich zat wilde vreten aan
al 't onverschillige levende en doode, dat maar dee of hij er niet
was en zich wederom zat wilde vreten tot 't alles opgevreten had en
alleen over was met 't niet.

Maar daar hij niet wist hoe i beginnen moest, kwam er nooit iets
van. Hij bracht 't niet verder dan dat nu en dan één van z'n gedichten
in een tijdschrift werd opgenomen en dat 't Handelsblad 'm prees, maar
dat prijst zooveel, en dat meneer Scharten hem, Goddank "veelbelovend"
noemde. En z'n vrienden, die ernstige mannen waren geworden, zeiden een
enkel waardeerend woord er over, als ze 'm bij gelegenheid eens zagen,
die dweepten niet meer. En de afleveringen der tijdschriften begonnen
langzaam te vergaan, zooals 't leven van 't dichtertje en overigens
gebeurde er niets. De lui op kantoor lazen geen tijdschriften en hij
schreef trouwens toch onder een anderen naam.

Eens op de Zaandammerboot zat een verloofd stel naar 't water te
kijken, hij had zijn rechterarm om haar schouder en hield haar
rechterpols vast en zij legde weer haar linkerhand op zijn rechter
en zoo zaten ze dicht tegen elkaar aan. 't Dichtertje keek naar hen,
zoo'n net verloofd stel is zoo aardig om te zien. Dat die kinderen
onrustig zijn omdat ze meer willen en zich warm maken om wat ze niet
kunnen en niet durven en nooit weten waar ze zullen ophouden, dat zie
je niet en daar denk je niet over. 't Was heel aardig en misschien
waren ze nog maar pas verloofd en tevreden met elkaar vast te houden
en te dwepen. Toen keken ze elkaar lachend aan en hij zei:


    "Ik kijk van terzij in je groote oogen.
    En zie een blauw' en een gouden vonk"


en zoende haar op haar mond. Zij bloosde: "Die meneer keek net."

Dat was de eenigste keer dat 't dichtertje zijn leven voelde leven
in 't hoofd van een ander mensch en toen werti nog verlegener dan
't meisje en bloosde ook en gaf een kwartje aan den man die geld kwam
ophalen voor de muziek.

Daarna was noch aan de doode, noch aan de levende dingen meer te
merken, dat ze weet hadden van wat 't dichtertje beleefd had in z'n
dichterhoofd, datti meedroeg op weg naar z'n roemlooze graf.

't Dichtertje kreeg er genoeg van. Hij had nog iets heel moois liggen:

"Mijn doode hart is zoo zwaar te dragen". Dat gooideni maar in 't
keukenfornuis, de haard brandde niet, want 't was zomer.

En toen werti zoo kwaad op alle levende en doode dingen, datti z'n
eindelooze erotiek onderbrak en een grimmig boek schreef, dat 'm in
eens beroemd maakte. Maar dat was later pas, dat komt straks.

Voorloopig deeti alleen nog maar z'n gave tanden en kiezen op elkaar
en daarna zeidi, alleen in z'n kamer, hardop: "Een groot dichter
worden en dan vallen, Godverdomme." Z'n schoenen hatti losgemaakt
en i schopte er één van z'n voeten datti een slag gaf, waar mevrouw
beneden van schrikte.




VIII.

Dat was in den zomer en in 't najaar was 't dichtertje zoo ver
datti "onmogelijk" van kantoor weg kon. Z'n tante had reden tot
tevredenheid. Haar neef "hattet druk". Drie, vier avonden in de week
zat i op kantoor. Hij had een week bij haar zullen logeeren in Velp,
waar zij tegenwoordig stil leefde, de zaak had ze verkocht. Maar hij
kon niet weg, als een heusche heer.

's Zondags las i thuis de mail, om toch maar vooral niet te denken
en als er visite kwam, zei Coba: "Ik geloof uit Shanghai, is 't
niet Shanghai, Eduard?" En tante zag in gedachte al een circulaire
waarin stond "dat wij onzen langjarigen medewerker, met ingang van
1 Januari,--dat is wat gauw, met ingang van 1 Juli tot mededirecteur
hebben benoemd."

Maar 't kwam even anders.

Pa was dood. Pa had altijd buiten willen wonen. Vier jaar lang hatti
kippen gehouden en de pauw voer gegeven en vruchtboompjes geplant,
die dood waren gegaan. En boekgehouden. Als de eieren in 't dorp zes
centen kostten in 't winkeltje, kwamen ze hem op acht. Maar als i de
keuken binnenkwam met zes eieren en z'n voeten naveegde op de mat,
vontti dat je voor die twaalf centen meer, ook waar kreeg.

En moe had zich geschikt en zoo veel mogelijk meegeleefd en nix
laten merken, als een echte goeie ouwerwetsche moe. En 's avonds,
alleen onder de lamp, op d'r krant gestaard over haar bril en aan de
Linnaeusstraat gedacht. Zij kon niet om negen uur naar bed. Ze zag de
trams rijden in den avond over 't pleintje bij de Mauritskade, waar
ze op uitkeek van haar bovenwoning, ze zag de lichten schuiven. En
de boomen van het Muiderbosch, die bladerloos heen en weer gingen
langs de donkere lucht, met de zwarte kraaiennesten. Dan kon je zoo
echt naar 's zomers buiten verlangen. En ze dacht aan de winkels op
Zaterdagavond en de drukte van 't winkelen en hoe ze zelf door de
van Swindenstraat liep met 't boodschappenmandje onder haar schort,
in den tijd dat 't hun nog niet zoo goed ging.

Zoo echt gezellig kon je dan nog eens praten. Hè jà, en de
Dapperstraat met twee rijen karren, groenten en visch en kaas en
kopjes en schoteltjes, met olielampen, die walmden en rustig wit
licht in witte ballonnetjes van eigengemaakt gas. En overal herrie
en geraas. Toen ze al lang deftig waren geworden, ging ze nog wel
's Zaterdagsavonds gerookte aaltjes koopen aan de kar met al die
zwarte stangen rechtop, met van die genoegerige koperen knoppen. Tot
een meisje met een groot bont schort en gekapt hoofd, zonder hoed,
had gezegd: "Jeisis, de raakdom komt oltjes kaupe." Zoo'n flodder,
met bruine schoenen aan.

En dan begon moe te soezen in de suizende stilte en met haar bril in
haar rechterhand zat ze te knikkebollen, tot ze wakker werd doordat
ze te veel voorover knikte. "Hè, mensche, 'k dacht waarachtig dattik
de tram hoorde bellen."

Onderwijl schreef Dora op haar slaapkamer in schoolschriften van een
dubbeltje proza over "Hem" en maakte zichzelf wijs dat hij iemand
was, dien ze niet kende en die komen moest. En die schriften werden
weggestopt in een la, waar niemand in kon, ze bloosde, ofschoon ze
alleen was en niemand er van wist.

Em was verloofd, met een boekhouder in Amsterdam en praatte over haar
huis, dat nog gezocht moest worden en dacht aan een kindje. Raar, zoo'n
vrijer, die "op stuk van zaken" en "eventueel" zei en met een scherpe
plooi in z'n zwarte kamgaren broek bij 't kippehok stond. En altijd
hatti 't weer met pa over "de Bovenkerken," meneer Bovenkerk, die in
steenkolen dee en mevrouw Bovenkerk, die 's zomers in Zandvoort woonde
op "Mon Désir", en den jongeheer Bovenkerk, die eindexamen vijfjarige
zou doen. En de rest. Em was erg kwaad geworden, omdat Dora eens had
gezegd: "Daar heb je Bovenkerk". "Vrij jij met den IJseldijk", had ze
gezegd en bijna had ze er bij gezegd: "Ouwe kneut." Dora was een jaar
ouder. Maar haar opvoeding was haar gelukkig de baas gebleven. Dora had
erg gekleurd en niets teruggezegd. "Zou ze in één van m'n schriften
hebben gekeken? Ik laat er toch nooit één zwerven." Jasses wat een
zwager. En als i z'n witte vest aan had! En die oogen. Zoo echt een
heer, die bij den weg naar nix anders kijkt dan of i ook een kennis
tegen komt. En zoo slap. Hoe kon Em tegen zoo'n man aanstaan! Zij
leunde nog liever tegen een dennestam. Nee dan was Coba heel wat
beter af. Zoo'n man als een zee! En meteen kreeg ze een visioen van
wit zand en zon en golven en branding, en roode en blauwe badpakjes en
witte jurken en witte en roode parasols. En van duinen met uitgeholde
flank, met helmsprieten, gebogen waaiend, er bovenop. En van een golf
die haar omsloeg in 't water, ze proefde zout.

Nu was pa dood en zouden ze verhuizen. Moe ging weer in de
Linnaeusstraat wonen, over 't Oosterpark. Em zou 't volgend jaar
trouwen en Dora moest maar naar kantoor. Zoo'n beetje helpen in 't
huishouden en nu eens hier logeeren en dan eens daar en eigenlijk nix
doen maakt maar ongedurig. Ze zou nog eerst een paar weken naar een
vriendin gaan bij Berg en Dal om wat te bekomen van al de narigheid
en dan kon ze meteen naar Amsterdam in 't nieuwe huis trekken.

Ee zou haar wegbrengen. Hij kon wel moeilijk nog een dag van kantoor
weg, maar hij zou 't er dan maar afnemen.

Dora keek al eens naar 'm: wat praatte n-i-raar.

In den trein waren ze beleefd en welwillend voor elkaar, maar erg
stil. Ze reden over den IJsel en over den Rijn en Dora staarde met
groote stille oogen naar de rivieren, rechtop in haar zwarte jurk,
de handjes in haar schoot, tot zij ze niet meer zag en ook daarna
zat ze en staarde.

En hij keek zoo nu en dan naar haar gezichtje en dan weer naar buiten,
om haar vooral niet te hinderen. En dan probeerde 'n-i of hij haar
zien kon in z'n verbeelding, eerst telkens een brok, haar voorhoofd,
en hoe de haren er boven waren, golvend, en haar oogleden en haar
lange donkere wimpers en dan haar zwarte wenkbrauwen daar boven, even
gebogen en dan dat alles bij elkaar en haar oogen, haar oogen vooral,
die zag hij telkens boven de akkers, en 't neusje dat nauwelijks
wipte, zoo fijn en haar kleinen mond, dicht gesloten de roode lippen,
en de kleine oortjes, die rose doorschenen, met 't haar er boven en
losse haren er voor en haar onderkaak, zoo edel lang, met een spits
kinnetje, waar een zoenkuiltje in was. En dan moesti telkens weer
kijken naar de twee rechtoppe richeltjes onder haar neusje.

Hij sloot even z'n oogen en zag 't heele gezichtje duidelijk voor zich,
de bruine wangen nu ook. En daar was 't ook heel duidelijk buiten,
voor de rij populieren, die nog maar weinig blad hadden. Want 't was
al October. Hij moest even lachen om de menschen, die hem voor een
degelijk heer hielden.

"Zeg is 't waar, dat je tegenwoordig iederen avond op kantoor zit?" Hij
knikte. "Moet dat?" Hij haalde z'n schouders op. "Waarom doe je 't
dan?" Hij lachte weer. "Om vooruit te komen in de wereld. 't Wordt
je niet cadeau gedaan." 't Leek haar nix prettig... "Wat zou jij
dan willen?"

"Kijken... en denken... en schrijven," zei ze en bloosde heel
even... "ten minste als je dat kunt."

Hij glimlachte akelig wijs. "Nix gedaan, Doortje. Je wordt er nix
beter van, 't stomste vee is 't beste af. Geloof je niet dat Bovenkerk
een gelukkige kerel is?" Haar groote oogen gingen wijd open in stille
ontzetting. "Hè, schrijven wat je denkt is zoo fijn, zoo roef, roef,
je weet zelf niet hoe je 't doet. 't Staat er ineens precies zooals
't er staan moet. En als je 't dan naderhand leest, dan leef je in
eens weer je eigen leven van toen en toch weet je niet, of je dat
nu zelf bent of een ander." Haar oogen schitterden, er waren tranen
in. Ze bloosde niet meer over zichzelf. Ze zat stil met haar hoofdje
op haar rechterhand, haar elboog op de richel voor 't raampje en
staarde naar buiten. En 't dichtertje dacht: "dat is een echte,"
en dat ze hem nu voor een degelijk heer hielden.

Maar hij bleef grimmig en wijs, "God brengt ons op een hoogte, om
ons te laten afdalen. De weg over den top is kort, maar de dalen zijn
lang. Die op den top is geweest, slijt zijn dagen in verdriet."

Zij schudde langzaam haar meisjeskopje, zoo lief en toch zoo
nadenkelijk: "Ik leef altijd op den top."

Hij wou zeggen: "Goed zoo," maar hij zei niets. Zij staarde in den
Waal. "Mooi hè?" En in eens stond ze op, nam haar hoed uit 't rek,
stak er vlug de pennen door en met haar beide handen aan haar hoed, de
voeten wat van elkaar om stevig te staan, lachte ze in eens overmoedig
met al haar tanden, als een kwaaie meid, haar oogen in de zijne:
"Aan mijn lijf geen Bovenkerk." Toen leunde ze haar bovenlijf uit
't raampje en keek naar Nijmegen, dat daar lag op de heuvels aan de
rivier, zoo on-Hollandsch, zwak romantisch, huizen boven huizen en
boomen boven boomen, en zong tegen den wind en 't gerammel van den
trein over de brug.




IX.


Een groot dichter zijn en dan vallen. In de volheid der tijden.

't Was wel een dag om eens even de 36" white shirtings en coloured
satteens te vergeten.

Zij werden niet afgehaald. De vriendin kon niet van huis, want haar
moeder kon niet loopen en ze zaten zonder meid. Een meid is een zuster,
niet van u of mij, maar van een letterzetter of een brievenbesteller,
die bij u of mij op haar knieën door de kamer kruipt om den grond te
vegen en 't vuilnisvat buiten zet en de kopjes breekt.

Dora en 't dichtertje dronken dus koffie in Lent, over 't water,
in 't gezicht van de stad en de heuvels. 't Was een stille,
zonnige herfstmiddag geworden. De kastanjes waren al kaal, de gele
vijfvingerige bladen met hun dikke kleverige stelen lagen op de aarde
en dorre en gouden bladen lagen overal. Er was de geur van bladen,
die vergaan, die 't dichtertje altijd zoo week maakte onder zijn vest,
alsof i dood zou gaan en onsterfelijk wakker worden in net zoo'n
stillen blauwen en gouden herfstdag, die niet zou eindigen. En hij
streek een herfstdraad van z'n voorhoofd. De lucht was zoo blauw en
wolkeloos en zag zichzelf in 't water en de zon scheen gouden.

En uit 't water steeg de stad naar de blauwe lucht, de kade en de
huizen en daarboven weer huizen, half of heel uit boven andere, met
vele roode daken en ergens een kerk, groot, als een teeken voor God
om z'n stad te herkennen en twee spitse torens, die hoog en onmachtig
zich rekten naar nog hooger. Zoo reikt een dichtertje uit de rivier
zijner dichterlijkheid machtig en onmachtig naar God, die niet te zien
komt achter de blauwe lucht. Toen moest 't dichtertje toch weer even
lachen om 't wonder dat in zijn oogen was, die daar een monument van
heerlijkheid zagen, terwijl er niets was dan veel hokken vol miezerig,
nog niet eens Hollandsch, maar Geldersch kleinsteedsch leven.

Zij keken juist recht in een straat, die van de kade steil en
recht naar boven liep, er begon wat schaduw in te komen aan den
rechterkant. En ergens in de hoogte was een groot plat met een ijzeren
hek er om en ergens anders een waschtobbe op een ander plat en iemand
zette, meer dan halfweg tusschen de rivier en God, een raam open,
dat even de zon fel weerkaatste.

En links van de stad was 't lage walletje der begroeide heuvels,
een rechte lijn tot "ins grosse Vaterland".

Een gouden laantje liep langzaam hellend, schuin naar boven. De
gouden letters van het Fransche pensionaat "Notre Dame aux anges"
blonken in de verte, hoog, aan het hooge huis, dat aan den voet van
de heuvels staat, waar de grasvlakte eindigt.

"Notre Dame aux anges", onschuldig naakte engeltjes en onschuldige,
geheel gekleede pensionnaires. De God van Nederland heeft wel gelijk,
je weet nooit wat je aan die dichters hebt, zijn ze nou netjes of
niet netjes?

Toen hervond 't dichtertje ineens de zwakke romantiek in dat heele
geval. God bedoelde er heelemaal niets mee. Hij speelde maar wat en
had maar eens een heel nieuwe ensceneering bedacht om die Leiden des
jungen Werthers op te voeren, als hij daar lust in zou hebben.

En zoo praatten zij en speelden met woorden en gedachten en fantasieën
en zagen aan de schittering van elkaars oogen, als een nieuwe inval
uit zou flitsen. En daarna stapten ze op en gingen de rivier over. Zij
wilde datti een mooi cadeau voor Coba meebracht, als i 's avonds naar
huis ging. Dat zouden ze eerst samen koopen. Ze hing aan z'n arm,
haar linker door zijn rechter en zoo hielden haar kleine handjes in
zwarte glacétjes elkaar vast.

Een zacht-lila, zijden sjaal met geknoopte franje moest i koopen,
hè ja, daar zou Coba vast heel blij mee zijn. Toe, dan was i een
lief zwagertje. Ze keek in z'n oogen en drukte z'n arm, voor haar
zuster. Er was geen valschheid in haar hoofdje, haar bloed joeg,
maar in haar hoofdje was geen valschheid. "Kijk eens wat leuk". Ze
stonden in de laagte en keken naar boven onder de brug door, die daar
in de hoogte naar de Belvédère voert. En de boog van de brug omlijstte
een schilderijtje. Een brok verlaten buitengrindweg, ietwat stijgend,
aan weerszijden de blauwe band der voetpaden en kleine boompjes met
schel oranjegele kruintjes, en de takken, door de bladen heen al
goed zichtbaar en een paar lantaarns, ver van elkaar, met melkglas
van boven, fel wit, een prentje om "5 October" onder te schrijven.

Er was geen valschheid in haar hoofdje toen ze in eens kalmer werd
door de afleiding, die dat prentje aan het gesprek gaf, ofschoon
ze 't zelf voelde. Maar ze begreep 't niet, zooals Adam en Eva hun
naaktheid niet begrepen en de "Anges" van Notre Dame hun engelenstaat
en de pensionnaires hun geheel gekleedheid niet. Mijn God, wat is
een vrouw, die zichzelf begrijpt.

Maar hij begreep zichzelf wel, akelig duidelijk en daarom gebeurde
er niets. Hij zag haar aan en de dichter in hem aanbad haar en hief
haar ten troon naast den God van hemel en aarde en durfde haar niet
aanraken.

En te gelijk zat diep in 't dichtertje 't beest gedoken voor den
sprong, dat zich zat wilde vreten aan alles wat als een temptatie in
onverschilligheid om hem heen had gestaan en langs hem was geloopen
en hem niet erkend had. En haar eerst, 't mooie, 't beminde eerst, zoo
dat er geen pardon meer zou zijn voor al 't mindere. Haar te verheffen
zoo hoog als de sterren in de winternacht en met haar 't ergste te
genieten en haar dan te laten vallen in 't zwarte grondelooze. Op
haar te wreken in 't genot de tempteerende onverschilligheid. En wat
zou een dichteres je ook beter verlangen, dan zóó te vallen?

Dit dachtti terwijl een muschje van een paardevijg op den grindweg
in een van de oranje boomen vloog. Maar hij zei: "Weet jij een goeie
winkel?"

Ze kochten een heel mooie shawl, fijn en zwierig. Jammer, dat ze in
't zwart was. Zij pastte zelf net zoo'n doek, maar een zwarte, om
te zien hoe die viel en deed er haar bovenlijfje een klein beetje
bij achterover. Maar die lila, die was prachtig. Coba zou vast een
gilletje geven van plezier.

En zoo was ze tegelijk en beurtelings dien dag zuster en vrouw en
dichteresje en courtisane en kende haar verdeeldheid niet en begreep
er niets van.

Maar wat een dag der dagen.

Luid zong ze op den weg naar Beek, die ook verlaten was en ze liep
steigerend, ze kon 't niet laten, ze kon de heuvels vertillen voor
een lolletje en de zon met één hand van de lucht halen en over haar
hoofd in den Waal gooien, datti siste.

De electrische tram haalde hen in en trok een lange rij dorre en
gele bladen warrelend en schuifelend, ritselend achter zich aan,
een lolletje Gods, datti zich wel veroorloven kon op zoo'n dag.

Van Beek stegen ze naar Berg en Dal slingerend door de heuvels. En
de heuvels waren te laag en niet steil genoeg, hoe kon je daar moe
worden? En moe moest ze worden of ze sprong uit elkaar van kracht, in
scherven van dichteresje en vrouw en zuster en courtisane. Bovenop
keken ze in een dalletje met hellende zwarte en gele en groene
rechthoekige veldjes en denneboschjes en eiken hakhout er tusschen
op de hellingen. En daaroverheen in de vlakte, uren ver met niets
markants er in, alleen een recht brok rivier, dat breed van hen
wegliep, tot waar i zich in een bocht verloor. Daaraan, heel klein,
de roode afdaken van steenbakkerijen en hun schoorsteenen, hoog en
toch verloren in de wijdte.

Daar stonden ze en op eens merkten ze dat ze niets konden dan weer
weggaan.

Maar 's avonds in bed kon ze niet slapen, in haar hoofdje wilde de
helderheid niet wijken. Ze doorleefde den heelen dag telkens opnieuw en
zag alles weer heel duidelijk. En in eens werd 't onder haar schedel
als de zon zelf: "Ik houd van hem. Ik kan niet anders. Ik wil. God
sta me bij." Ze ging uit bed en dronk haar karaf achter elkaar leeg.

Den volgenden ochtend zat ze in haar pon op den rand van 't ledikant
en keek naar haar enkels en prakkizeerde: "'t Zal wel zoo zijn,"
maar de helderheid was geweken.

Hij wilde niet denken. Als een net en degelijk heer zat i kalmpjes
en gereserveerd in lijn twee en reed naar kantoor.

"Môgge, dames en heeren." En grimmig ging i aan z'n lessenaar zitten
en schiftte de post.




X.


't Was in 't laatst van Maart toen de tijden vol waren.

Den heelen dag hadden ze drukproeven nagezien, Dora en hij, heel droog
en zakelijk. Coba logeerde met Bobi in den Haag bij een rijke nicht
uit Indië. Zij hadden beiden eenige dagen vrij genomen van kantoor.

Om vijf uur had ze thuis gegeten en daarna was ze nog even
teruggekomen, om 't werk af te maken. Toen de schemering begon waren
ze klaar, 't pak lag op tafel, de brief voor den uitgever lag er naast,
er moesten alleen nog maar postzegels op.

't Was in de stad op een bovenhuis, maar het was aan den kant, er
was een vaart voor 't huis en aan den overkant was 't weiland. Dora
zat op een stoel voor den haard, mantel aan en hoed op en keek in
't vuur en dacht aan de volheid der tijden, de volheid voor haar
heel ver af. Hij lag plat op de rustbank, tusschen 't venster en den
haard, zoo plat dat ze hem nauwelijks zien kon in de donkere kamer,
en keek naar 't gele licht van de straatlantaarn op 't plafond en naar
't roode schijnsel van den haard op de vloer.

Achter 't huis was de stad en 't lamplicht in vele vensters, maar
dat zagen ze niet, want ze zaten voòr en als Dora opkeek zag ze 't
land, waar 't laatste licht de hooge lucht verliet, over de aarde was
't reeds donker.

't Dichtertje had nu van alles genoeg. Z'n boek was af, z'n gedicht
zonder eind hatti vermoord, z'n positie in de maatschappij was een
farce. Coba en Bobi hadden genoeg om te leven zonder hem, God zou
hen troosten, de tijd heelt alle wonden. Dat was een wandtekst van
z'n tante in Velp.

't Was lente. Het leek nog winter, maar 't was lente. Het sneeuwde
nog wat in die dagen, 't was nog wat koud en 't vroor nu en dan,
maar dat was maar een aardigheidje en zoo erg niet gemeend.

De dagen werden lang, om zeven uur deden de menschen de lichten aan. En
als om half zeven de gaslantaarns werden aangestoken op de gracht,
stonden ze daar zoo bleek en verwonderd. Dan warrelde de sneeuw er wat
om heen in kleine voorjaarsvlokjes en smolt voor dat ze op straat viel.

En ze dachten beiden aan de zomerregens, die komen zouden en hun
neuzen van niet te rangeeren bohemiens, die zichzelf niet vermoorden
konden, rooken 't versche hooi. Hij, grimmig als de titel van z'n boek,
"Djengis Kan," en grimmig als 't boek zelf en met de gedachte dattie
't niet meer ruiken zou, datti ook dit koninklijk abandonneerde, zij
vol vaag verlangen en zoo bewogen in haar hart. Haar handen vouwde
ze op haar rok waar die gespannen stond tusschen haar knieën. Die
hield ze van elkaar en zoo zat ze, voorovergebogen, op haar stoel.

De koeien waren al in 't land geweest, op een zonnigen dag hadden
zij ze gezien. Het land had de koeien direct herkend en ze stonden er
heel vertrouwelijk in en de zon was er blijde om geweest. Naderhand
waren de dagen weer kouder geworden en de koeien moesten zoo lang
weer binnen. Maar de hagel kon de lente niet tegenhouden.

De berkestammen waren toen zilverwit, maar mooier dan zilver. De taal
is armoedig, doodarmoedig. Die de werken des Vaders kent, weet dit.

De weilanden leken minder verzadigd van water, de landen werden
gemest, de zon steeg hooger en was trager in 't zinken. En Dora
dacht hoe de zon groot, rood en koud had gestaan in December, laag
boven de kim, om vier uur en verging in een kouden nevel en verdween,
zwak en weerloos. Maar dat was lang geleden. En hoe in den winter de
menschen om vier uur hun lichten aandoen en hopen dat 't nog weer
eens dag zal worden. Maar nu wist ze al weer zeker dat de zon zou
opkomen den volgenden morgen. En dan, wat dan nog?

Ze spraken nog altijd niet.

Hij dacht aan den tijd toen i gewerkt had, wat men noemt "hard
gewerkt." En hoe z'n familie gezegd had, datti wijzer begon te
worden. En datti eens had geklaagd, datti 't zoo erg druk had en
dat allerlei dingen op kantoor tegenliepen en hij er 's nachts van
droomde. En dat toen z'n tante had gezegd: "Ja jongen, de ernst des
levens." Ze zou vast z'n boek lezen, hopen op een presentexemplaar,
wachten of 't in de portefeuille zou komen. En er van willen schrikken,
maar dat niet durven als allerlei menschen 't geprezen hadden. Hij
zag zichzelf al circuleeren in de portefeuille in Velp, 't was wel
de moeite waard.

"En wat dan nog?" dacht Dora. De sneeuw had ze weer zien smelten en
de knoppen wat grooter worden. En daarna werden de kruinen van de
hooge boomen alom bruin.

Het leek haar alsof ze dit heel lang geleden ook zoo gezien had, met
haar handen gevouwen op haar rok, de knieën wijduit, voorovergebogen
op haar stoel.

De zon scheen weer, ze zag de huizen in 't licht en de boomen en den
gouden schijn in 't water. Den treurwilg zag zij gelen, zijn takken
hingen, ze trokken naar 't water, in doodstille gele aanbidding hingen
ze er stom boven en zagen 't gele licht in den vijver. De wollige
witte wolken zeilden in den vijver, ze schoven voor den blauwen hemel,
maar dekten hem niet. Zoo staan de treurwilgen in de stad in de vroege
lente, materialisatie Gods tusschen de klompige huizen, die zoo hoog
zijn, en ze wekken 't verlangen, dat geluk is en verdriet. Je komt den
hoek om, een abjecten goren hoek bij een haringstalletje, dat stinkt
naar gemarineerde haring en op eens gaat een slag van je oogen naar
je hart, je ziet 't goud neerstorten als een zee en je staat en een
klein jongetje veegt z'n neus af met den rug van z'n hand en roept:
"Kakmadam." Dat is Amsterdam, de hoofdstad van Nederland, in 't
vroege voorjaar.

't Was nu bijna nacht. De kolen in den haard rommelden plotseling,
vlammetjes schoten uit en hun licht was in de kamer.

"Dora," zei hij in eens, "hoe vind je Penning?" Penning was ook
een vrind uit z'n jeugd. Jaren lang hatti 'm niet gezien, hij wist
alleen datti ingenieur was geworden. En nu voor veertien dagen hatti 'm
ontmoet en hij was een paar maal komen oploopen, terwijl ze bezig waren
met de drukproeven en had dan telkens een uurtje zitten praten. Hij
was een groote, frissche jongen, aardig op weg om carrière te maken
en toch buiten z'n werk nog heelemaal een jongen. Hij had verteld
datti over enkele maanden voor een jaar of wat naar Zuid-Amerika zou
vertrekken om ergens iets uit te baggeren of een pier te leggen of
iets dergelijks. 't Dichtertje hattem ook een keer meegenomen naar
z'n schoonmoeder, die dadelijk erg met 'm ingenomen was. Em hield
niet vannem.

"Hoe vind je Penning?" "Gaat nogal," zei Dora absent. Stilte. In
't schijnsel van de straatlantaarn op 't plafond zag je de schaduwen
van de sneeuwvlokjes die nu wat grooter vielen.

"Komende maand trouwt Em." Ze keek op. Wat praatte-n-i weer raar,
hij leek wel Bovenkerk met Em. Ze gaf geen antwoord.

Als een lang vergeten ding zag ze in eens een breede rivier voor
zich, die naar zee stuwde. Zijn golven stuwden 't zonlicht naar zee,
maar het water en het licht waren zonder einde. Op een blauwe en
gouden baan trok een klein sleepbootje een langen sleep. Nietig was
't bootje, zijn pijp stak heel klein de lucht in, de rook was gering,
z'n schor geroep ging verloren in de ruimte. Uren en uren ging dit
door het water, tusschen de velden onder de ontzaggelijke lucht.

En ze zag een langen weg vol stof en zon en verlatenheid. En weer wat
anders: een weide, eindeloos, en een laan van hooge boomen, er in de
zon, van terzij, al wat lager en alles vol van levend goud en blauwe
lucht. En toen: een rivier, wat in de diepte, donker al in 't Oosten,
in 't Westen stierf de dag, geel eerst, vol droevig, bleek groen er
boven, de dag die niet sterven wilde, de duisternis die machtig steeg,
van de landen in het Oosten steeg in de lucht en machtig trok naar 't
Westen, daar was de rivier rood en schreide en wilde 't licht houden,
't licht dat blijven wilde. Zoo vloeide de rivier, met 't licht naar
de zee, die ze niet zag.

Toen zei hij "Penning komt om jou". Ze schrok, 't Duurde even voor
dat ze begreep wat ze had hooren zeggen.

"Luister goed Dora, neem hem. Hij zal je vragen, ik weet 't. Neem hem,
trouw met 'm. Verval niet aan de kunst of iets dat er op lijkt."

Ze zat zoo als ze gezeten had. Alleen haar hoofdje hield ze wat
hooger, ze keek naar 't venster, dat donker glansde, met ergens
enkele gele stipjes er in, van 't licht van den straatlantaarn. Een
van de spaarzame groote sneeuwvlokken raakte 't glas en smolt. Ze
begreep niet.

Hij legde zijn hand om haar gevouwen handen, z'n vingers raakten
de hare in hun geheele lengte. Toen steeg zoo een wild verlangen
uit haar lijf naar haar hoofdje met haar bloed, dat al haar kleeren
haar onverdragelijk waren, één oogenblik. Maar ze stond kalm op, één
hand hield ze op de leuning van den stoel. "Ik trouw niet". Ze zei 't
alsof ze vertelde dat de boekhouder z'n ontslag had genomen. Alsof hij
niets gezegd had, kwam hij van de bank af. "Hier" zeidi, "wil je dien
sleutel meenemen? Die is van de straatdeur. Bonger zou tegen tienen
bij jelui komen om 'm te halen. Hij zou vannacht hier slapen. Hij
moest vandaag van z'n kast af en kan pas morgen op de de nieuwe. 'k
Had 'm gezegd dat ik niet zeker wist of ik thuis zou zijn."

"Ga je dan nog uit?" Ze was nu volkomen rustig, voelde op tafel naar
de lucifers en stak 't gas aan. Hè, ze konden nix zien. "Ga je dan
nog uit?" Hij haalde z'n schouders op. "Misschien." Ze keek 'm strak
aan, maar aan z'n gezicht was nix byzonders te merken, zóó had hij
de laatste dagen dikwijls gekeken, als i een goede plaats oplas uit
"Djengis Kan" en ze even opzag van 't nakijken.

Hij bracht haar tot de trap.

"Dag Ee, tot morgenavond bij moe". Hij drukte haar hand. "Dag Dora,
au revoir camarade." Even hoorde ze iets in z'n toon, dat er altijd was
als i vertelde wat z'n tante had gezegd. Gek was dat. "Nou dag". "Dag
hoor," riep i haar na, alsof i een meisje van zestien jaar nadee. Toen
sloeg de deur dicht.




XI.


Ze stapte hard door, moest telkens uitwijken voor de plassen. Het
sneeuwen had bijna opgehouden, de natte vlokken die nog vielen
warrelden langzaam naar beneden, een enkele viel op haar gezicht,
dat deed haar goed. In 't licht van een lantaarn zag ze de dikke
knoppen aan een van de kleine kastanjeboompjes op de gracht, met
glinsterlichtjes waar ze 't dikst waren.

Een gele, rechte streep licht was op den stam van boven naar beneden.

Wat was er eigenlijk gebeurd? Alweer een plas, wat leek die diep met
de weerspiegeling van de lucht er in, de weerschijn van een ster
pinkte in een opening tusschen de wolken. Duizelig zou je er van
worden van aldoor zoo in die plassen te kijken, loopende. Ze kende
een sentimenteel Duitsch liedje van 't geluk dat "Jenseits der Sterne"
was. Of misschien diep in zoo'n plas, heelemaal onderaan. Malligheid,
der stond mogelijk geen centimeter water. Haar dag zou ook komen. Ze
wou. Wat wilde ze? Kon zij iets willen?

Fijn, zoo alleen te loopen in den avond en je gedachten te laten
komen en gaan en weer komen. En daar ze een dichteresje was citeerde
ze Perk, terwijl ze op zij stapte voor weer een plas en haast in een
andere trapte: "Voelt zich aan zich door zich alleen verbonden."

De natte, zoele wind sloeg om haar heen, ze haalde diep
adem. "Makkelijk praten". Waarachtig, daar liep ze bijna tegen een stel
aan, dat onder een lantaarn stond te zoenen. En in eens voelde ze zich
dame: "Wat een vulgair stel". "Der minnen vruchten ic u mildelijck
gaf, Maer een ewich zuchten houde ic daer af". Weg was de dame, toch
bloosde ze in haar eentje onder de donkere lucht om die "vruchten",
die ze gegeven zou hebben. En in eens herinnerde ze zich dat gevoel,
dat ze zooeven gehad had, God, nog geen tien minuten geleden, dat
al haar kleeren haar onverdraaglijk waren. Ze voelde haar wangen
branden. "'t Zal niet zijn." Meteen stond ze op haar stoep. Half acht.

"Dag moe, ik kom direct beneden".

Maar toen ze op haar kamer was en hoed en mantel had afgegooid, toen
werd haar duidelijk wat er zooeven gebeurd was. Een groot gevoel van
verlatenheid en dat 't leven de moeite niet waard was kwam in haar
hoofd. Ze begreep zichzelf niet.

Waarom had ze niet z'n hand gepakt en gezegd: "Ik houd van jou". Waarom
wilde ze niet, wat ze zoo erg wilde? Wat kon haar gebeuren, erger
dan deze dood levend om te dragen? Waarom was ze? Waarom moest ze
ongezoend dood gaan? Niet zoo maar 's gezoend, maar heel erg. Ze
gloeide overal, haar hart werd groot. Ze maakte haar goed open voor
den spiegel en bekeek haar borsten, zoo wit in haar zwarte japon en
hield ze op haar beide handen.

Rein en onaangeraakt was zij. Ook een lolletje. En in haar groote
verwarring bad ze, dat God haar onteeren zou. "Zou ik gek worden?"

Haar manteltje gleed van 't bed met een slag. Dat was de sleutel. Een
gedachte schoot door haar hoofd als een vlam: "hij had afscheid van
haar genomen, er was iets niet in orde, ze moest terug." Kalm waschte
ze haar gezicht wat en kleedde zich weer aan. "Ik heb iets vergeten,
over een half uurtje ben ik weer terug."

Om acht uur stond ze weer voor zijn deur en schelde. Geen gehoor. Ze
schelde nog eens en maakte toen resoluut de deur met den sleutel
open. Nergens licht. Ze griezelde van 't leege, donkere, stille huis,
haar hart klopte hevig, maar moedig ging ze naar boven. De deur van
de voorkamer stond open, 't licht van de straatlantaarn scheen op 't
plafond, 't roode licht van den haard was in de kamer. "Ee, waar ben
je"? Wat klonk dat akelig. Ze liep door de kamers, bang en moedig. Toen
ging ze de tweede trap op. Door een kier van de slaapkamerdeur kwam
licht. Haastig gooide ze de deur open, bang dat ze zich omdraaien en
vluchten zou.

"Ee, wat doe je?" Hij zat heel stil op den rand van 't bed tusschen
zijn knieën door naar 't kleed te staren. Hij stond op: "Dora". In
dat eene woord was alles en ze hoorde 't.

Toen vielen ze samen peilloos diep door 't licht en ze voelden hun
lijven als zingende zonnen.

Maar in z'n achterhoofd was een plek ijskoud en daar dacht hij:
"Dit is de wraak, zij boet voor een wereld"...

De Duivel zat in "de Kroon," in 't midden, bij een pilaar. Hij legde
z'n dunne gouden horloge voor zich op 't tafeltje. De twee knobbels
op z'n voorhoofd waren grooter dan ooit.

"Kwart over achten. Consummatum est."

Iemand tikte op z'n schouder.

De God van hemel en aarde stond achter hem: "Consummatum est, ga mee
en zie."




XII.


Om half elf vonden hem Bonger en Graafland. Bonger had den sleutel
bij z'n schoonmoeder gehaald.

Geheel naakt stond hij in 't midden van de kamer. Z'n linkerarm hing
langs z'n lijf, de vuist was gebald, de rechterarm was geheven en wees
met den wijsvinger naar boven. Er was een zwakke geur van lelietjes van
dalen, op den grond lag een blauwe haarspeld. 't Bed lag in wanorde.

"Eduard" riepen ze beiden tegelijk.

"Ik ben God", zeidi. "Ik ben meer dan God. Ik ben de onwrikbare, de
onbarmhartige. Ik ken geen goed of kwaad. Ik doe wat ik moet. Wat ik
doe is goed."

Bonger nam een laken van 't bed en trad op hem toe.

"Ga weg", zeidi en deed een stap achteruit.

Bonger bleef staan.

"Zei ik, dat ik God was? Ik ben 't eeuwige leven. Ik ben de
vruchtbaarheid. God heeft me gezonden. Bedek me niet".

Weer stapte hij achteruit.

"Bedek me niet. Ik ben de vruchtbaarheid. Breng alle vrouwen hier,
alle jonge vrouwen. Alle zeg ik. Ik ken je wel. Jij bent Bonger,
die andere is Graafland. Ik ken jelui wel. Leg dat laken op bed. Zij
moet er op liggen. Leg haar er op, de eerste, heelemaal naakt. De
anderen hoeven niet weg te gaan. Ze moeten zien. Je kunt gaan Bonger,
en jij ook, Graafland".

Bonger legde z'n hand op z'n schouder. "Sta stil, doe je arm omlaag".

De arm zakte en Bonger sloeg 't laken om hem heen. "Ga op dien stoel
zitten". Hij ging zitten. Graafland zocht z'n kleeren bij elkaar,
van 't bed, van de stoelen, van den grond.

"Kleed je aan".

Toen trok hij gedwee en langzaam al z'n kleeren aan.



't Dichtertje is nu dood. Die lui daar in Delft of Oldenzaal hebben
schitterend gelijk gekregen. Hij was vast nooit goed bij z'n hoofd
geweest.

Z'n boek is driemaal herdrukt, z'n verzamelde gedichten zijn uitgegeven
met een inleiding, van meneer Scharten of een ander. 't Fretje, dat 't
gebracht heeft tot financieel redacteur van de Provinciale Arnhemsche
en Geldersche Courant vertelt overal, dat i met 'm op school geweest
is. En alsi in Amsterdam komt, wat nog al eens gebeurt, dan schiet
i Bonger aan en begint telkens weer een gesprek over 't dichtertje
en z'n werk en doet erg zwaar op de hand en vertelt datti naast
'm heeft gezeten op school.

Coba is zachtzinnig en vergevingsgezind en natuurlijk, zooals ze
altijd geweest was. Ze is godsdienstig geworden zonder wandtext
en gaat iederen Zondag naar de Nederlandsch Hervormde kerk aan den
Boezemsingel, want ze woont in Rotterdam, als straf omdat ze wel eens
met een ander heeft gecoquetteerd toen ze getrouwd was. Zachtzinnig
en vergevingsgezind denkt ze er aan, hoe zij ook langs den rand van
den afgrond is gegaan.

Dora is een "ongehuwde moeder". Zij is op kantoor in Rotterdam, haar
baas kent haar geschiedenis en veracht haar niet, integendeel. Wat
iets heel bizonders is voor een Rotterdammer.

En ik denk dat om dezen éénen man deze wanstaltige stad mogelijk nog
gespaard zal blijven op den grooten dag. Wat weer een nadeel is.

Ze woont met haar kindje bij Coba en Bobi en gaat rechtop en trotsch
en zwijgend door haar leven. Ze wil staatsexamen doen en dan in de
rechten gaan studeeren van 't geld van haar pa, die dood is. Vooral
niet in de letteren. Werken wil ze en niet denken. Maar ik geloof niet,
dat zij zich zelf zal kunnen vermoorden. Zij die God werkelijk lief
heeft boven allen, moeten de last daarvan dragen tot het einde.


                                                        Juni-Juli 1917.






DE UITVRETER.


I.


Behalve den man, die de Sarphatistraat de mooiste plek van Europa vond,
heb ik nooit een wonderlijker kerel gekend dan den uitvreter.

Den uitvreter, dien je in je bed vond liggen met zijn vuile schoenen,
als je 's avonds laat thuis kwam. Den uitvreter, die je sigaren
oprookte, en van je tabak stopte en je steenkolen verstookte en je
kasten nakeek en geld van je leende en je schoenen op-droeg en een
jas van je aantrok als-i in den regen naar huis moest. Den uitvreter,
die altijd wat liet halen op den naam van een ander; die als een
vorst jenever zat te drinken op 't terras van "Hollandais" voor de
centen van de lui; die parapluies leende en nooit terugbracht; die
een barst stookte in de tweede hands kachel van Bavink; die dubbele
boorden droeg van zijn broer en de boeken uitleende van Appi, en
buitenlandsche reizen maakte als-i z'n ouwe heer weer had afgezet,
en pakken droeg, die hij nooit betaalde.



Z'n naam was Japi. Z'n achternaam heb ik nooit geweten. Bavink kwam
met hem aanzetten toen-i uit Veere terugkwam.

Een heelen zomer had Bavink in Zeeland geschilderd. In Veere had-i Japi
voor 't eerst gezien. Japi zat daar maar. Bavink had al enkele malen
gedacht: wat is dat toch voor een kerel? Niemand wist 't, altijd vond
je hem ergens aan den waterkant. Daar zat hij maar, uren achtereen,
onbewegelijk. Om twaalf uur en om zes uur ging i voor een uurtje naar
binnen om te eten; de rest van den dag zat i. Dat duurde een week of
drie; toen zag Bavink hem niet meer.

Een paar dagen daarna kwam Bavink van Rotterdam. Af en toe had hij
behoefte om veel menschen om zich heen te zien. Hij had enkele
dagen in Rotterdam langs de havens gesjouwd en had er meer dan
genoeg van. Aan boord van de boot tusschen Numansdorp en de Zijpe,
daar zat i weer. Het woei nog al, dien ochtend; er stond een flink
koudje wind en het water liep met witte koppen. Af en toe spatte
't op 't voorschip over de verschansing. De glazen tochtdeuren op 't
voordek waren dicht; op 't voorschip zat niemand. Alleen Japi zat daar,
tuurde over de verschansing en werd deerlijk nat. "Kijk," dacht Bavink,
"daar heb je waarachtig diezelfde kerel." Hij ging bij hem staan. De
boot rolde en steigerde. Japi zat op z'n bankje, hield z'n pet vast en
liet zich nat worden. Het duurde nog al wat, voordat i merkte, dat er
iemand bij hem stond. "Lekker weertje, meester", zei Bavink. Japi keek
'm aan met z'n groote blauwe oogen en hield aldoor z'n pet vast. Meteen
kwam er een plons water over boord, de droppels stonden op z'n gezicht.

"Nogal", zei Japi. Met een plof kwam 't voorschip op 't water neer
en stootte. Een heer trachtte tevergeefs de deur van den glazen
salon open te maken, waar de wind op stond. "We zijn mooi op tijd",
zei Bavink, om wat te zeggen. "Zoo?" zei Japi, "ik weet van geen tijd."

't Gesprek hokte wat. Japi keek in de golven. Bavink keek naar de
grijze pet van Japi en dacht wat dat toch voor een kerel zou zijn. In
eens zei Japi: "kijk eens, een regenboog in 't water." Je kon in 't
water een eindje regenboog zien, aan de lucht stond niets. Nog eens
keek Japi Bavink met z'n groote blauwe oogen aan en werd plotseling
spraakzaam.

"Ik vind 't hier verdomd leuk", zei-i, "'t is jammer, dat 't zoo niet
altijd blijft." "Over een uurtje zijn we aan", zei Bavink.

"Moet u naar Zierikzee?" vroeg Japi.

"Dat wil zeggen", zei Bavink, "ik ga vanavond door naar Veere." "Zoo",
zei Japi, "is u daar gelogeerd?"

"Ja, daar ben ik gelogeerd en is u niet die heer uit Amsterdam, die
altijd maar aan den waterkant zit?" Toen moest Japi lachen en zei:
"Ik zit nog al eens aan den waterkant, altijd is een beetje sterk. 's
Nachts lig ik op m'n bed, ik heb een uur noodig om me aan te kleeden
en te ontbijten, een half uur zit ik aan mijn lunch en om zes uur moet
ik weer eten. Maar ik zit nog al eens aan den waterkant. Daarvoor kom
ik naar Zeeland. Ik maak me nog veel te druk. Van de week ben ik naar
Amsterdam geweest. Ik moest wel, m'n centen waren op."

"Is u Amsterdammer?" vroeg Bavink. "Ja, Goddank", zei Japi. "Ik
ook", zei Bavink. "U schildert niet?" vroeg Bavink. Het was een
rare burgermansvraag, maar Bavink dacht aldoor maar: wat zou dat
toch voor een kerel wezen? "Nee Goddank", zei Japi, "en ik dicht ook
niet en ik ben geen natuurvriend en geen anarchist. Ik ben Goddank
heelemaal niks."

Dat kon Bavink wel bekoren.

Het schip steigerde, kwakte, rolde en slingerde; het water spatte
en plenste over de verschansing; niemand anders was aan dek te
bekennen. Vóóruit was het water onafzienbaar, vol witte koppen, de
schaduw van een groote wolk was een drijvend eiland; heel in de verte
voer stampend een zwarte vrachtboot voor hen uit. "Kijk", zei Japi,
"de ""Stad Gent."" Je zag in de verte het water aan weerszijden van
de boeg hoog opvliegen; om de schroef zag je het woelen en bruisen en
schuimen. Hol liepen de golven met scherpe kammen, groen en blauw en
geel en grijs en wit, al naar de diepte en de weerspiegeling van de
wolken, nergens en geen oogenblik 't zelfde. Een klein sleepbootje
sleepte een aak en twee tjalken.

"Nee", zei Japi, "ik ben niks en ik doe niks. Eigenlijk doe ik nog
veel te veel. Ik ben bezig te versterven. Het beste is, dat ik maar
stil zit, bewegen en denken is goed voor domme menschen. Ik denk ook
niet. 't Is jammer dat ik eten en slapen moet. Liefst zou ik dag en
nacht blijven doorzitten."

Bavink begon 't geval interessant te vinden. Hij knikte maar. Nog
altijd hield Japi z'n pet vast met z'n rechterhand, z'n rechterarm
steunde op de verschansing. 't Woei zoo hard, dat Bavink z'n hand
opzij van z'n neus moest houden om adem te halen. Japi zat daar maar,
alsof hij thuis was. Toen vertelde Japi dat i van plan was, nog enkele
weken in Veere te zitten, tot zijn geld op was.

Schilderen leek 'm wel aardig, als je 't goed kon. Hij kon niks, en
daarom deed i maar niks. Je kon toch de dingen niet zoo weergeven als
je ze onderging. Hij had maar één wensch: te versterven, onaandoenlijk
te worden voor honger en slaap, voor kou en nat. Dat waren je groote
vijanden. Eeuwig en altijd moest je weer eten en slapen, moest je
weg van de kou, werd je nat en beroerd of moe. Zoo'n waterplas heeft
't maar goed, die golft maar en weerspiegelt de wolken, is aldoor
anders en blijft toch gelijk. Heeft nergens last van.

Al dien tijd stond Bavink schrap in den wind op z'n stok geleund en
knikte Japi maar toe. Dat is zoo mal nog niet, dacht i. En droogjes
weg vroeg i, of Japi ook door ging naar Veere. En zoo kwam 't gesprek
op Zierikzee, op Middelburg, op Arnemuiden en al die oorden, waar ze
allebei uit en te na hadden rondgeloopen en gestaan en gezeten. Want
Japi had van z'n leven toch ook nog wel iets anders gedaan dan in
Veere aan den waterkant gezeten. En toen merkte Bavink al gauw dat
Japi niet alleen loopen en staan en zitten kon, maar kijken ook. En
boomen honderd uit. En toen ze samen aan de Zijpe aan wal stapten, toen
wees Japi naar 't Zuidwesten, naar den dikken toren van Zierikzee die
heel flauwtjes aan den horizon zichtbaar was en zei: "Dikke Jan, die
oue geduldige dikke Jan, hij staat er nog. Ik dacht 't wel. Ja hoor,
hij staat er nog." En toen vroeg Bavink of i altijd zoo'n lol had en
toen zei Japi: "Ja", meer niks. En toen ze in Zierikzee arriveerden
en uit de tram waren gestapt toen liet Japi zijn zoolen klepperen
op de heete keien van een of ander schaduwloos straatje dat maar
bakte en bakte in de zon en rekte zich uit en zei dat 't leven toch
verduiveld lollig was. En toen dreigde i de zon met z'n wandelstok
en zei: "Zoo'n zon toch, hij schijnt maar, maar i daalt, hij rijst
niet meer, 't is over twaalven, hij moet onder; van avond is 't weer
koel. De lui zouden raar kijken als i niet daalde. Lekker warm hé,
mijn goed plakt aan mijn lijf. De zeelucht stoomt mijn boordje uit."

En toen bleek dat je dat versterven niet zoo letterlijk moest nemen.

Aan tafel was Japi meer dan spraakzaam. Hij praatte voor drie, at
voor zes. "Die zeelucht graaft", zeggen ze in Veere. Hij dronk voor
zes anderen en zong 't heele liedje van de Nancy Brig. Kortom hij
was zeer bedrijvig en luidruchtig, en Bavink dacht dat zoo'n kerel
goud waard was.

En dat was i. 's Middags nam i Bavink mee naar de singels en liet
'm driemaal Zierikzee rond loopen. Z'n mond stond niet stil en z'n
wandelstok wees maar en als de Zierikzeeënaars bleven staan en keken,
dan ging i op ze af en sprak ze aan met "jongeheer" en vroeg of ze
wel gezond waren en klopte ze op den schouder, dat Bavink zijn zijen
hield van 't lachen. Dat kon Japi goed: met 't welwillende beschaafde
Hollandsche publiek afrekenen, dat niemand duldt die er niet minstens
even dom en smakeloos uitziet als zij, en hoont en hardop over je
praat alsof niet zelfs op 't kleinste dorp sedert eeuwen dominees
en pastoors bezig zijn 't volk op te voeden. Japi was een kerel als
een karrepaard en sloeg er op in als 't moest met een kracht en een
bedrevenheid waartegen de plompste kinkel 't moest afleggen. Zoover
kwam 't in Zierikzee niet. De Zeeuwen zijn de beroerdsten niet. Japi
placht te zeggen: "'t Eenigste wat me spijt is dat je op Walcheren
niet eens af en toe een relletje hebt."




II.


Twee dagen sjouwden Bavink en Japi in Veere rond en toen jijden
en jouwden ze elkaar al. Urenlang zaten ze samen op 't dak van 't
Hospitaal en keken over Walcheren, over de Kreek en 't Veergat en den
ingang van de Oosterschelde en de duinen van Schouwen. En daar had
je dikke Jan ook weer, den toren van Zierikzee, nu in 't Noorden. En
daar had je Goes en Lange Jan, den toren van Middelburg, de spil van
Walcheren, het hart dier wereld. En 't tij kwam in en 't tij ging uit;
't water rees en viel. En iederen avond kwam de manke havenmeester en
maakte eerst 't groene lichtje aan op 't Noorderhoofd, de palenwering;
en dan kwam i daar af, dan moest i om 't heele haventje heen en dan
zag je 'm weer bij den toren en dan maakte i het houten hek open en
klom de houten trap op en stak ook 't licht aan den toren aan. En dan
zei Japi: "alweer een dag, meester", en dan zei de manke havenmeester:
"Ja mijnheer, al weer een." En als je dan naar den kant van Schouwen
keek dan zag je 't draaiende licht aan en uitgaan. En een uur weg
naar zee lag de lichtboei en scheen en doofde. En 't water klotste
en rees en daalde, en door de nacht schoof de zon die je niet zag
door 't Noorden. En 't laatste licht van den dag schoof mee door 't
Noorden en werd 't eerste licht van den nieuwen morgen. Zoo raakte
de eene dag aan den anderen, zooals dat in Juni altijd is.

Voor de aarde was de zaak eenvoudig genoeg. Die draaide maar om z'n
as en vervolgde z'n baan om de zon en had er geen weet van. Maar
de menschen erop tobden met moeite en zorg en veel verdriet door
de dagen, alsof 't zonder die moeite, die zorg en dat verdriet geen
avond zou worden.

Japi wist wel beter. De zon kwam van zelf wel weer bij de Walchersche
duinen in zee terecht. Maar Bavink had 't bij tijden leelijk te pakken.

Bavink was een kerel, die gemeenlijk hard werkte. De menschen dachten
dat i nog al wat kon. Hij lachte er om. Als i niet moest verkocht i
niets; zijn beste werk zette i weg, keek er niet meer naar om, altijd
ontevreden. Zoolang i werkte ging het goed, als i klaar was hatti er
pijn van; bij tijden was i dood op. Als de menschen wisten hoe i de
dingen zag, hoe ze hem aanpakten, ze zouden lachen om zijn prutswerk,
om zijn akelige knoeierige reproductie dier heerlijkheid. Bavink
had heele tijden dat i niets deed, zich maar liet gaan, lekkertjes
de dingen aankeek en er doorheen sukkelde, 't prettig vond dat de
boel zoo "verdomd mooi was", zooals i dat zei. Dat i pijn in zijn
schedel voelde als i dacht aan al zijn vergeefsche pogingen, aan
zijn "verdienstelijke werk." Verdienstelijke werk! Spuwen moest i
als i er aan dacht. "Verdienstelijke werk", zeiden ze. Ze wisten er
wat van. Je kon wel merken dat de dingen hen niet te grazen hadden
genomen en door elkaar geschud zooals hem.

Hij wou dat i 't schilderen maar laten kon, maar dat gaat ook maar
zoo niet; als 't er in zit wil 't er uit. En dan begon de marteling
weer, werken, werken dag en nacht, daags schilderen, 's nachts er
over piekeren, er bij blijven, doorwerken, zorgen dat je de dingen nu
goed vasthield. Dan sliep en at i nauwelijks; in 't begin rookte i dan
enorm veel sigaren achter elkaar maar na den eersten dag hield dat ook
op. Dan had i oogenblikken van 't hoogste geluk zooals zelfs het loome
wegzinken in al dat "lekkere mooi" hem niet geven kon. En dan kwam die
kijken, en die, en dan stonden ze met hun tweeën, met hun drieën, met
hun vieren achter hem en keken en knikten en wezen. En dan ineens was
't uit. Dan zei i: "Verdomme", en ging op zijn brits liggen en liet
een klein spatje jenever halen, en deed niets meer. Dan werd na een
paar dagen het doek bij de rest gezet. De dagen die daarop volgden was
i ellendig, moe, miserabel, onvatbaar, ziek, en ging i weer "sloffen"
zooals i dat noemde: niets doen, luieren, rond loopen. Als i centen
noodig had dan haalde i 't een of ander uit de "vullis", dan zocht
i een "doekje" uit waarvoor "ze wel 't een of ander zouden geven",
en dat verkocht i dan. Niemand kon 'm van die manieren afbrengen. Hij
was nu eenmaal zoo. Z'n kracht en zijn zwakte hoorden onverbrekelijk
bij elkaar. En als i wat had verkocht dan stopte i de centen los in
zijn zak, dan rammelde i met de guldens en riksdaalders, dan liep i
in de Kalverstraat een liedje te fluiten. Dan groette i joviaal met
zijn hand boven zijn hoofd als je 'm tegen kwam.

Dan kwam i vertrouwelijk bij je staan, liet je geheimzinnig de "spieën"
zien, lachte hardop en zei: "De stakkers toch hè?" Papier nam i nooit
aan: daar kon je niet mee rammelen. Goud moest i hebben en zilver,
en als 't 'm te veel werd "kwam i de rest later wel eens halen."

Dat was Bavink; en je begrijpt dat een heer die zich oefende
in 't versterven hem degelijk interesseerde. Daar kon i wat van
leeren. Zoo'n kerel die 't prettig vond om zich te laten uitwaaien,
zijn kleeren en zijn lijf te laten doortrekken van den natten zouten
wind, die zijn lippen proefde met zijn tong omdat i dien zeesmaak zoo
"verdomde lekker" vond; die 's avonds aan zijn handen zat te snuffelen
om de zee op te snuiven. Zoo'n kerel die tevreden was omdat i bestond
en gezond was en genoegerig zich bewoog tusschen Gods hemel en Gods
aarde, en 't dwaas vond dat de menschen zich zooveel moeite gaven,
en hardop om ze lachte en die eeuwig met een besten glimlach zich
stilletjes zat te verheugen in 't water en de lucht en de wolken en
't veld en zich doornat liet regenen zonder 't te merken en dan zei:
"ik geloof dat ik nat ben", en lachte. Een kerel die smakelijk duur
kon dineeren en smakelijk dure jenever wist te drinken als de eerste
in Nederland, en op andere tijden op marsch (want i zat niet altijd,
hij was af en toe dagen op de been) dag in dag uit droge fijntjes at
en tot tranen toe bewogen was omdat in 't veld "zoo'n brokkie brood
zoo lekker smaken kon."

En als Bavink werkte dan zat Japi er bij in 't gras of binnen,
omgekeerd op een stoel en rookte. En als ze binnen waren dan had Japi
een tweede stoel erbij slaan met een borreltje er op, waar i af en toe
de hand naar uitstak. En hij hield Bavink aan den gang. Tegen niemand
anders had Bavink ooit een woord gezegd als i werkte; met Japi sprak i.

"Wat duvel", zei Japi, "'t dondert toch niet of 't goed is, je doet wat
je kunt, je bent nu eenmaal een stakker. Je moet schilderen. Je kunt
't toch niet laten. 't Hindert immers aan de dingen niet of jij ze nou
niet heelemaal zoo krijgen kunt als ze zijn. En de lui, die snappen
er toch niets van. Van de dingen niet en van je werk niet en van jou
niet. Ik kon mijn tijd toch ook een boel beter besteden dan hier te
zitten zuipen en naar die verfboel te koekeloeren. Word ik er minder
van?" "Neen, dat deugt niet", zei i dan, "veel te blauw; je weet toch
wat we gisteren afgesproken hebben? Veel te blauw, kerel. Denk je dat
't je zoo zou aangepakt hebben als 't die rare blauwe kleur had?"

Japi was goud waard voor Bavink. Bavink sleepte 'm overal mee. Bavink
heeft Japi gemaakt tot wat i was, toen Bavink in Amsterdam met hem
kwam aanzetten.

Japi was al heel gauw erger dan schraal bij kas. Voor geen geld ter
wereld had Bavink hem laten gaan. Japi moest maar zelf in de "vullis"
gaan zoeken. En dat vak verstond Japi gauw. Nooit had "de belt" zoo
gerendeerd. En sedert betaalde Bavink alles of bijna alles. Af en
toe kreeg Japi een klein beetje geld van huis gestuurd. Maar dat was
de moeite niet, want bij tijden leefden de heeren als kapitalisten;
als ze een bui kregen gingen ze voor een paar dagen naar Amsterdam,
naar Brussel, naar Parijs, naar Luxemburg; veertien dagen zaten ze
in Normandië. Japi sleepte geregeld een klein beltje mee: een "jonki
van den grooten belt", zooals hij dat noemde. In Frankrijk en België
klampte i de menschen op straat aan, schelde aan de huizen. Van niemand
anders zou Bavink 't geringste van dien aard hebben geduld. Maar
niemand anders verstond de kunst Bavink in 't leven te houden, zooals
Bavink zei. Z'n conversatie was onuitputtelijk. En een geheugen hatti
voor landschap dat aan 't wonderbaarlijke grensde. Langs de spoorlijn
van Middelburg naar Amsterdam kende i alles, elk veld, elke sloot,
elk huis, elke laan, elke boomgroep, elk riggeltje hei in Brabant,
elken wissel van 't spoor. Als je uren in donker had gereden en Japi
had al dien tijd geslapen languit op de bank en je maakte 'm wakker
en je vroeg: "Japi waar zijn we?" dan moest je even wachten tot i
goed wakker was en dan lag i even te luisteren naar den klank van 't
rijden en dan zei i: "Ik denk dat we bij Etten-Leur zijn." En dan kwam
't uit ook. Hij kon je precies vertellen hoe op dien en dien dag de
schaduw van die en die boomen bij Zalt-Bommel op die en die laan viel
en welke schepen toen en toen langs Kuilenburg vaarden in de Lek, toen
je met Japi over de spoorbrug reed. En dan zat i maar bij 't raampje
in afwachting: "nu komt dit, nu komt dat". Uren lang. En als i iets
zag dat i bijzonder goed kende dan knikte i en lachte. Of hij zei:
"Kijk, die boom is weg"; of: "Hé, nu zitten er appeltjes aan, die heb
ik den vorigen keer nog niet gezien." Of: "Voor veertien dagen stond
de zon net achter de kruin van dien boom, nu staat i een eindje links
er van en wat lager, dat komt omdat we veertien dagen verder zijn en
we zijn ook 10 minuten te laat."




III.


En zoo kwamen ze met den winter naar Amsterdam en zat Japi op een
avond op mijn kamer en rookte de eene sigaar na de andere, die voor
't wegnemen op mijn tafel lagen, mijn sigaren.

Ik had dien avond juist den langen Hoyer op bezoek, die weer eens van
Parijs was komen aanwaaien en nu zat op te hakken over z'n werk en
over de meiden, met een stroohoed op, in November, en een zalmkleurige
jas aan. Hij was bezig aan een onbegrijpelijk verhaal van een jonge
dame en een huurkoetsier en een mandje met paling, toen we op de trap
gestommel hoorden. 't Was in een volksbuurt, je kon gewoonlijk zoo
maar naar boven loopen, de straatdeur stond meestal open.

Bavink kwam 't eerst binnen en zei: "Hoe maak je 't kerel? ja ik
ben 't zelf. Ha, ha, Hoyertje. Hoe gaat 't, Hoyertje, nog altijd
een ophakker? Nogmaals hartelijk gefeliciteerd hoor. En jij ook,
Koekebakker, dat je er lang getuige van mag wezen." In de deur stond
Japi. Een lucht van zoutwater en gras brachten ze mee. "Kom binnen,
kerel, kom binnen!" inviteerde Bavink, op mijn zolder.

"Och mijnheer", zei Hoyer, "wees zoo goed de deur achter je dicht te
maken." "Koekebakker", zei Bavink, "dit is Japi, een kerel waar je
plezier van kunt beleven. Hoyer is nog even welgemanierd als altijd,
hoor ik". "Ga zitten Japi", inviteerde Bavink en liet zich met
een plof vallen op de eenige stoel die vrij was; "neem dat kistje
maar." Er stond een schavotkleurige matrozenkist, daar had ik een
schoon hemd in en de brieven van mijn zuster. "Wacht ik zal u helpen",
zei ik. Toen schoven wij de kist bij tafel, Japi en ik, en toen zag
Japi een leeg stijfselkistje staan van Hoffmann met een kat er op,
daar had ik aard ingehad, maar er had niets in willen groeien. "Zie
zoo", zei Japi "anders zit ik zoo laag." "Ik zal er maar eentje nemen",
zei Bavink en stak een van mijn sigaren op. "Ga je gang maar Japi". En
Japi beviel dat wel. "Wat heb je daar?" zei Bavink. Op mijn tafel lag
"Le Lys dans la Vallée" van Balzac. "Aha, Balzac. Geen kwajongen,
die oue heer. Dood hè? Al lang dood. Natuurlijk. Waar kom je vandaan,
Hoyer? Wat heb je daar een mooie jas aan. Ga eens staan. Te kort,
kerel, veel te kort". Bavink was genoegerig. "Dat weet ik potdome
ook", zei Hoyer. "Vertel liever eens waar jij gezeten hebt. En wie
is die heer?"

En toen kwam het verhaal, met begeleiding van Japi met knikken en
grijnzen. En af en toe ging die hand naar mijn tafel en ook Hoyer
werkte als een fabriek en ik rookte maar niet meer. "Wacht", zei
Bavink, "dat is waar ook." "Goeie hoor. Kamper Middelburgers, van
Bessem en Hoogenkamp van de Lange Delft." "Bekend", zei ik.

"'s Jonge", zei Japi, en zat m'n hok rond te kijken; "'s jonge, "'t
ziet er hier gezellig uit. Waarachtig, 't is hier gezellig". Hij stond
op en liep naar den muur. "Aha, Breitner. Heel goed. En wat hebben we
daar? 't Is hier een beetje donker. Zoo, mijn vriend Mauve. En daar heb
je waarachtig ons stadhuis ook." 't Was een schetsje van 't raadhuis
in Veere. "Bavink", zei Japi, "'k geloof, dat je daar kennis aan hebt;
ik zoek zoo een baantje, als dat niet een dingetje van jou is."

"Daar kom je goed af", zei Bavink. "Dat dacht ik wel", zei Japi en
ging weer zitten. "Nee maar, ik kom hier vast terug. Ik zit hier goed."

Op dat oogenblik begon de gramophoon van den diamantslijper
aan den overkant ter werken. "Klappen", zei Japi. En wij aan
't applaudisseeren. Met z'n vieren stonden we bij 't open raam en
applaudisseerden honderd uit. Overal hoorde je op de waranda's deuren
opengaan, de menschen kwamen buiten. Sommigen applaudisseerden mee;
een kind begon te huilen; een hond jankte alsof binnen een maand 't
heele blok zou komen uit te sterven. De diamantslijper hield prachtig
vol. Een juffrouw aan den overkant riep: "Halve garen!" Een klein
meisje schreeuwde enkele malen. "Papus", "Zeppelin!" Een jongetje
ging op een mondharmonica spelen. "We moesten de straat maar opgaan",
zei Hoyer.

En zoo stommelden wij de trappen af. Drie- en tweehoog werd binnen
druk gepraat. "Over ons", zei Japi. Eenhoog was niemand thuis. "Zeg
Japi" zei Bavink op straat, "nu moest jij eens een rondje geven." "O
ja", zei Japi, "vooruit dan maar". En zoo leerde ik Japi dienzelfden
avond nog in zijn kwaliteit kennen. Hoyer had een theorie dat bier
nooit kwaad kon. Wij dronken er dus zeer aanzienlijke hoeveelheden
van. Japi had geen cent; Hoyer verdomde 't; Bavink was zat, zat
wezenloos te staren en te beweren dat "deze heer een verdomd goeie
kerel was en dat hij een rondje gaf (dat was Japi), en dat de kelner
ook een verdomd goeie kerel was." Ik kwam op negentien cent; Hoyer was
uitgeknepen. Ik besloot "'t geval" maar schuldig te blijven; de kelner
kende me; en om één uur liepen we met z'n drieën op 't Frederiksplein
vreedzaam te jodelen. Die centen kreeg ik later van Bavink terug;
hij wilde met geweld hebben dat ik ze aanpakte. Japi vond 't geval
kostelik, zat drie dagen later op den rand van mijn ledekant en liet
zijn beenen bengelen; zei dat 't stom van Bavink was geweest om zich
te bezatten, maar "die zaak kwam in orde." Toen hij wegging had hij
"Le Lys dans la Vallée" te pakken.




IV.


Het was een maand later. Een veertien dagen had het wat gevroren,
maar in 't begin van die week was 't weer plotseling omgeslagen. En
nu was 't avond en 't stortregende. Den heelen dag had het bijna
zonder ophouden gestortregend. Het water liep bij stralen langs
mijn ruiten. Ik voelde me behagelijk. Ik mocht dat wel. Ik had
geen kachel en m'n demi stond nog bij Oome Jan. Een winterjas heb
ik nooit bezeten. Die vorst had me gehinderd: van armoede moest je
naar bed. Anders kon ik in dergelijke omstandigheden nog wel eens bij
Bavink terecht. Maar juist nu had die heer de aardigheid gehad om over
dag te slapen en 's nachts bij den weg te loopen. Een heele nacht had
ik moederziel alleen bij zijn kachel gezeten; hij had dat zoo willen
hebben maar lollig was 't niet geweest. En nu zat ik te luisteren
naar 't kletteren van den regen op 't dak en was blij dat 't dooide,
hard dooide. Op tafel lag mijn brood, twee dikke pillen; mijn laatste
bordje was den avond tevoren gebroken. En daarnaast lagen de centen:
vier blauwe papiertjes, twee rijksdaalders, drie guldens en enkele
centen. En in den hoek op den grond stond mijn éénvlams stelletje en
in 't kleine keteltje begon 't water te razen. Daarnaast stond m'n
theepot, zonder deksel, te wachten tot 't water zou koken; de thee
was er al in. En ik zat met mijn beenen onder tafel uitgestrekt,
met bloote voeten, in mijn hemd, mijn handen in m'n broekzakken en
keek naar m'n boterhammen, naar m'n lieve geldje, naar de vlam van
mijn olielamp, naar 't licht van mijn stelletje, en luisterde naar
de regen en was tevreden.

't Was acht uur. 'k Legde m'n klokje op tafel naast m'n centen,
't klokje dat nu niet naar Oome Jan hoefde en zei: "Jij blijft
voorloopig bij Oome Koekebakker, klokje", en stak m'n hand weer
in mijn zak. Dat converseeren met m'n dingetjes was ik zoo gewoon,
omdat je met de meeste menschen zoo weinig praten kunt.

Voorloopig was ik uit den brand, 't Lieve najaar had me niet
bedrogen. Het vallen van de bladeren, de Zuidwestenwind die de boomen
aan den Veerschenweg nog meer had doen krommen naar het Noordoosten,
die 't klokkenspel van Lange Jan in flarden had gewaaid, die den
toren had doen zwiepen en trillen, bang onder de zwarte wolken, ik
had ze dan eindelijk in bank en zilver omgezet en daar zat ik en
keek er naar, naar mijn eigen geld, 't geld daar je op aan kunt,
dat je nooit bedriegt en nooit in de steek laat. Doornat was ik
een uur geleden thuisgekomen, met een brood, een half pond boter,
twee ons boterhammenworst, een half pond suiker, een ons thee en een
kistje sigaren, 25 sigaren van 4 cent, een rijkdom die ik sedert
mijn verjaardag niet gekend had, en dat was maanden geleden. De
boterhammenworst had ik weggezet, die was voor morgen. Ze hadden
een kastje voor me getimmerd, naast 't raam en daar lag op den bodem
alles op een rijtje: de boter, de thee, de suiker, de worst, al die
dingetjes die zoo lekker kunnen wezen, als je er een tijdje af bent
geweest. En 't aangesneden brood lag er boven, op 't plankje.

En op den zolder van drie hoog hingen mijn kleeren te drogen: jas,
vest, broek, onderbroek, overhemd en sokken. 't Water begon te koken,
't deksel van 't keteltje ging rammelend op en neer. Ik keek naar den
stoom en begon plannen te maken om morgen m'n demi uit den lommerd te
halen en voor een keer niet in 't koschere restaurant te dineeren:
biefstuk met appies 30 cent, erwtensoep met vleesch 35 cent. En ik
bedacht juist dat ik er wel aan had kunnen denken om een druppeltje
drank in huis te halen, toen ik in mijn gepeinzen gestoord werd
door een zwaren stap buiten de deur. Er rommelde iemand aan mijn
deur. Kloppen ging niet, want mijn deur was van behangselpapier op een
paar latten geplakt, en als je klopte ging je er door. Dat wisten de
lui. "Zeker Hoyer", dacht ik, "die kan nooit den haak vinden." De haak
zat van binnen maar de deur sloot niet; je kon net je vinger door de
reet steken en zoo van buiten de deur openmaken. "Kom binnen", riep ik,
te lui om op te staan. "Makkelijk praten", hoorde ik zeggen, "hoe zit
dat?" "Die stem ken ik niet", dacht ik, "wie kan dat zijn?" Ik stond
op en deed open, meteen liep een straal water over mijn hand. "Japi",
zei de man. "Kom binnen", zei ik weer. Daar stond i; 't water liep
van alle kanten uit zijn kleeren en van z'n hoed.

"'t Regent nog al", zei Japi, "mag ik even mijn jas uitdoen? Wacht,
dan zullen we dit eerst neerzetten." Onder z'n jas vandaan haalde i
een pak in een Handelsblad: boeken, dat kon je direct zien, en zette
't op tafel. "Ziezoo, kan dit ergens uitgehangen worden?" zei i en
gaf me z'n jas. Z'n hoed zette i overeind tegen m'n stelletje.

"Een oogenblik, ouwe heer", zei ik en nam z'n jas en hoed mee, hing
de jas bij m'n eigen natte kleeren, sloeg den hoed uit en legde die
toen plat op den grond in den hoek.

Japi zat al, wrong de knieën van z'n broek uit en keek rond. "Wat
verschaft me het genoegen?" "Zeg maar Japi", zei i, maakte 't
pakje los en legde "Le Lys dans la Vallée" op tafel. "Zie hier,
burger". "Mooi zoo", zei ik, "en wat hebben we daar?" "O", zei Japi,
"boeken van Appi."--"Leest Appi tegenwoordig 't Handelsblad?" "Neen,"
zei Japi, "die krant is van mijn ouwe heer, daar stond een advertentie
in."--"Een advertentie?"--"Een advertentie; zie hier, daar even van
den ouwen heer gekregen."

""Assistent correspondent gevraagd op druk exportkantoor", let wel,
druk exportkantoor--"grondig bekend met de moderne talen, stenografie
en machineschrijven. Zij die reeds in den export werkzaam waren
(let op dat waren!) genieten de voorkeur. (Genieten de voorkeur, dat
genieten kan me wel bekoren). Salaris f 3 à 400 per jaar. Brieven onder
No. 1296 bureau Alg. Handelsblad"--1296, slag op 't vlotje. Floris de
stijve springt over de Overtoom. Nooit van gehoord? En waarom hebben
ze dan de Overtoom gedempt? 't Was geen gezicht om dien stijven kerel
er over te zien springen, dat wilden ze niet meer hebben. Die f 300
à 400 bevallen me wel, de rest trekt me minder aan"

"Wilt u daarop schrijven?" vroeg ik--"Jij, als 't ublieft," zei
Japi. "Willen? Ik moet van de ouwe heer. Hij zegt: 't kan zoo
niet blijven doorgaan. Ik zie niet in, wat niet. Heeft hij last
van me? In vijf weken heb ik maar twee maal thuis geslapen. Geen
cent zie ik van hem. Kijk eens hier." Hij stak z'n been uit. Ik zag
een splinternieuwen, gelen schoen. "Wat bliksem, dien schoen ken
ik."--Waar zie je zulke gele schoenen?--"Ze zijn nu wat donker van
't water", zei Japi, en zette den anderen voet bij den eenen. "Van
Appi! En hoe komt dat? Ik ben m'n ouwen heer niet tot last. Ik loop
rond met mijn schoenen tot ze zoo lek zijn als een mand. Appi is een
fideele kerel. Schilderen kan i niet, zal i nooit leeren, dat zie ik
wel, maar hij is een fideele kerel. Sokken hat i niet over de hand,
ik zit met m'n bloote voeten in z'n schoenen", zei Japi, en liet heel
gemoedelijk een stuk van z'n bloote been zien. "En boeken heeft i,
in geen jaar kom ik er doorheen, al lees ik dag en nacht."

Appi z'n vader had een goed beklante slagerij en kon 't doen. Dat Appi
nooit schilderen zou leeren heeft Japi goed gezien; z'n vader heeft
hem later in een huis-, reclame- en decoratieschilderswerkplaats gezet.

Ik zette thee. Gehurkt bij mijn stelletje, goot ik 't water op en zette
't theepotje op 't waterketeltje. Japi snoof.

"Goeie bullen", zei i, draaide zich heelemaal om en verschoof z'n
stoel tot hij met z'n neus boven de theepot zat. "Ik heb mot gehad
met Bavink". zei i. "Is 't waarachtig?" zei ik. Van Hoyer had ik al
gehoord dat ze bij dag en bij nacht samen rondscharrelden, dat ze
in één bed sliepen, Japi onder 't laken en Bavink er boven, dat ze
om beurten jenever hadden gedronken uit 't ééne bierglas dat Bavink
nog had. "Ik heb z'n kacheltje kaduuk gestookt, Zondagavond."

In één avond hatti 't kapot gestookt. Hij had maar zitten opladen en
zitten poken, en naar den gloeienden pot zitten kijken en z'n pijp
gerookt, de kachel zoo te zeggen tusschen z'n knieën. En niks gezegd
hatti, tot Bavink plotseling gezien had dat er een groote scheur in den
pot was en vreeselijk had opgespeeld. Japi had 'm laten uitrazen, hij
was opgestaan en had z'n stoel weggenomen, en Bavink had met de pook
't schuifdeurtje open gemaakt en een gat gebrand in den grond met 't
uitscheppen van de gloeiende kolen. En toen Bavink was blijven razen
had Japie gezegd: "Verrek met je kachel", en was kalmpjes weggegaan
naar 't huis van z'n ouwe heer en had een schoone boord omgedaan van
z'n broer, en van z'n moeder een stuk taart gekregen dat van 't dessert
was overgebleven. En had een nacht thuis geslapen en den volgenden
middag  was i op straat Loef tegengekomen dien i ook al kende. Loef die
later met zwemmen verdronken is, juist toen i er zoon beetje begon te
komen; en die had hem weer meegenomen naar Bavink en gezegd: "Bavink
ik breng je kaduukstoker mee." En Bavink had om 't geval gelachen,
En Japi was dadelijk naar 't plankje geloopen en had, op 't bekende
plaatsje "naast Dante", een nieuw kruikje Bols gevonden. En met z'n
drieën hadden ze 't een heel eind soldaat gemaakt en toen had Japi
dikke boterhammen gesneden van Bavink z'n brood en toen waren ze met
hun drieën naar 't Amstelveld gegaan en hadden voor 70 cent een nieuw
kacheltje gekocht ('t was Maandag), een kachel van een voorwereldlijk
model; en met z' drieën hadden ze die op een handkar naar huis gekruid.

Ik presenteerde Japi een kop thee. Hij dronk uit een spoelkom, een
kopje had ik niet voor 'm, steunde behagelijk en zette de kom hard
neer. "Nu wou ik wel een stukje brood hebben", zei i; "neem me niet
kwalijk, ik geloof dat ik den weg al weet." Hij had m'n kast al in de
gaten gehad "Kerel", zei i, "weet je dat je worst in huis hebt?" Of ik
't wist. Hij kwam er al mee aanzetten. "Boterhammenworst, een ordinair
volksvoedsel." Mijn worst, mijn rijkdom, zoo even nog het onderwerp van
mijn mijmeringen over mijn weelde, de worst die ik voor morgen wilde
bewaren. Japi wist er raad mee. En ik moet zeggen hij vergat mij niet,
hij gaf me twee plakken op elke boterham. Er was toch genoeg. Japi
at. Wat kon die kerel eten! Het brood lag naast 'm op tafel en
hij sneed maar. Ik begon er schik in te krijgen. "Geneer je niet
Japi, centen genoeg." Japi had ze nog niet gezien. "Goddome", zei i,
"vetpot!" "Ze hebben zeker weer wat van je geplaatst". Ik knikte. "Zoo
moet je maar doen", zei i, "die kerels zijn toch nergens anders goed
voor dan om ons de kost te geven. Ik heb van m'n leven ook nog eens
iets geschreven." Hij propte z'n mond vol brood en worst en veegde z'n
handen af met 't Handelsblad, dat i daarna in elkaar frommelde. "Ik
zal er maar niet op schrijven, ik deug daar toch niet voor."

En toen kwam uit een binnenzak een oud vermolmd onwelriekend krantje,
op de vouwen doorgesleten: "De Vlachtwedder Grensbode." Hij liet me een
artikeltje zien: "Brieven uit Amsterdam" stond er boven. Zes hatti er
geschreven, zei i, de vijf andere had z'n broer zoek gemaakt. Japi nam
nog een sneedje brood. "Moet je niet meer?" vroeg hij. Ik bedankte en
Japi nam 't laatste van m'n twee ons worst, "'t Ordinaire volksvoedsel"
ging er goed in. "'s Nachts gemaakt" zei Japi met z'n mond vol en
wees met 't mes naar 't krantje. "Na kantoortijd, 's Avonds moest ik
altijd op kantoor terugkomen. Af en toe moest ik m'n hoofd onder de
kraan houden om wakker te blijven. Ik zou je nu danken. Wat heb ik
er aan? Niks, moe word je er van. 'k Loop liever bij den weg en kijk
naar de menschen en de wagens en de huizen. Speciaal kijk ik naar de
lieve jonge meisjes en de pas getrouwde vrouwtjes. Die pas getrouwde
vrouwtjes pik je er zoo uit, die herken je dadelijk. En dan denk ik
aan 't plezier dat ik van al die lieve diertjes niet heb. Dat doe
ik liever dan dat ik er over schrijf. Wat gaat 't die kaffers aan,
wat ik zie. Zelf loopen ze bij de straat te sloffen en naar den grond
te kijken en trekken vervelende gezichten omdat 't zoo ver is, en
't leven zoo moeilijk, dat je er akelig van wordt. Doen zij iets voor
mij? Die paar centen kunnen ze houden."

't Artikeltje was wel aardig, maar Hoyer zei later dat i vast niet
geloofde dat 't van hem was.

"Nu zou ik wel een potje bier lusten", zei Japi en leunde
achterover. "'t Spijt me kerel", zei ik, "ik heb niets in huis,
geen bier en geen jenever en geen kleeren om over straat te gaan,
maar steek een sigaar op."

De regen kletterde op 't dak alsof i er door zou komen, de ruiten waren
wit van 't water. Japi had geen zin er uit te gaan, dat zag ik wel. Hij
stak een sigaar op, keek een poosje naar den rook en vroeg toen: "Die
Hoyer, wat is dat toch eigenlijk voor een kerel?" Hoyer en hij konden
't niet goed vinden. Dat had ik wel gedacht. Hoyer was op de penning
en een ruwe vent. "Die kerel deugt niet", zei Japi, "die moet vooral
maar veel met verf knoeien, voor iets beters is ie toch niet goed."

Bavink was een dag uit de stad geweest: "voor zaken" zei Japi en
toen was hij (Japi) van Houten tegengekomen op weg van kantoor naar
huis. Van Houten (een kennis van Bavink) was een kantoorbediende
die dacht datti schrijven kon. Hij had indertijd een dikken roman
gepubliceerd, waar de uitgever heel wat aan te kort gekomen was. Japi
had zich door hem mee laten nemen en zich te eten laten nooden. Hoyer
was er ook en 't eerste wat i gezegd had was: "Zoo, uitvreter!" Japi
vond dat prachtig. We waren toch allemaal uitvreters. "De burgerman
moet ons toch allemaal de kost geven." En dienzelfden avond had hij
Hoyer een riks te leen gevraagd, enkel om te pesten. Want hij wist
wel dat Hoyer toevallig geen geld bij zich zou hebben. Toch heeft
zelfs de lange Hoyer er naderhand aan moeten gelooven. Japie heeft
die malle zalmkleurige jas van 'm geleend en nooit teruggebracht. Maar
veel plezier heeft Japie er niet van gehad. Ieder oogenblik moest hij
er mee in den slag, en in Ouderkerk op de brug hebben de pummels er
een mouw uitgetrokken.

"Kom", zei Japi, "kwart over negenen, ik stap op. Hoor dien regen
eens." Hij ging voor 't raam staan. "Niks te zien", zei i. "Je kunt
niks zien door dien regen. Foei ik ben rillerig geworden, mijn knieën
zijn nog nat. Jammer dat je niks in huis hebt." Ik haalde zijn jas. Hij
was nog zwaar van 't water.

"Moet je ver door dat weer?" vroeg ik. "Ik kan wel naar de ouwe
gaan", zei Japi, "maar dat is ook nog een half uur. Dat is je nest,
hè?" Japi schoof 't gordijn weg en ging op m'n ledikant zitten en
gaapte. "Ik geloof dat ik ziek ben", zei i; "weet je wat je doen
moest, haal voor mijn rekening een half maatje ouwe klare, ik zal
't je bij gelegenheid wel teruggeven." Ik stond daar nog met z'n jas
over m'n arm. "Trek mijn jas aan", zei i. Ik scharrelde naar zolder;
m'n vest was tamelik droog. De tapper woonde vlak bij. Ik schoot Japi
z'n jas over m'n vest. 't Natte ding maakte me koud en akelig. Zoo
ging ik al die trappen af en de straat over. Bij den tapper was niks
te doen, ik bleef geen tien minuten weg. Toen ik boven kwam lag Japi
te ronken, aangekleed, z'n schoenen nog aan. "Hallo", riep ik en
schudde aan z'n schouder. Hij mompelde wat. "Hallo, jenever." Hij
keek me lodderig aan en kwam langzaam overeind. "O", zei i, "ik zie
't al". Hij dronk een spatje. "Daar knap ik van op." "Zeg", zei i,
"kan ik hier niet maffen? Ik ben vannacht niet op mijn bed geweest en
vandaag kon ik niet slapen." Wat moest ik doen? Hij kon wel op den
grond slapen, zei i, als i maar wat onder z'n hoofd had. "Goddank",
zei i en smeet zijn twee schoenen tegelijk over den vloer. "Goddank,
dat ik uit die natte krengen ben." Toen hing i z'n broek over de
leuning van een stoel "om te drogen." Mijn stelletje schoof i op zij;
in den hoek legde i de boeken van Appi, z'n jasje legde i er over heen,
z'n vest hield i aan. Toen nam i mijn beste deken, rolde zich er in,
dronk nog een spatje en ging met z'n hoofd op 't stapeltje liggen en
zei: "Wel te rusten."

En ik ging weer aan tafel zitten, keek naar mijn centen en dutte
in. Toen ik wakker werd knetterde de lamp, de olie was op. Ik kroop in
mijn ledekant en sliep slecht, door de kou. Japi had nergens weet van.

Toen de dag aanbrak en ik voor de zooveelste maal wakker werd, hoorde
ik hem rammelen. Hij was bezig thee te zetten, had zelf beneden
water gehaald, en zich aan m'n ontstelde buren voor een neef van mij
uitgegeven. Hij had best geslapen, hij was alleen een beetje stijf. Hij
hoopte dat i me niet wakker had gemaakt. "Ik heb al gegeten", zei i
"ik geloof dat je niet al te veel brood meer hebt." Hij moest weg. Hij
wilde Bavink nog spreken die toen gemeenlijk 's morgens om een uur
of tien ging slapen. Hij bracht mij een kom thee in bed en stond bij
't raam z'n kom leeg te slurpen. Met twee handen hield i die vast en
keek naar buiten. "Allemaal armoed", zeidi. "Nou bonjour hoor, mijn
jas kan ik zelf wel van de lijn halen." Bij de deur draaide i zich
nog even om. "'s Avonds ziet zoo'n hok er een boel gezelliger uit."

Dat vond ik ook. Ik scharrelde mijn bed uit, koud en beroerd. Op tafel
lagen m'n centen nog. Hij zegt dat hij z'n ouwe heer niet noodig heeft,
dacht ik, en de centen van den burgerman evenmin. Zegt u dat wel.




V.


"Koekebakker", zei Japi, "ik voel me zoo raar van binnen." 't Was op
een middag bij Bavink. Ik had Bavink willen spreken,  maar die was
uit. Japi zat aan tafel met een fleschje inkt van een stuiver en een
pak kranten voor zich. "Koekebakker, ik voel me zoo raar van binnen."

"Je ruikt tenminste degelijk naar jenever", zei ik.

"Nee", zei Japi, "de jenever is 't niet. Ik geloof dat mijn
ziel te groot is." Zoo'n uitvreter toch! "Wat moeten die kranten,
Japi?" vroeg ik. Japi gaf een klap op 't pak. "Nieuwzen van den Dag,
Koekebakker, Nieuwzen van den dag. Er zijn er bij van een maand
oud." "Moet je weer solliciteeren, Japi?" "Juist geraden man. 't
Gaat zoo niet langer. Pak een stoel. Kijk eens aan, K H 14684
Nieuws van den Dag. WelEdl. Heeren."--"De hoeveelste is dat?" vroeg
ik.--"De eerste pas. Dat gaat niet zoo gauw. Dat komt, omdat jelui
nooit in den handel zijn geweest, jelui weet niet, hoe 'n toer dat
is. Wat zal je drinken, kerel? Je neemt me wel niet kwalijk?" en hij
doopte z'n pen in de inkt en staarde op z'n papier. "Koekebakker",
zei Japi, keek hulpeloos rond en legde z'n pen neer. "'t Gaat niet,
ik ben er geen kerel voor. Eenmaal ben ik in den handel geweest. Ik
deug er niet voor. Ik weet 't bij ondervinding. Ik begrijp er niks
van. Waar is dat allemaal goed voor? Ik ben zoo best tevreden. We
zullen dat maar weer wegbergen." En hij nam het pak kranten en legde
't zorgvuldig onder tafel.

"Zie zoo, nu zie ik ze niet meer. Jij weet niet wat handel is,
Koekebakker, anders zou je der niet om lachen. Om te beginnen ga
je tot je achtiende jaar op school. Heb jij ooit geweten hoeveel
schapen er in Australië zijn en hoe diep 't Suezkanaal is? Nou juist,
daar heb je het. Ik heb dat geweten. Weet jij wat polarisatie is? Ik
ook niet, maar ik heb 't geweten. De raarste dingen heb ik moeten
leeren. Vertaal in 't Fransch: "onder benefice van inventaris." Ga der
maar tegen aan staan. Je hebt er geen begrip van, Koekebakker. Dat
duurt zoo jaren. Dan doet je ouwe heer je op een kantoor. Dan merk
je, dat je al die dingen geleerd hebt om met een kwast papier nat te
maken. Overigens is 't 't ouwe gedonderjaag, 's morgens om negen uur
present en urenlang stil zitten. Ik vond dat ik op die manier niet
opschoot. Ik kwam altijd te laat, ik probeerde wel op tijd te komen,
maar 't wou niet meer, ik had 't zooveel jaren gedaan. En taai. Ze
zeiden dat ik alles verkeerd deed, daar zullen ze wel gelijk aan
gehad hebben. Ik wilde wel, maar ik kon niet, ik ben geen kerel om te
werken. Ze zeiden, dat ik de anderen van hun werk hield. Ook daarin
zullen ze wel gelijk gehad hebben. Als ik klaagde, dat ik 't niks
lollig vond en vroeg of ik daarvoor nu op school al die wonderlijke
dingen had geleerd, dan zei de oue boekhouder: "Ja jongetje, het
leven is geen roman." Bakken vertellen, dat kon ik en dat vonden
ze leuk ook, maar ze waren er niet tevreden mee. De ouwe boekhouder
wist al heel gauw niet wat hij met me doen moest. Als de baas er niet
was maakte ik dierengeluiden, zong komieke liedjes, die ze nog nooit
hadden gehoord. De zoon van den baas was een ingebeelde kwajongen;
af en toe kwam i op kantoor om centen te halen. Hij sprak vreeselijk
gemaakt en keek met een allerellendigst, door niets gemotiveerd vertoon
van superioriteit naar de bedienden van zijn pa. De lui lachten zich
een beroerte als ik dien jongeheer nadeed. Ik heb daar ook nog een
schrijfmachine bedorven en een boek weggemaakt. Toen hebben ze me
aan een toestel gezet, dat ze de "guillotine" noemden. Daar moest
ik monsters mee knippen. Dagen lang heb ik daaraan gestaan: alle
monsters werden scheef. De lui hadden 't wel in de gaten, ze hadden
niets anders verwacht. Ze hadden me daar alleen maar aan gezet om
erger te voorkomen. Die monsters werden weggegooid; die gingen nooit
naar de klanten. Toch had ik in die dagen nog gelegenheid om een brief
verkeerd in te sluiten. Natuurlijk was 't erg; de man die den brief
kreeg mocht niet weten, dat de baas zaken deed met den man waaraan
i geschreven was. De boekhouder was totaal van streek. Toen begreep
ik, dat ik maar liever heen moest gaan. Ik kreeg een poot van den
baas. Ik was zelf ook blij dat ik wegging en heb hem hartelijk de
hand geschud. Ik heb gezegd, dat 't me speet, maar dat ik er niets
aan doen kon en ik geloof, dat 'k 't meende. Zie je, Koekebakker,
dat is handel. Ik ben daarna nog drie weken volontair geweest op een
effectenkantoortje, krantjes nakijken met een boek om te zien of de
stukken van de klanten waren uitgeloot. Je ergste vijand zal er voor
bewaard blijven. Ze moesten me wegdoen. Ik moest daar ook copieeren. Er
was geen denken aan, dat ze uit 't copieboek konden wijs worden. Ik
zag wel in dat 't zoo niet ging, ik kon er mijn hoofd niet bij houden.

"Mijn ouwe heer was ten einde raad. Hij hoopt nu, dat 't met de jaren
wel beteren zal. Ik weet dat zoo niet. 't Lijkt er nog niet veel
op. 'k Heb 't nog veel te goed zoo. Weet je dat Bavink pas een bom
duiten heeft gemaakt? Een slootje bij Kortenhoef met een hooibergje
en een kalf. Als je blieft." En hij haalde zijn portemonnaie voor
den dag. "Hij puilt van de centen. Koekebakker, jong, hij puilt van
de centen. Harde riksjes. Morgen ga ik op reis."

"Met Bavink?" vroeg ik. "Neen," zei Japi, "niet met Bavink, alleen. Ik
ga naar Friesland." "Midden in den winter?" Japi knikte. "Wat
doen?" Hij haalde z'n schouders op. "Doen? Niks doen. Jelui kerels
zijn zoo akelig wijs: alles moet een reden en een doel hebben. Ik ga
naar Friesland, niks doen, nergens om. Zonder reden. Omdat ik er zin
in heb."

Den volgenden avond bracht ik hem weg, in donker, naar den sneltrein
van zevenen. Hij had een jas zonder knoopen aan, die hem veel te
wijd was, een pet op, die hem een eind achter de ooren zakte en aan
z'n voeten de nieuwe gele schoenen van Appi. In z'n hand hatti een
papieren sigarenpijpje met een reclame. "Wacht even", zei i, toen
we al beneden waren. "Ik heb nog wat vergeten." Even daarna kwam i
terug met een vischhengel.

Hij was weinig spraakzaam dien avond. Ik kon niet uit hem krijgen
wat hij met dien vischhengel wilde. Onderweg rookte hij in een half
uur vier sigaren uit zijn papieren sigarenpijpje, en toen ik aan het
portier van hem afscheid nam vroeg hij me of ik niet een beetje tabak
voor hem had.

Na zes weken kwam hij terug met zes knoopen aan zijn jas en een
paar rooie pluche pantoffels aan zijn voeten. Hij weigerde alle
opheldering. Waar zijn vischhengel was? Oh, die had i uit den trein
laten vallen. Hij was ook nog een keer in 't water gevallen, zei
i. Meer liet hij niet los. Blijkbaar had i zich al dien tijd niet
laten scheren, hij had een kleur van roode baksteen en een lucht
van koemest bij zich. Hij bracht twee pond tabak mee, die niemand
rooken kon. Hij was er aan verslaafd en kwam in veertien dagen niet
om een sigaar. Toen waren de twee pond op, plus een peukie dat hij
ook nog had meegebracht. Toen bleek dat hij nergens in Amsterdam
die tabak kon krijgen. Hij schreef er om naar Friesland, maar kreeg
geen antwoord. Hij was er beroerd van. Maar na een paar dagen zag
ik hem toch weer bij Bavink zitten met een sigaar in 't hoofd, van
Bavink natuurlijk.




VI.


Den zomer daarop was Japi weer verdwenen. Toen kwam ik hem tegen op den
Boulevard du Nord in Brussel. Mijnheer was piekfijn, glad geschoren,
een grijs hoedje, een goudgeel smal zijden dasje, een geruit overhemd,
een gordel, een wit flanellen jasje met dunne blauwe streepjes, een
witte linnen broek, van onderen onberispelijk omgestreken, bruine
sokken met witte ruiten, lage schoenen.

Hoe het ging? Patent. Wat hij daar deed? Op en neer loopen van het
Gare du Nord naar het Gare du Midi over de boulevards. Of hij zich
amuseerde? Uitstekend. Waar hij woonde? In Uccle. Wie hij uitvrat? Hij
lachte, maar gaf geen antwoord. In het Maastrichtsche bierhuis op
de Place Brouckère dronken wij ettelijke potjes zuur bier, waar hij
verzot op was geworden. Eigenlijk dronk hij al die ettelijke potjes
op een na, dat ik staan liet. Hij zat weer prinselijk achterover op
zijn stoel en dronk met waardigheid en smaak, hield een beschouwing
over asphalt, over de groote markt, over het mooie weer, zei toen dat
hij naar huis moest en vroeg waar ik logeerde. Dan zou hij mij eens
komen opzoeken. Daarna betaalde hij de potjes bier, en liet mij in
verbazing achter.

Begin Augustus kwam hij in Amsterdam terug met een verbonden
hoofd. In Marchienne aux Ponts had hem een mijnwerker een geëmailleerd
etens-pannetje op 't hoofd stukgeslagen. Hij was gesjochtener dan
ooit, zijn ouwe heer hield hem schrikkelijk krap. Tot diep in November
droeg hij zijn witte broek, die toen allang niet wit meer was. Hij
was de oude niet meer, hij sprak weinig en rookte veel minder. Als
hij bij Bavink op 't hok kwam en Bavink legde zijn sigaren op tafel,
dan liet i zich op zijn stoel vallen, hield zijn jas aan en zijn
hoed op, nam moeizaam een sigaar, beet er langzaam het puntje af en
had moeite om de lucifers te vinden, knoeide met aansteken, rookte
langzaam en zelden meer dan één sigaar op een avond. Stak hij een
tweede op, dan gooide hij een groot stuk weg, wat hij vroeger nooit
deed. Toen rookte i tot 't endje te klein werd om vast te houden,
dan stak hij er een speld in en rookte 't zoo op. Het duurde niet
lang of i rookte scheef. Eens liet hij bij Bavink de kachel uitgaan.

Toen gaven wij hem op.

En toen op een nacht dat het hard vroor, tusschen Kerstmis en
Nieuwjaar, toen kwam Hoyer dien wij in maanden niet gezien hadden,
en nadat we een tijd hadden zitten kletsen, vroeg i naar Japi. En toen
begon i herinneringen op te halen. Of we nog wisten hoe Japi verleden
zomer (dat was toen zoowat een half jaar geleden) 's nachts mee ging
roeien op den Amstel. Hij zou in de punt gaan zitten om uit te kijken,
want de Volharding voer toen alles kapot, had nog pas een tjalk in
den grond gevaren aan den Omval. En Japi zat in het water te kijken
naar de weerkaatsing van de sterren en zat met zijn rechterhand in
het water en zag geen Volharding, zoodat de Volharding om voor ons
uit te wijken bijna in de bocht aan den grond voer. De kerels werden
toen kwaad en een van hen kwam op de achterplecht en schold ons uit
voor nakende verdommelingen, en smeet met een steen die een heel eind
voor onzen boeg in 't water plofte. Toen had Bavink gezegd, dat hij
't wel gedacht had en Japi zei: daar zijn we netjes afgekomen.

"Apropos", zei Hoyer toen plotseling (Hoyer werkte nog al met
burgermanstermen). "Apropos, ik heb Japi in Veere gezien met een
Fransche dame, een verdomd lief wijf. Den heelen avond hadden die
twee samen op 't steenen havenhoofd staan praten en over de balustrade
gekeken naar de lichtboei en 't draaiende licht van Schouwen en naar
de branding geluisterd, en "bekgetrokken" zooals Hoyer 't ordinair
uitdrukte. Bavink zei weer dat i 't wel gedacht had en ik zei: "ook
stom, dat hadden we kunnen weten," en toen kwamen wij los over Japi
en dat hij niet meer zoo uitvrat als we dat van hem gewoon waren.

't Duurde nog een maand voor dat Japi los kwam. Zijn ouwe heer
had een betrekking voor hem gevonden en den eersten Maart zou hij
aantreden. Hij zei niet dat ie 't beroerd vond. Hij zou eens zien wat
i er van maken kon. Hij zou vijftig gulden per maand verdienen. Dien
avond vroor het weer hard. De sterren waren helder en ontzettend
hoog. De kachel was niet aan. Wij zaten met ons drieën, jassen aan,
kragen in de hoogte, hoeden op zoo als wij zoo vaak hadden gezeten
als wij harder waren dan het kapitalistische gemoed en niets meer
hadden om te verstoken.

Toen begon Japi allerakeligst te boomen. Je zeilde maar met de aarde
door de ijzige donkere ruimte, de nacht zou niet meer ophouden, de zon
was weg en ging niet meer op. De aarde joeg voort in de duisternis,
de ijzige wind huilde er achter aan. Al die werelden zeilden verlaten
door de ruimte. Als er een tegen je aan zeilde was je verloren,
verloren met al die 1500 millioen ongelukkige menschen. Japi zat te
rillen in zijn jas, het vroor in de kamer.

Toen begon i weer anders. De zon kon zoo mooi in de Waal schijnen. Bij
Zaltbommel had i de zon in de Waal zien schijnen toen i de laatste maal
met den trein over de brug kwam. Tusschen de brug en de stad maakte
de zon een groote lichtplek  in het water. Het water stroomde maar,
de zon scheen er maar in, honderd, duizend, honderdduizend maal. Voor
tweeduizend jaar scheen de zon er al in en stroomde het water maar. God
weet hoe lang al. Meer dan 700,000 maal was de zon sedert al opgegaan,
meer dan 700,000 maal was i ondergegaan, al dien tijd had het water
gestroomd. Hij werd beroerd van dat getal. Hoeveel regendagen zouden
daarbij geweest zijn? Hoeveel nachten zou het zoo hard gevroren
hebben als nu, en harder? Hoeveel menschen zouden dat water hebben
zien stroomen en de zon er in zien schijnen en al die sterren gezien
hebben in de nachten dat 't zoo vroor? Hoeveel menschen die nu dood
zijn? en hoeveel menschen zouden dat water nog zien stroomen? En 2000
jaar was nog niets; duizende jaren langer had de aarde al bestaan,
duizende jaren kon i nog bestaan. Duizende jaren kon het water nog
stroomen, zonder dat hij het zien zou. En als de aarde verging dan
was er eigenlijk nog niks gebeurd. Daarna kwam nog zooveel tijd,
er kwam geen einde aan den tijd. En al dien tijd zou hij dood zijn.

Japies tanden klapperden; er was geen spatje jenever in huis en niets
meer te krijgen op de pof.

Toen werd Japi week. Toen begon i te spreken over Jeanne, zonder
eenige aanleiding, alsof wij er alles van wisten. En dat haar
handjes zoo zacht en zoo warm waren, dat haar oogen zoo konden
schitteren. Donkere oogen had ze en zwart haar. Wij begonnen er mee
te zitten. Hij deed de akeligste confidenties, over een witte rok met
kantjes, over een rok van lila zij; over haar kleine witte voetjes,
over allerlei lichaamsdeelen waar men niet over schrijft.

Op 't laatst begon i Fransch te praten, eenige tientallen malen hoorden
wij het woord "chéri" en "chérie". De laatste "e" van chérie sprak i
uit. Toen sprak i weer Hollandsch en werd zakelijker. Zij zou scheiden
van haar man, een misselijken droogpruimer, twintig jaar ouder dan
zij. Dat vonden wij nog al banaal. En 1 Maart moest i aantreden op
kantoor. Toen wreef i zijn gezicht met zijn beide handen en zei:
"Ik ga weg, geef me een poot." Op de trap stommelde i.

Een Maart trad i niet aan. Het werd April voordat hij weer zoover
was dat hij aan het werk kon gaan. Uitvreten deed i niet meer.

Maanden later op een avond zag Bavink hem zitten ergens drie hoog
in een kantoorgebouw. Hij zat aan 't raam te werken en 't lokaal
was hel verlicht. Bavink liep naar boven. Hij zat alleen en was
druk bezig. Bavink kon niets uit hem krijgen. Hij werkte maar en
zei weinig. Bavink snorde overal rond, pakte hier en daar een boek
uit de rekken, keek er in, zette 't weer weg, schudde zijn hoofd,
zei enkele malen: "'s jonge, 's jonge", draaide aan de copieerpers,
keek op straat, zette alle ramen open om te luchten.

Buiten viel een fijne sneeuw. Vlokken woeien naar binnen. "Doe als
je blieft de ramen dicht", zei Japi en bleef schrijven. Toen kreeg
Bavink een copieboek te pakken, bladerde en las er in, schudde weer
herhaaldelijk zijn hoofd en kwam toen bij Japi staan, 't copieboek
geopend in zijn handen.

"Zeg, schrijf jij dat allemaal?" Japi keek nauwelijks op en zei enkel:
"Niet allemaal." "Je bent toch een verdomd knappe kerel," zei Bavink,
"die handel is niet makkelijk." Daarna ging Bavink weg.




VII.


Japi was een harde werker geworden. Kort na het bezoek van Bavink
zonden ze hem naar Afrika. Binnen de twee jaar was i terug: ziek, half
dood. Niemand hoorde iets van hem, tot ik hem op een November-namiddag
zag staan achter den steenen wal bij het haventje van Wijk bij
Duurstede. Daar stond i naar den modder te staren. Ik had eenige
moeite hem te herkennen. Hij stak in een enorm wijde grijze jas, die
hem veel te groot was, een enorme grijze pet zat hem diep in de oogen
en over de ooren. Hij had een paar enorme breede bruine schoenen aan
met stompe neuzen, en enkele jongens achter zich.

Ik dacht: dat lijkt waarachtig Japi wel; en, ja hoor, het was 'm,
wat bleek en mager en zonder baard of snor en met een wonderlijk
starende uitdrukking in zijn oogen, maar het was Japi ongetwijfeld.

Japi zag niets, hoorde niets. Ik tikte 'm op zijn schouder en zei:
"Wat doe jij hier, hoe gaat het, hoe kom je hier?" Hij gaf me een hand,
zei niets, was niet verwonderd. "Ik sta maar te staren," zei i toen.

"Dat heb ik in de gaten," zei ik, "ga je mee een borreltje
pakken?" "Goed," zei Japi. De pummels die op eenigen afstand,
achterover tegen den steenen wal geleund, zich eenigen tijd geamuseerd
hadden met zeer luide en onhebbelijke glossen, groetten nu zeer
eerbiedig, omdat ik nogal wat geld verteerd had in Wijk bij Duurstede
en 's Zondags den notaris op zijn schouder had geklopt.

Na een borreltje kwam er wat leven in Japi. Gewerkt had i in Afrika,
last gehad van de hitte en van de beesten en koorts geleden, meer
koorts geleden dan gewerkt of iets anders. Als een geraamte was i
van den zomer teruggekomen.

Zijn Française leefde in Parijs met een Hollandsch jongmensch,
sedert onheugelijke tijden volontair op een kantoor. Had nog een
vriend die kolonel was. Had hem in Parijs getracteerd en hem in haar
gebroken Hollandsch een "goeie beest" genoemd en uitgelachen. Had haar
kousenband vastgemaakt waar hij bij was, zoodat hij een stukje van
haar bloote knie had gezien. Had hem daarna weggestuurd. Hij moest er
om lachen. Verliefd was i niet meer. Een licht blauwe zijden onderrok
had zij aan gehad. Een keer had i haar met den kolonel op het terras
van een kroeg gezien. De kolonel deed zeer zelfgenoegzaam en keek woest
en verwaten. Achter zijn rug om had ze Japi een oogje gegeven. Ze had
een borstkwaal en haar maanden waren geteld. En altijd even opgewekt;
maar loopen kon ze nog maar heel slecht.

En wat Japi nu van plan was? of hij nog uitvrat? Z'n kantoor vrat i
uit; iederen laatsten van de maand ging i zijn centen halen.

Of i van plan was nog weer eens zoo'n woeste werker te worden?

O nee. Te sappel had i zich gemaakt. Vijftien jaar ouder geworden
was i in de laatste drie, vier jaar.

Toen stak i een versche sigaar op, van mij, een sigaar van een
dubbeltje, met een bandje, ik was toen in goeden doen. Het bandje
deed i er af.

Geploeterd hatti, misère gezien hatti. In Marchienne aux Ponts
en Charleroi was het begonnen. Voor de aardigheid was i daar met
Jeanne heen gegaan. Na drie dagen had ze er genoeg van gehad. Hij was
gebleven. Een portretje liet i mij zien; een grijnzend doodskopje,
het dochtertje van een werkman uit een glasfabriek. Zeven kinderen
gehad, vijf dood, het zesde stierf terwijl hij er in den kost
lag, daar was dat portretje van. Daar hatti leeren kijken, gezien
wat werken was. Geld uitgeven hatti altijd verdomde leuk gekund,
anderen brachten 't op. Te sappel hatti zich gemaakt. Socialist had
i willen worden. Voor z'n brood hatti gewerkt, voortgejaagd was i,
voortgejaagd en gedrukt door menschen en de noodzakelijkheid zooals al
die anderen. Nachten hatti gewerkt: om één, twee uur was i in Amsterdam
van kantoor thuisgekomen en daarna hatti opgezeten, gepiekerd, gepend,
heele romans hatti geschreven en de paperassen verbrand.

Wat kon i doen? Wat bereikten ze met hun allen? Te sappel hatti zich
gemaakt, gloeiende speechen, woeste artikelen hatti gefantaseerd,
terwijl i op kantoor zat en werkte voor den handel van zijn baas,
hard werkte en iedereen zich verwonderde over de massa's werk, die
i verstouwde. De wereld was blijven draaien, draaide precies zooals
altijd, zou wel blijven draaien zonder hem. Te sappel had i zich
gemaakt. Hij was nu wijzer. Hij trok er zijn handen van af. Er waren
kooplui genoeg en schrijvers en praters en lui die zich te sappel
maakten, meer dan genoeg.

En altijd zaten ze in angst ergens voor en hadden verdriet ergens
over. Altijd waren ze bang ergens te laat te komen of van iemand een
standje te krijgen, of zij kwamen niet uit met hun tractement, of hun
plee was verstopt, of ze hadden een zweertje, of hun Zondagsche pak
begon te slijten, of de huur moest betaald worden; dit konden ze niet
doen hierom en dát moesten ze laten daarom. In zijn jongen tijd was
i nog zoo dom niet geweest. Een sigaartje rooken, een beetje kletsen,
wat rondkoekeloeren, je verheugen in het zonnetje als 't er was en in
den regen als 't er niet was, en niet denken aan den dag van morgen,
niets willen worden, niets te verlangen dan af en toe wat mooi weer.

Je kon 't niet volhouden. Dat wist i wel. Het kon nu eenmaal niet
bestaan of je moest een bom duiten hebben. En die hatti niet. Wat zijn
ouwe hem kon nalaten was de moeite niet waard. En hij, Japi, vond het
nu welletjes ook. Hij was nu bezig zijn tijd te verstaren. Bereiken kon
je toch niets. Hij scharrelde nog wat rond op de plaatsen waar i zich
vroeger geamuseerd had. Speciaal hield i zich bezig met in rivieren
te staren. In Dordrecht had i enkele weken starende versleten. In
Veere had i dagen lang boven op 't Hospitaal gekampeerd. September
had i in Nijmegen doorgebracht.

En toen met eenige variatie herhaalde i zijn oude rêverie over
't water. Van 't water dat maar altijd naar 't westen stroomde,
dat iederen avond naar de zon stroomde. In Nijmegen liep een ouwe
dokter rond, die drie-en-vijftig jaar lang 's morgens op 't zelfde uur
dezelfde wandeling had gemaakt. Over 't Valkhof en aan de Noordzijde
naar beneden en de Waalkade af tot aan de brug. Dat is meer dan 19300
maal. En altijd stroomde 't water naar het westen. En dat beteekende
nog niets. Het heeft zeker honderd maal drie en vijftig jaar naar
dien kant gestroomd. En langer. Nu ligt de brug er over. Nog maar
kort, nog maar wat jaren. En toch heel lang. Ieder jaar is 365 dagen,
tien jaar is 3650 zonnen. Iedere dag is 24 uur, en ieder uur gaat er
meer door de hoofden van al die tobbende menschen dan je in duizende
boeken zou kunnen opschrijven. Duizende tobbers die de brug gezien
hebben, zijn nu dood. En toch ligt i er nog maar kort. Veel, veel
langer stroomde het water daar. En er was een tijd toen dat water
er niet stroomde. Die tijd is nog veel langer geweest. Dood zijn
de tobbers gegaan bij honderde en honderde millioenen. Wie kent
ze nog? En hoeveel zullen er sterven na dezen? Ze tobben maar, tot
God ze wegraapt. En je zou denken: God zou ze een lol doen als i ze
plotseling te grazen nam. Maar God weet beter dan jij of ik. Tobben
willen ze, blijven voorttobben. En onderwijl gaat de zon op en onder,
de rivier daar stroomt naar 't Westen en blijft stroomen tot daar
ook een eind aan komt.

Neen plannen hatti niet meer, en te sappel maken zou i zich niet
meer. Daarvoor zou Japi wel oppassen. Een diner accepteerde i dien
avond nog wel. Zelfs zong i een komiek liedje en stak een malle speech
af, staande op een stoel.

Eenige maanden heeft Japi nog verstaard. Met zijn gezondheid ging
het niet al te best en de toelage van zijn kantoor hield op. Den
winter bracht i in Amsterdam door, waar ze druk bezig geweest waren,
mooie huizen af te breken en er leelijke voor in de plaats te zetten,
al tobbende.

In Mei trok i naar Nijmegen.

Daar schreef i me op een briefkaartje, dat Jeanne aan haar borstkwaal
gestorven was. Daar hatti op gewacht, schreef i.

Op een zomermorgen om half vijf, toen de zon prachtig opkwam, is
hij van de Waalbrug gestapt. De wachter kreeg hem te laat in de
gaten. "Maak je niet druk, ouwe jongen," had Japi gezegd, en toen
was i er afgestapt met zijn gezicht naar het Noord-Oosten.

Springen kon je het niet noemen, had de man gezegd, hij was er
afgestapt.

Op zijn kamer vonden ze een stok die van Bavink had gehoord  en aan
de muur zes briefjes met G.v.d. er op en één met "Ziezoo".

De rivier is sedert naar het Westen blijven stroomen en de menschen
zijn blijven voorttobben. Ook de zon komt nog op en iederen avond
krijgen Japi zijn oude lui het Nieuws van den Dag nog.

Zijn reis naar Friesland is altijd onopgehelderd gebleven.






TITAANTJES.


I.


Jongens waren we--maar aardige jongens. Al zeg ik 't zelf. We zijn
nu veel wijzer, stakkerig wijs zijn we, behalve Bavink, die mal
geworden is. Wat hebben we al niet willen opknappen. We zouden
hun wel eens laten zien hoe 't moest. We, dat waren wij, met z'n
vijven. Alle andere menschen waren "ze". "Ze", die niets snapten
en niets zagen. "Wat?" zei Bavink, "God? je praat over God? Hun
warme eten is hun God." Op enkele "goeie kerels" na werd iedereen
door ons veracht. Heel stilletjes zeg ik daar nu bij: "En niet ten
onrechte," maar dat mag niemand hooren. Ik ben nu geen held meer. Je
weet niet hoe je de menschen nog eens noodig kunt hebben. En Hoyer
vindt ook dat je geen aanstoot moet geven. Van Bekker zie of hoor
je niks meer. En Kees Ploeger praat van die rare kerels die 'm
op den slechten weg brachten. Maar toen waren we in de dagen onzer
dwaasheid, de uitverkorenen Gods, ja God zelf. Verstandig zijn we nu,
alweer behalve Bavink en we kijken mekaar aan en glimlachen en ik zeg
tegen Hoyer: "we zijn er niet op vooruit gegaan." Maar Hoyer is al
te ver heen, hij begint bij de bonzen van de S. D. A. P. te hooren,
en maakt een gebaar van twijfel met z'n handen en z'n schouders.

Wat we eigenlijk doen zouden is ons nooit duidelijk geweest. Iets
zouden we doen. Bekker had een vaag besef dat-i alle kantoren wilde
afbreken, Ploeger wilde zijn baas z'n eigen klokken laten inpakken
en er bij gaan staan met een sigaar in z'n hoofd en vloeken op die
kerels die nooit iets goed konden doen. Eéns waren we 't, dat we
"eruit" moesten. Waaruit, en hoe? Eigenlijk deden we niets anders dan
praten, rooken, drinken en boeken lezen. Bavink vrijde bovendien nog
met Lien. Achteraf bedenk ik, dat we een prachtig stel kerels geweest
waren om rijk te zijn, maar "centen hebben" vonden we verachtelijk;
alleen Hoyer begon daar vrij gauw anders over te denken. Bavink begreep
niet, waarom die kerels zoo maar in rijtuigen mochten rijden en dure
jassen aanhebben en andere lui commandeeren, die niet stommer waren
dan zij. Automobielen zag je toen zoo nog niet.

Heele zomernachten stonden we tegen 't hek van 't Oosterpark te leunen
en honderd uit te boomen. Een heel kamerameublement zou je daaraan
hebben kunnen verdienen, als je dat allemaal had kunnen onthouden. Er
wordt toch zooveel geschreven tegenwoordig.

Dikwijls waren we ook minder spraakzaam. Aan den rand van 't trottoir
zaten we tot lang na twaalven, zoo maar op de straatsteenen en
waren weemoedig en tuurden naar de klinkers, en van de klinkers naar
de sterren. En dan zei Bekker, dat-i eigenlijk medelijden met z'n
baas had en ik probeerde een gedicht te maken, en Hoyer zei, dat-i
opstond want dat die blauwe steen zoo optrok. En als in die korte,
zoele nachten het zwart recht boven onze hoofden wat verschoot, dan
zat Bavink met z'n hoofd in z'n handen, over de zon te praten, bij
't sentimenteele af. En we vonden dat 't zonde was naar bed te gaan,
dat een mensch eigenlijk altijd op moest kunnen blijven. Ook dat
zouden we veranderen. Kees zat te slapen.

En dan gingen we de zon op zien komen aan de Zuiderzee, behalve Kees,
die naar huis ging. Hoyer klaagde over de kou, maar Bavink en Bekker
wisten nergens van. Die zaten op de steenen onder aan den zeedijk
met de oogen half dicht en keken tusschen hun oogharen door naar de
dansende gouden pijltjes die de zon in 't water maakte. Stapelmal
werd Bavink er van. Naar de zon loopen wilde-i over de lange, lange
schitterende streep. Maar aan den kant van 't water bleef-i toch
maar staan. Ik herinner me, dat we, Bavink en ik, eens op een keer
aan zee kwamen, toen de halve zon groot, koud en rood aan de kim
stond. Bavink sloeg met z'n vuist tegen z'n voorhoofd en vloekte:
"God, God, dat schilder ik nooit. Dat kan ik nooit." Nu zit-i in
een gesticht. Als we teruggingen, konden we een heelen tijd niets
zien dan gele vlekken en voor onze bazen waren zulke tochten heel
slecht. Want ik was er op kantoor nog slaperig van en Bekker, die er
beter tegen kon, zat den geheelen dag over de zon te suffen en meer
dan ooit naar de verlichte boomtoppen aan de overzij van de tuinen
te staren en erger dan ooit naar zes uur te verlangen.

Waar we ook heel sterk in waren, dat waren, na kantoor, tochten naar
den Ringdijk. Daar zaten we in 't gras tusschen de boterbloemetjes
beneden aan den dijk en dan kwamen de nieuwsgierige koeien met hun
groote oogen en keken naar ons en wij keken naar de koeien. En dan kon
je ervan opaan, dat Bavink over Lien begon. Op de een of andere manier
moeten die koeienoogen daar iets mee uit te staan gehad hebben. En
dan begon 't te schemeren, de kikkers gingen kwaken, één ging er
vreeselijk te keer, vlak bij mijn schoen, m'n eene voet lag bijna
in de sloot. Andere hoorde je zachtjes, ver, heel ver weg. Een koe,
die je nauwelijks meer kon zien in de halve duisternis, hoorde je
't gras afschuren. In de verte begon er een klagelijk te loeien. Een
paard holde heen en weer, je hoorde 't maar zag 't niet. De koe bij
ons blies en werd onrustig. Bekker zei: "'t Is hier goeie. Zoo moest
't maar blijven." Bavink stond overeind en breidde z'n armen uit en
luisterde, en ging daarna weer zitten en zei dat we der ook nooit iets
van zouden snappen, hij zelf ook niet, en dat we eigenlijk niet veel
beter waren dan al die andere lui, en ik geloof, dat-i daar heel na
aan de waarheid was.

Neen, we deden eigenlijk niets. Ons werk op kantoor deden we niet
al te best, en onze bazen verachtten we, behalve Bavink en Hoyer,
die geen bazen hadden en niet begrepen, waarom we iederen dag weer
naar die bazen toegingen.

We wachtten maar. Waarop? Dat hebben we nooit geweten. Bekker zei:
"Op 't koninkrijk Gods." Dat wil zeggen, dat heeft-i een keer gezegd
zonder zich nader te verklaren. Bavink had 't altijd over "het einde,
dat meteen 't begin zou wezen." Wij vonden dat allemaal volkomen
duidelijk en weidden er niet verder over uit.




II.


Op den zolder van Kees kwamen we dien zomer bijna iederen avond
bij elkaar. Kees had ook een "hok" moeten hebben. Zijn hok was 't
grootste en voor allen makkelijk te bereiken. De buren vonden 't niks
leuk iederen avond dat geloop op de trap. Kees z'n vader begreep er
niks van. Tegenwoordig groet-i me heel beleefd en noemt me "mijnheer
Koekebakker", omdat-i m'n naam in 't Handelsblad heeft gezien.

Bekker had Kees gezegd, hoe-i 't doen moest. Ze hadden goedkoop
bloemetjesbehangsel van 3 centen de rol gekocht en dat achterstevoren
tegen den muur geplakt, de effe groene achterkant buiten. Bekker had
een spreuk geschreven met sier-letters en die aan den muur geplakt
naast de deur. "J'ai attendu le Seigneur avec une grande patience,
enfin il s'est abaissé jusqu'à moi."

Ik weet niet meer waar-i dat vandaan had gehaald. Kees kon 't niet
lezen. Maar Kees had óók iets gedaan. Hij had een spa gemaakt en Bekker
had die diagonaalsgewijs aan den muur geprakkizeerd in 't aangezicht
van de spreuk. Het was eerst niet duidelijk, wat dat moest beteekenen,
maar naderhand bleek, dat Bekker zich in zijn hoofd had gehaald, dat-i
metdertijd op de hei zou gaan wonen en daar een brokje land bewerken,
dan hoefde-i niet meer naar kantoor. Bavink vond dat een mooi idee,
maar-i was bang dat Lien er geen zin in zou hebben en Hoyer zat liever
in de kroeg.

Daar zaten we dan en lieten niets heel. Tenminste niet veel. Ik
herinner me, dat Zola en Jaap Maris tamelijk ongeschonden bleven
en misschien nog wel de een of ander. Bekker las uit Dante voor,
de Prediker en 't Hooglied en 't boek Job kende-i uit z'n hoofd. 't
Was heel indrukwekkend. Van de buitenwereld merkte je niet veel op
dat hok. Het eenige raam was bijna schouderhoogte van den grond;
als je aan tafel zat, zag je niet veel meer dan een stuk lucht,
waar langzamerhand de kleur uitweek, en wat sterren, als 't donker was.

Schilderen? Wie kon er nog schilderen, als je Bavink hoorde? Alles
lieten de lui zich voorzetten, letterlijk alles. Ik moest maar eens een
schilderij maken. Dat was ik zelf, Koekebakker. Hij zou me zeggen wat
ik doen moest. "Je schildert twee horizontale banen, onder elkaar, even
breed, een blauwe en een goudgele en in 't midden van die blauwe baan
maak je een ronde goudgele vlek. En dan zetten we in den catalogus:
No. 666 De Gedachte, schilderij. En dan zenden we 't in op mijn naam:
Johannes Bavink, 2de Jan Steenstraat, nummer zooveel en we prijzen
't voor f 800. Je zult eens zien wat ze er in ontdekken. Van alles,
waar je zelf nooit een flauw benul van gehad hebt."

Bavink was toen nog erg jong.--Naderhand kwam Lien daar ook en zette
thee. Eén keer heeft ze den grond geboend en alles afgestoft; maar
dat was heel ongezellig. Kees kwam er door in verlegenheid, want
tegen die juffrouw had de ouwe heer bepaald bezwaar. En Bavink was
niet zooals we hem graag zagen, wanneer Lien er bij was en had een
neiging om haar voortdurend te knijpen. Dat was hinderlijk.

Gelukkig liet hij haar al heel gauw weer thuis, omdat-i dacht, dat
Lien mij oogjes gaf. Bekker zei: "Meiden, dat is niks" en rookte
met bizonder welbehagen z'n steenen pijpje toen ze er voor 't eerst
weer niet bij was. Het was dien avond ook heel genoegelijk. Uren lang
zaten we in donker. De lamp was gaan zakken en daarna uitgegaan. We
bleven maar zitten en rookten, uren lang. Af en toe zei iemand eens
wat. Bavink vond schilderen 't stomste dat iemand doen kon. Kees
begreep er weer niks van. "Je moest zoo maar stilletjes blijven
zitten," zei Bavink en keek naar de lucht. Een groote groenachtige ster
stond daar te donkeren. "Je moest zoo maar stilletjes blijven zitten
te verlangen zonder te weten waarnaar." En hij stopte een versche pijp.




III.


Het was een wonderlijke tijd. Als ik er even over nadenk, dan moet
die tijd nog voortduren, die duurt zoolang er jongens van negentien,
twintig jaar rondloopen. Maar voor ons is hij lang voorbij.

Wij waren boven de wereld en de wereld was boven ons en drukte zwaar
op ons. Heel in de diepte zagen wij de wereld vol bedrijvigheid
en verachtten de menschen, de gewichtige heeren vooral, de heeren,
die 't druk hebben en die denken dat zij 't aardig ver in de wereld
hebben gebracht.

Maar wij waren arm. Bekker en ik moesten 't grootste deel van onzen
tijd op kantoor doorbrengen en doen wat die heeren zeiden en hun domme
opinies aanhooren, als ze met elkaar spraken en verdragen, dat zij
zichzelf veel flinker en knapper vonden dan ons. En als zij vonden,
dat 't koud was, dan moesten alle ramen dicht en 's winters moest
't licht veel te vroeg op en de gordijnen moesten neer, zoodat wij
de roode lucht niet zagen en 't schemeren in de straat niet, en wij
hadden niets te vertellen.

En wij moesten in straten wonen, heel bekrompen, met uitzicht op
de lancaster gordijnen van den overkant en de balletjesfranje en de
aspedistra in een pot met een onbestaanbare bloem er op.

O, wij namen wraak, wij leerden talen, waarvan zij de namen nooit
gehoord hadden en wij lazen boeken waar zij niets van konden begrijpen,
wij doorleefden gevoelens waarvan zij het bestaan niet vermoedden. 's
Zondags liepen wij uren en uren ver over wegen, waar zij nooit
kwamen en op kantoor dachten wij aan de slootjes en de weilanden,
die wij gezien hadden en terwijl de heeren ons bevalen dingen te doen,
waarvan wij 't nut niet begrepen, dachten wij eraan, hoe Zondagavond
de zon was ondergegaan achter Abcoû. En hoe wij woordeloos 't heelal
doordacht hadden, hoe God ons hoofd, ons hart en ons ruggemerg gevuld
had en hoe mal zij zouden kijken, als wij hun dat zouden zeggen. En
hoe zij met al hun geld en hun reizen naar Zwitserland en Italië en
Godweetwaarheen en met al hun knapheid en bedrijvigheid dat nooit
zouden kunnen beleven.

Maar met dat al hadden ze ons toch in hun macht, ze legden beslag op
't grootste deel van onzen tijd, zij hielden ons uit de zon en van
de weilanden en den waterkant vandaan. Ze dwongen ons voortdurend
onze gedachten bezig te houden met hun onbegrijpelijke zaken. Maar
dat ging zoo ver als 't voeten had. En zij gaven ons standjes; niks
waren wij op kantoor. "O, Bekker" zeiden ze tegen elkaar. Welopgevoed
waren de heeren; de juffrouw van tweehoog zei: "die halvegare",
daar waren de heeren te welopgevoed voor. En ze waren knap, veel
knapper dan de juffrouw van tweehoog, wier man lantaarnopsteker was,
een leuk vak, waar weinig geleerdheid voor noodig is. M'n baas vroeg
me of ik misschien gedichten maakte. Bekker vond dat zoo'n man dat
woord eigenlijk niet mocht uitspreken, dat moest niet mogen. "Wat
zei je tegen hem?" Ik had niks gezegd, ik had maar naar z'n gezicht
gekeken en gevonden dat-i zoo'n dikken kop had en gedacht: "hij weet
niet wien hij voor heeft, daar is hij te dom voor." En ze betaalden
ons slecht de heeren.




IV.


En verliefd waren we. Bekker liep maanden lang iederen morgen over
de Sarphatistraat waar hij niets te maken had. Hij hield van een
schoolmeisje van een jaar of zeventien en liep vijftig pas achter
haar of aan de overzij van de straat en keek naar haar. Hij heeft
nooit geweten hoe zij heette, nooit een woord met haar gesproken. In
de Kerstvacantie was-i ongelukkig. In Februari nam hij een middag
vrij om haar op te wachten, als de school uitging. Daar stond-i op 't
stille grachtje in de sneeuw en een vent reed voorbij op een wit paard,
met een blauwe kiel aan en een stroohoed op. Wat raar dat je juist op
zoo'n middag zoo iets geks moet zien. Maar om vijf minuten voor vieren
ging Bekker weg, hij dorst niet te blijven staan. Langzaam slenterde-i
weg en op de Weteringschans haalde ze hem in. Ze lachte luid tegen een
vriendin. Ik geloof niet dat zij ooit geweten heeft dat Bekker bestond,

Van mij wilde Bekker weten waar dat op uit moest loopen, dat kon
toch zoo niet doorgaan. En 't ging ook zoo niet door, want na de
zomervacantie kwam ze niet meer terug.

"Meiden," zei Bekker, "dat is niks gedaan... Ze veerde als ze
liep." Hij draaide de lamp wat op en sloeg een blad om van 't
boek waar-i in las. "Waar zou ze nu zijn?" "Zou ze zoenen?" Een
stukje vuur uit zijn pijp viel op 't boek. Hij doofde 't met een
lucifersdoosje. "Verdomme, een gat, dat heb ik stom gedaan." "'t Is
beter zoo, meiden is niks gedaan, je schiet er niet mee op, ze leiden
je maar af. Op een afstand zijn ze aardig, om gedichten op te maken."

Hij las. Na een poosje keek hij weer op... "Weet je wat een raar
ding is? Toen ze me dien middag inhaalde ging ze rakelings langs
me heen. Er was zoo te zeggen niks tusschen ons, een beetje kleeren
van haar en zoo goed als geen kleeren van mij." (Bekker liep zomer
en winter met z'n overhemd op z'n bloote lijf). "Dat is niet veel,
vind je wel?" Ik vond dat niet veel; tusschen den toren van Naarden
en de kamer van Bekker b.v. was veel meer. "Tusschen den toren van
Naarden en deze snor," zei Bekker, "is veel minder, veel minder dan
er toen was tusschen haar schouder en de mijne. 't Haalt er niet bij
Koekebakker." Hij sloeg weer een blad om, keek in 't licht, en zei:
"zoo is 't" en ging door met lezen.




V.


Zoo was 't: God liet zijn aangezicht zien en verhulde 't
beurtelings. Je schoot er niet mee op, ook al bewonderde je de meisjes
alleen maar uit de verte en al liet je hun bekjes zoenen door anderen,
door die gewichtige heeren, waar ze over 't algemeen meer mee op hadden
dan met ons. Die waren zooveel netter en praatten zoo aardig. En wij
waren armoedzaaiers.

Van God was niets te hopen, die gaat zijn eigen weg en geeft geen
rekenschap. Als we wat wilden moesten we 't zelf doen. Maar wij vonden,
dat Bavink en Hoyer makkelijk praten hadden, die konden wat, die konden
laten zien hoe 't moest, maar wij, Bekker en Kees en ik, wij konden
hoogstens "socialen" worden en dat leek toch wel wat erg armoedig,
nadat je aan Gods tafel had gezeten, adressen te gaan schrijven
voor drukwerk of lid te worden van de "vrije groep Kastanjeplein en
omstreken." En van dat wonen op de hei zou ook wel niets komen, want
als Bekker een paar centen bij elkaar had, dan moesten zijn schoenen
gelapt worden. In de kolonie van Van Eeden hadden we misschien kunnen
gaan, maar toen we op een Zondag er heen waren geloopen, vier uur
gaans, toen liep daar een heer, in een boerenkiel, met dure gele
schoenen, kolombijntjes te eten uit een papieren zak, blootshoofds,
in innige aanraking met de natuur, zooals dat toen genoemd werd, en
z'n baard vol kruimels. Toen dorsten we niet verder en liepen maar
weer naar Amsterdam terug en liepen achter elkaar langs de Naarder
trekvaart en zongen, en een boerenmeid zei tegen een boerenjongen:
"D'r het niks van in de krant 'estaan jong, hoe vin je dat nou? wist
jai d'r van?"




VI.


Dus deden we maar niks. Ja toch, in dien tijd maakte Bekker z'n
eerste gedicht.

'k Weet 't nog heel goed, 't was op een Zondag, natuurlijk. Als er
iets gebeurde, dan was 't op Zondag. Want de zes andere dagen van de
week droegen drie van ons onze ketenen van negen tot zes.

Ik was uit solliciteeren geweest in Hillegom bij een bollenhandelaar
met dikke roode gladgeschoren wangetjes. En de anderen hadden er
meteen een uitgangsdag van gemaakt. Bavink, Hoyer en Bekker hadden
alle drie al zoo vaak naar 't oudheidkundig museum in Leiden gewild
en nu zou 't er dan van komen. En Kees moest mee, die deed wat de
anderen deden. In Leiden zou ik hen vinden.

't Was in December. Ik stond achter op de tram, heelemaal achter op. De
tram reed maar door 't land en stond stil en reed weer, uren duurde 't,
de landen lagen eindeloos. En de lucht werd hoe langer hoe blauwer en
de zon scheen alsof er bloemen moesten groeien uit de boerenkinkels. En
de roode daken in de dorpen en de zwarte boomen en de akkers, veel met
riet gedekt, hadden het lekker warm, en de duinen stonden in de zon
met hun bloote hoofd. En de straatweg lag daar wit en pijnlijk in 't
licht en kon de zon niet verdragen en de ruiten van de dorpslantaarns
flikkerden, ook zij verdroegen met moeite 't felle licht.

Maar ik werd hoe langer hoe kouder. En zoo lang als de zon scheen,
reed de tram. 't Is een lange rit van Hillegom naar Leiden en de dag
is kort in December. En op 't laatst stond er een lijk op de tram te
staren in die malle groote koude zon, die vlamde als of de revolutie
moest beginnen, alsof ze in Amsterdam bezig waren de kantoren af te
breken, en die geen vonkje leven in m'n koude voeten en dooie beenen
kon brengen. En de zon werd steeds grooter en kouder en ik werd steeds
kouder en bleef even groot. En de blauwe lucht keek vreeselijk ernstig:
"Wat moest ik toch op die tram?"

Dien middag maakte Bekker z'n eerste gedicht. En toen ik met 't
aansteken van de gaslantarens in Leiden aankwam en de onsterfelijken
naast elkaar op een lange bank vond zitten in de derde klas
wachtkamer van 't station, bij de kachel, toen moest ik mee 't gedicht
ondergaan. 't Was heel mooi. Of 't geen naam had? Bekker schudde van
nee. Maar Bavink en Hoyer schreeuwden, dat ze gezien hadden, dat er
iets boven stond. Een burgerheer zei: "Opscheppers" tegen den man,
die aan de deur z'n kaartje knipte. Bavink had 't papier te pakken,
Wat stond er boven? Natuurlijk? "Aan haar." Dat had ik zóo wel geweten.

Bavink vond dat er een schepje op de kachel moest, maar kon de
kolenschep niet vinden. Ze nemen in die wachtkamers altijd den
kolenschep mee, anders stookt 't publiek te hard.

Toen gooide Bavink de steenkolen met z'n handen in de kachel en kreeg
mot met een kerel met een witte kiel aan.

't Was heel lollig dien avond. In den trein vielen Kees en Hoyer in
slaap. Bavink zat te praten met een Haagsch juffertje en de lucht
van heliotroop op te snuiven die haar lieve leden ontsteeg.

Toen begon Bekker weer over de hei te praten. Daar wilde-i stilletjes
wonen en maar afwachten wat God met 'm voorhad. Doen kon je niks. Hij
was erg weemoedig. Ik had bezwaar tegen die hei: 't is er zoo droog. En
ik vroeg Bekker waar-i van leven wilde, dat boeren van kantoorheeren
lukt gemeenlijk niet al te best, behalve in Amerika, waar allerlei
leugens van geloofd worden. Maar hij maakte zich daarover geen
zorg. Hij had niks noodig.

Nu weet hij beter. God alleen heeft niks noodig. En dat is nu juist
't groote verschil tusschen God en ons.

Er is dan ook niks van gekomen van die hei.




VII.


Wij zaten met z'n vieren bij Zandvoort in 't fijne witte zand aan den
voet van 't duin en keken naar zee. Kees was er niet bij. 't Was in
't laatst van Juli. Om zeven uur stond de zon nog hoog boven de zee,
maakte, alweer, ik kan 't niet helpen, 't is God zelf die steeds
in herhalingen vervalt, maakte alweer een lange gouden streep op
't water en scheen op onze gelaten.

Aan den gezichtseinder voer een sleepboot en rees en daalde; als-i
daalde zag je enkel de stoompijp.

Bekker zou den volgenden dag naar Duitschland gaan. Door zijn groote
talenkennis had-i een betrekking gekregen als correspondent op een
fabriek. En Hoyer ging naar Parijs, schilderen.

Bekker vooral was weer erg weemoedig. Hij wou dat-i dat baantje
maar niet aangenomen had. Hij begreep niet goed meer waarom-i 't
gedaan had. Twee uur was-i in dat ellendige fabrieksstadje geweest
om zich voor te stellen. Ziek was-i er geworden, heimwee had-i er
gekregen. Zoo gauw mogelijk was-i naar 't station gevlucht. Daar lagen
gelukkig de rails nog, onafzienbaar, recht, tot aan den horizon, de
weg naar Amsterdam. En zijn biljet had-i voor den dag gehaald. En er
had nog duidelijk opgestaan: "nach Amsterdam". En op tijd was de trein
gekomen en had 'm over de rails naar huis gereden. En toen-i aan 't
Centraal station was afgestapt, toen had-i in de volheid zijns gemoeds
een praatje gemaakt met den machinist en hem een sigaar gegeven,
een dure, en even de locomotief met z'n hand aangeraakt en gedacht:
"aai locomotief". En toch had-i dat baantje aangenomen. 't Gaf een boel
meer dan-i hier verdiende. En nu moest-i weg en zou den Ringdijk niet
meer zien. En al dien tijd zouden die rails daar liggen, maar hij zou
hoogstens daarginds op 't perron kunnen staan en er naar kijken en de
treinen zien vertrekken, 's avonds, en 's Zondags den geheelen dag,
vele malen.

Nu was de zon lager en rood, de gouden streep was weg. 't Was een
warme, stille avond. Het roode water rimpelde wat, de branding rolde
langzaam en ruischte maar zacht.

Bekker had een theorie, dat-i zou sparen en terugkomen en op de hei
gaan wonen. Maar hij geloofde er zelf niet aan in zijn hart. En wij
probeerden 't te gelooven, zelfs Hoyer probeerde 't en wij overtuigden
ons zelf dat 't zoo gaan zou, maar wij geloofden 't niet. En 't is
ook zoo niet gegaan. Na een jaar is Bekker teruggekomen. Hij had een
paar honderd gulden overgehouden en liep weer iederen morgen om half
negen in de Linnaeusstraat met z'n brood in een zeiltje. Een mensch
heeft veel noodig.

Maar dien avond dachten wij niet aan zeiltjes met brood. Wij deden erg
ons best om te gelooven, dat wij er nog heel wat van terecht zouden
brengen. Verbazen zouden wij de wereld, zoo kalm en onaanzienlijk
als wij daar zaten met opgetrokken beenen en onze acht handen om
onze knieën. Hoyer had zich voorgenomen allerlei gemeene dingen te
schilderen. In een tijdschrift had-i een artikel gelezen over de
sociale taak van den kunstenaar, hij was er nu achter. Hij begon een
dispuut met Bekker over de hei. Het was mirakel geleerd. Hij probeerde
Bekker te overtuigen, dat 't verkeerd was zich af te zonderen van
de wereld en naar die hei te gaan, waar-i toch nooit naar toe zou
gaan. Een kunstenaar behoort te staan midden in 't moderne leven.

Van mij wilde Hoyer weten hoe ik er over dacht. Ik zei maar, dat ik
er nooit over gedacht had. Ik begreep ook niet wat-i wilde, hij wist
't immers, waarom moest-i nu nog weten hoe ik er over dacht.

Alleen Bavink zei niets, hij zat met z'n kin op z'n knieën en ontving
de zon in z'n hart. De zon was nu zoo plat als een suikerboon en dof
rood, hij was bijna weg.

Hoyer kon er niet bij blijven zitten. Hij sprong op en nam Bekker
mee. Zij wandelden langs 't strand, in de verte hoorde we Hoyer
schreeuwen, blijkbaar wond-i zich op. Bavink en ik bleven nog even
zitten, toen drentelden wij zachtjes achter hen aan. 't Leek me niets
leuk een levensbeschouwing te hebben, Hoyer schreeuwde zoo.

Bavink en ik stonden stil en keken naar de punten van onze schoenen
en naar 't aanrollen van de verloopende golven. De zon was weg, de
roode schijn op 't water begon te verbleken, in 't zuiden klom een
blauwige duisternis. Er was een geur van modder. In de verte, bij
't dorp, gingen plotseling de booglampen aan bij 't strand.

"Begrijp jij dat," vroeg Bavink, "van die sociale taak?"

Ik haalde m'n schouders op. "Wat zou dat voor 'n vent zijn, die
dat artikel geschreven heeft? Heb jij verantwoordelijkheidsgevoel,
Koekebakker?" Daar had Hoyer 't ook over gehad.

"Hoyer praat machtig mooi," zei Bavink. "Machtig mooi. Ik heb geen
verantwoordelijkheidsgevoel. Ik kan me daar niet mee ophouden. Ik moet
schilderen. Een lolletje is 't niet. Wat zei-di ook weer?" "Wie?" vroeg
ik. "Die vent in dat boek, wat zei-di ook weer dat kunstenaars
waren?" "Gebenedijden, Bavink." "Weet je wat ik denk, Koekebakker? Dat
't dezelfde vent is, die de spoorboekjes gemaakt heeft. Daar heb ik
ook nooit iets van begrepen, hoe iemand dat kon. Gebenedijden... God
is overal? Of niet, Koekebakker? Dat zeggen ze toch?"

Ik knikte. De duisternis begon nu overal uit 't water te klimmen,
in 't noordwesten hield de kim nog wat gelige en groenige gloed,
boven onze hoofden trok 't laatste licht weg. Wolken waren er niet.

"Dus hij is overal," zei Bavink. "Daar en daar en daar." Met
uitgestrekte arm wees hij om ons heen. "En daar achter die zee, in
't land dat wij niet zien. En daar, bij Driehuis, waar de booglampen
staan. En in de Kalverstraat. Ga eens met je rug naar 't water staan
en luister. Kan jij eruit blijven?"

"Waaruit?"

"Uit die zee?" Ik knikte van ja, dat kon ik best.

"Ik nauwelijks," zei Bavink. "'t Is zoo raar dat weemoedige geluid
achter je. 't Is net of zoo'n zee wat van me wil. Daarin is God
ook, God roept. 't Is waarachtig geen lolletje, overal is-i. En
overal roept-i Bavink. Je wordt mal van je eigen naam, als-i zoo
dikwijls geroepen wordt. En dan moet Bavink schilderen. Dan moet
God op een brokkie linnen met verf. Dan roept Bavink "God." En
zoo blijven ze mekaar roepen. Voor God is 't een spelletje, die is
oneindig en overal. Hij roept maar. Maar Bavink heeft maar éen dom
hoofd en één domme rechterhand en kan maar aan één schilderijtje te
gelijk werken. En als-i denkt dat-i God heeft dan heeft-i linnen en
verf. Dan is God overal, behalve waar Bavink 'm hebben wil. En dan
komt er een vent en schrijft dat Bavink gebenedijd is. En Hoyer leert
dat uit z'n hoofd en loopt er over te zwetsen tegen Bekker. Zeg wel
gebenedijd. Weet je wat ik wou? Dat ik spoorwegboekjes kon maken. Zoo'n
vent laat God met vrede, die is 'm de moeite niet waard."

Ik presenteerde Bavink een sigaar en stelde voor naar Driehuis te
gaan. Ik had trek in koffie. Ik vond het niet mooi van Bavink een
verdienstelijk heer zoo te kleineeren. Achter ons aan kwamen Hoyer
en Bekker terug en hadden 't nog erg druk.

Om elf uur stonden we dien avond nog weer aan 't strand in de nacht. Er
was wat wind komen opzetten, de golven ruischten. Een weinig drank
had de weemoed en de somberheid verdreven. Een nieuwe tijd zou
aanbreken. Bekker zou in de eenzaamheid van zijn Duitsche kosthuis
Dante vertalen, zooals nog nooit iemand 't gedaan had. Bavink had een
groot doek in z'n hoofd, een gezicht op Rhenen, hij was daar eens een
dag geweest, duidelijk zag hij alles voor zich. En Hoyer ging werken
aan z'n sociale taak; ze zouden er van opkijken. En ik probeerde
't allemaal te gelooven.

De koele wind woei om ons heen. De zee ruischte klagend, de zee, die
klaagt en weet niet waarom. De zee spoelt verdrietig aan 't land. Mijn
gedachten zijn een zee, ze spoelen verdrietig aan hun grenzen.

Een nieuwe tijd zou aanbreken, nog konden wij groote dingen tot stand
brengen. Ik deed mijn best 't te gelooven, héél erg mijn best.




VIII.


In Rhenen stond ik in de schemering op de brug over den spoorweg
en keek naar 't Noorden. In de diepte lag de spoorlijn tot den
gezichtseinder, aan beide zijden er van rees de berg steil op, begroeid
met lichtgroen gras en donkergroene brem vol gele bloemen. Ik keek
er naar hoe de bergwanden geleidelijk lager werden, tot ze, heel ver,
overgingen in de vlakte.

Weer begon de duisternis geheimzinnig naar boven te kruipen uit de
aarde, zooals ik dat zoo dikwijls gezien had. Bevreesd en bangelijk lag
't laatste licht van den dag op den berg, de spleet was vol duisternis,
een rood licht was opgetrokken aan een paal aan de spoorlijn. De lucht
was wat grijs beslagen en keek kleurloos neer op den verslagen dag.

Zes jaar was ik weggeweest en nu stond ik daar, pas in Holland terug,
op de plaats waaraan ik zoo vaak had gedacht, waarover ze mij in bijna
iederen brief hadden geschreven. (Bavink schreef me ieder jaar zeker
wel twee keer en Bekker wat vaker), op den berg waarvan Bavink mij
in den loop van den tijd zeven teekeningetjes had gestuurd en waarop
Bekker twee heel kleine versjes had gemaakt.

Naar Holland was ik gekomen om armoe te lijden en artikeltjes en
verhaaltjes te schrijven in 't buurtje waar ik zoo lang gewoond had. En
mijn laatste twee rijksdaalders wilde ik verteren in de stad die in
mijn afwezigheid een korte poos de hoofdstad der wereld was geweest.

In 't Noorden verslond de duisternis 't licht mateloos, nu was de
berg weldra verzwolgen, 't laatste geleide van den dag vluchtte in
't Noordwesten overhaast en ik stond op 't bruggetje aan 't niet,
omspoeld door de oneindigheid.

Ik legde mijn elboog op de leuning en hield m'n kin met m'n hand
vast en keek in de duisternis en dacht aan de platte roode zon,
die, lang geleden, in de groene golven van den Atlantischen oceaan
was ondergegaan, de golven die opliepen met scherpe randen en holle
flanken en vielen en opliepen en nu nog oploopen en vallen. En aan
de gele lichten in de armelijke buurtwinkeltjes in Amsterdam, die
ik nu spoedig weer zou zien en die iederen avond hadden geschenen,
terwijl de oceaan golfde.

En de vage verwachtingen van vroeger stegen weer in mij op en het
verlangen, zonder te weten waarnaar.

Doch er kwam een gevoel bij, dat ik vroeger niet gekend had. Voorbij
waren al die dagen gegaan en voorbij zouden nog vele dagen gaan,
en al die dagen zouden mijn verwachtingen onvervuld blijven en mijn
verlangens onbevredigd. Jaren had Bavink met tusschenpoozen gewerkt
aan zijn gezicht op Rhenen, aan de rivier, den berg, den Cuneratoren,
de bloeiende appelboomen, de roode daken van 't stadje, de kastanjes
met hun witte en roode bloemen en de bruine beuken tusschen de huizen
in de hoogte, en 't molentje ergens op den berg. Jaren had Bekker in
't villaatje op den berg, dat Bavink gehuurd had, iederen Zondag
Dante vertaald en gedichtjes geschreven soms, jaren had ik over de
wereld gezworven. En wat was er nu nog gebeurd? Wat beteekende dat
alles voor de wereld, voor God, voor ons zelf?

Op den toren van Rhenen had ik gestaan en de verten gezien, en
mijn hart had naar de verte getrokken en naar de roode luchten in 't
westen. Doch al had ik van den toren kunnen vliegen naar de verten, dan
zou ik slechts gevonden hebben, dat de verte het nabije was geworden
en opnieuw zou mijn hart naar de verte getrokken hebben. En wat baat
mij de wijsheid, die mij leert dat 't niet anders kan en zoo blijven
zal in eeuwigheid?

Iederen dag hadden wij verlangd zonder te weten waarnaar. En eentonig
was 't geworden. Eentonig werd 't opgaan van de zon en 't ondergaan en
't schijnen van de zon in 't water en 't schuiven der witte wolken. En
ook de donkere luchten werden eentonig, en 't bruin en geel worden
van de bladen, en de bladerlooze kruinen en de armoedige drassige
weilanden in den winter, al die dingen die ik zoo vaak gezien had
en waaraan ik zoo vaak had gedacht in mijn afwezigheid en die ik zoo
vaak weer zou zien, als ik niet stierf. Wie kan z'n leven doorbrengen
met te kijken naar al deze dingen, die zich steeds herhalen, wie kan
blijven verlangen naar niets? Hopen op een God die er niet is?

En nu bloeiden weer de brem en de seringen en de appelboomen en de
kastanjes en de zon had al weer fel gebrand. En vol ontroering had
ik dit alles weergezien.

En terwijl ik daaraan dacht, weken de vage verwachtingen en verlangens.

God leeft in mijn hoofd. Zijn velden zijn er onmetelijk, zijn tuinen
staan er vol schoone bloemen, die niet sterven en statige vrouwen
wandelen er naakt, vele duizenden. En de zon gaat er op en onder en
schijnt laag en hoog en weer laag en 't eindelooze gebied is eindeloos
't zelfde en geen oogenblik gelijk. En breede rivieren stroomen er
door met vele bochten en de zon schijnt er in en ze voeren 't licht
naar de zee.

En aan de rivieren mijner gedachten zit ik stilletjes en genoeglijk
en rook een steenen pijpje en voel de zon op mijn lijf schijnen en zie
't water stroomen, voortdurend stroomen naar 't onbekende.

En 't onbekende deert mij niet. En ik knik maar eens tegen de
schoone vrouwen, die de bloemen plukken in mijn tuinen en hoor de
wind ruischen door de hooge dennen, door de wouden der zekerheid,
dat dit alles bestaat, omdat ik 't zoo verkies te denken. En ik ben
dankbaar dat mij dit gegeven is. En in ootmoed pijp ik nog eens aan
en voel mij God, de oneindigheid zelf.

Doelloos zit ik, Gods doel is de doelloosheid.



Maar voor geen mensch is het weggelegd dit bij voortduring te beseffen.




IX.


Toen ik den volgenden ochtend tegen negenen in Amsterdam aankwam en op
't plein voor 't Centraalstation stond, zag ik allerlei electrische
trammen die ik daar nog nooit gezien had en huurauto's en agenten van
politie met petten op inplaats van helmen. Maar 't Damrak hadden ze nog
niet gedempt, ik zag de achterkanten van de huizen van de Warmoesstraat
weer vlak aan 't water staan en den toren van de Oudekerk aan 't eind
er boven uit. Dat was dus nog in orde.

En daar liepen ook weer diezelfde nette heeren, wier haar altijd even
netjes zit, die nooit een kreukel in hun jas of een spatje modder
op hun schoenen hebben. En ze zagen er weer uit als of ze 't nog
altijd enorm goed wisten, en vonden dat ze vrijwel geslaagd waren in
't leven. En vriendelijk en beleefd waren ze weer tegen elkaar. Hun
kleeding was een kleinigheid anders dan een jaar of wat geleden, maar
nog even degelijk. En je kon zien dat zij nog altijd met alles in
't reine waren. Een jas was nog altijd een jas en een vest een vest,
en een fatsoenlijke vrouw een fatsoenlijke vrouw en een meid een
meid. Het kwam allemaal nog precies uit. Ook wisten ze nog precies
wie en wat beneden hun stand was; ik twijfelde er niet aan. En ook
't Rokin zou wel gedempt komen als ze er aan toe waren.

Met lijn twee reed ik over de Nieuwezijds Voorburgwal. Het was maar
goed dat ze die gedempt hadden lang geleden, anders had de tram daar
allicht niet kunnen rijden en je kon nu ook overal makkelijk van den
eenen kant naar den anderen oversteken.

Met lijn twee, de lijn bij uitnemendheid der nette en gewichtige
heeren. Een paar vreeselijk gewichtige heeren waren in de tram, niets
was ik daarbij. Vroolijk scheen het zonnetje op den Voorburgwal,
't groen der boompjes was nog wat licht en ik zag dat de schaduw van
de Nieuwe kerk den overkant der straat niet raakte, lang niet. En
ik herinnerde me, dat ik jaren geleden, ook in 't laatst van Mei
dezelfde schaduw precies zoo gezien had. En dat ik op een zonnigen
winterdag, toen over de Voorburgwal nog geen tram reed, door de
schaduw van die kerk geloopen had, die toen de heele breedte van de
straat bedekte. Nu raakte hij de rails niet, de tram reed in de zon
voorbij de kerk. En over enkele maanden zou dezelfde wagen (hij was
nog heel nieuw) op dezelfde plaats door die schaduw rijden. En toen
ik weer naar die twee vreeselijk gewichtige heeren keek vond ik,
dat al dien tijd dat Rhenen de hoofdstad der wereld geweest was,
er eigenlijk al heel weinig in die wereld veranderd was.

En ik dacht, wanneer die twee heeren dood zouden gaan en naakt zouden
aankomen voor de rechtbank des Heeren, en hier vergeten zouden zijn. En
dat er vreeselijk gewichtige heeren na hen zouden komen. En of ze hun
stomme aplomb zouden bewaren, als ze daar boven zouden aankomen zonder
hun gepoetste schoenen? En hoe 't gaan zou met die nette scheidingen
in hun haar? En of ze dan zouden uitkomen met hun stupide vertoon van
meerderheid, of er niet een kleinigheid op die gezichten te lezen zou
zijn, als ze daar die andere, nog gewichtiger heeren zouden ontmoeten,
die ze zooveel jaren hadden hooggeacht, ook naakt?

En hoeveel idealistische jongelingen in dien tijd opstellen geschreven
en gedichtjes en schilderijtjes gemaakt en zich opgewonden en gedweept
zouden hebben. En gezoend. En daarna ook gewichtig zouden zijn geworden
misschien, en ook vergeten.

Toen kwam er een meisje met een viool in de tram en keek met haar
zwarte oogjes naar de puntjes van haar schoentjes, en ik keek naar
de ronding van haar zomermanteltje en vergat die nette heeren.




X.


Hoyer vond ik thuis. Hij woonde heel netjes in een straatje van
den tweeden rang, achter 't Concertgebouw. Hij ontving me in een
zitkamer, waar ik niet durfde loopen, er lag zoo'n duur kleed. Zijn
gordijnen waren van pluche, z'n stoelen bekleed met geel moquette,
op den schoorsteen stond een zwarte pendule met candelabres en ik
meen dat ik ook nog ergens een bronzen paard heb gezien, allemaal
dingen uit dure bazars. Goed zitten durfde ik ook niet, ik zat al
dien tijd op de punt van een stoei, maar ik geloof niet, dat Hoyer
daar iets van gesnapt heeft.

Hoyer had kolossaal geboft. Ze hadden de ouwe stomme streek uitgehaald
een naaktfiguur van hem te weigeren. De Wellust had hij de dame
genoemd en ze was inderdaad, laat ik maar zeggen, omdat ik voor een
fatsoenlijk tijdschrift schrijf "heel lief." En nu woonde Hoyer heel
duur op gemeubileerde kamers, bij een nette weduwe met drie namen,
waar ook een vrouwelijke advocaat in huis was en een assistent-resident
met verlof, met vrouw en kind. En hij at buitenshuis, want de weduwe
was veel te net om voor eten te zorgen. Schoenen poetsen was extra.

En ik zat al dien tijd op de punt van mijn stoel en keek naar
de gedraaide poot van de tafel en naar de vergulde lijst van den
spiegel. Het was erg vervelend. Ik moest natuurlijk vertellen van
mijn reis, maar ik wist niet wat, ik hoorde mezelf praten en luisterde
als een daas naar mijn eigen geluid. Er was een naargeestig licht in
de kamer, ik denk dat de weduwe bang was voor inkijken. Ik wou dat
ik maar weg was en keek langs de drie muren, die ik zien kon zonder
al te veel te draaien, maar ze weken niet en ik kon er niet doorheen
zien. Ik keek naar de deur, ik kon er mijn oogen niet van afhouden,
hulpeloos zat ik daar te staren. De deur trok. Vage visioenen had ik
van de Cunera, van den hoek van den Grebbeberg met de rivier en van
't zonnige plein voor 't Centraalstation en de blinkende wijzerplaat
van de Oudekerk en daar doorheen zag ik de geschilderde vlammen van
't nagemaakte eikenhout van die deur. En onderwijl ging iemand door met
praten, o ja, dat was Hoyer. En nu antwoordde ik zelf, of eigenlijk ik
zelf niet, maar mijn tong bewoog toch en er kwam geluid uit m'n mond,
ik hoorde 't duidelijk.

Niets merkte Hoyer. Z'n atelier was boven. Of hij me maar even
voor mocht gaan. Wezenloos liep ik achter 'm aan "Dit is zeker
't privaat?" Ik dacht dat 't hoorde zoo iets te zeggen, als een
heer je z'n huis liet zien. Niets merkte Hoyer: "Nee, dat is een
kast" zeide-i. En ik dacht, waarom zegt-i niet: "Pardon, dat is een
kast." Dat zoud-i zeker later zeggen, over een jaar of zoo.

De gangetjes waren nauw, de loopertjes smal, de trapjes naar rato,
met dunne spijltjes, een beetje gedraaid, maar alles was netjes,
keurig netjes, dat moest ik zeggen. Nog merkte Hoyer niets.

Daar boven knapte ik wat op, daar was ten minste licht, 't bekende
licht van 't atelier. De ezel was leeg. Er stond een dure stoel,
een clubstoel waar ik in wegzakte, nog nooit had ik in zoo'n stoel
gezeten. Hoyer schilderde tegenwoordig portretten, dames en heeren,
allemaal netjes aangekleed. Hij liet me ook een pas begonnen portret
van de vrouwelijke advocaat zien. Zij was nu op reis. Eerst had
Hoyer z'n atelier buitenshuis gehad, maar de advocate had "mevrouw"
overgehaald toe te staan, dat een deel van de zolder voor atelier werd
vertimmerd. Dat overhalen had eenige moeite gekost en was pas gelukt,
toen de weduwe had gehoord, dat Hoyer het portret zou schilderen van
een juffrouw van den Willemsparkweg met winterhoed, boa en mof. En
de rest van haar kleeren natuurlijk. En dat hij voorgedragen was als
lid van "Arti".

Of Bavink wel eens hier kwam? Nooit, hij was er nog niet geweest. En
of hij nog wel eens iets van Kees had gehoord? Ja, Bavink had hem een
tijdje geleden op straat gesproken. Drie of vier betrekkingen had Kees
in een paar jaar versleten en daar tusschendoor was hij lange tijden
werkeloos geweest. Z'n vader had eindelijk een betrekkinkje voor
'm gevonden bij de gasfabriek.

"Hij loopt nu met een uniformpet op met drie kruisjes en G. G. boven
z'n voorhoofd en een boekje onder z'n arm. En een vent bij 'm met
een zwarte zak." Bavink had 't een heel gezicht gevonden. Hij moet
de halve stuivers uit de muntmeters halen en de andere vent moet die
dragen in dien zak. En als ze de halve stuivers uit de meter hebben
gehaald, dan moet Kees vragen of de juffrouw die halve stuivers weer
in wil wisselen. Hij klaagde dat-i zoo weinig verdiende. Bavink was
een eindje met 'm mee gegaan, hij had nog nooit naast zoo iemand
geloopen. Maar 't had hem gauw verveeld. Hij deed 't nooit weer.

Ik tuurde naar 't Bokharakleedje, dat voor den clubstoel lag en
zag heel duidelijk de verlaten keien van de Linnaeusstraat en den
hardsteenen trottoirband en de voeg, waar twee stukken daarvan tegen
elkaar gezet waren en de klinkertjes van 't trottoir. En ik zag ons
daar zitten in de zomernacht. Bavink en Bekker en Kees en Hoyer en
mijzelf. Ik zag dat de keien en 't stof nat waren, de sproeiwagen
was er over heen gegaan, ergens lag een nat stuk krant. En ik hoorde
Hoyer zeggen, dat-i opstond, want dat die blauwe steen zoo optrok. En
nu hoorde ik weer diezelfde stem, maar wat beschaafder, met wat meer
modulatie: "Je zult me excuseeren, Koekebakker, om elf uur heb ik
een conferentie."

Buiten scheen de lentezon in de troostelooze straat. Mijn God, hoe
kon zoo'n straat bestaan. 't Meisje in de tram had ik vast niet mogen
zoenen, maar zoo'n straat mocht bestaan. Dat mocht.




XI.


Op een van de grachten was 't. Ik stond op de stoep en las:
"P. Bekker, Agentuur en Commissiehandel." Ik schelde en wachtte. 't
Duurde nog al lang. Toen ging de bovenste helft van de deur open en
ik zag een jongmensch met een vierkant hoofd. "Is m'nheer Bekker op
kantoor?" Raar klonk dat. En terwijl 't jonge mensch met eenige moeite
de onderdeur open maakte, herinnerde ik me hoe vroeger de straatdeur
werd opengetrokken zonder dat je iemand zag en dat ik dan riep "Hallo
Bekker!" "Is mijnheer op kantoor?" Er was iemand bij mijnheer.

In den marmeren gang stond een groote rol loopergoed. "Wie kan ik
zeggen dat er is?" "Koekebakker." "Wilt u mij maar volgen?" 't Jonge
mensch ging mij voor, een smalle trap op, die ettelijke malen draaide.

Boven, aan 't eind van een nauwen donkeren gang stond hij stil. In
't schemerige licht kon ik nog net even 't woord "Monsterkamer"
lezen. "Moet ik hier zijn vriend?" vroeg ik en wees naar dat woord. Ik
zag dat de vriend mij een rare vond. "Dat staat er nog van vroeger,
mijnheer." Hij klopte.

Ik hoorde Bekkers stem die "Ja", riep. De vriend ging naar binnen,
de deur ging weer dicht en daar stond ik.

Of ik zoo goed wilde zijn hier even te wachten. Ik werd in een klein
achterkantoortje gelaten met een uitzicht op een blinden muur. Aan
den zolder hing een zware rol pakpapier aan een spil, een eind papier
hing naar beneden boven een groote, leege paktafel. 't Jongmensch
ging aan een lessenaartje zitten, dat tegen 't raam stond en begon te
tikken op een schrijfmachine met z'n rug naar me toe. Ik zag 't stuk
papier hangen, ik zag dat 't schuin was afgescheurd, ik keek op den
breeden bollen rug en de bonkige schouders van den kantoorbediende en
naar den blinden muur. Een van de baksteenen was kapot en van binnen
donkerrood; dat brok steen was 't mooiste dat ik zag.

De bediende tikte maar, God weet wat-i tikte. Als-i even ophield,
hoorde ik de stemmen van twee menschen door de gesloten deur,
ik herkende 't geluid van Bekker, maar de woorden verstond ik
niet. Twintig minuten zat ik daar te sterven. "Per me si va nella
città dolente."

Toen ging de deur open en Bekker verscheen. Hij was zenuwachtig
en verlegen. Hoe het mij ging. Ik zag er goed uit. Het speet hem
vreeselijk. Hij had een klant over uit Bordeaux. Die mijnheer was
speciaal overgekomen om met hem te spreken.  Hij geloofde niet, dat
hij hem voor vanavond laat kwijt zou raken... "Je begrijpt--kerel
wat zie je d'r toch goed uit. Kom je nu van Algiers?" Ik begreep
't volkomen. Ja, ik kwam van Algiers. "Waar logeer je, als 't kan,
kom ik vanavond om 9 uur bij je." Ik logeerde nergens, mijn geld
was op, maar dat kun je toch niet zeggen op een kantoor, waar een
vreemde bij is. Ik zei maar dat ik 't nog niet wist, ik kwam nog
wel eens aan. "Ik hoop dat je 't dan beter treft." Ik wist dat-i
dat zeggen zou. D'r zijn zoo van die gesprekken onder nette lui,
waarbij je heelemaal niet hoeft te luisteren.

Hij bracht me tot de straatdeur. Hij vond 't verdomd beroerd. Ik keek
naar 't bordje, "P. Bekker, Agentuur en commissiehandel" en toen naar
z'n oogen.

En toen zag ik dat ook hij plotseling weer die koe hoorde loeien,
die tien jaar geleden geloeid had in de schemering, de koe die je
hoorde en niet zag.

Wij gaven elkaar de hand. "Per me si va tra la perduta gente,
Koekebakker." Hij hield mijn hand nog vast en legde z'n andere hand
op m'n schouder. "Zeg eens, als je geld noodig hebt?"

Ik ging de stoep af, de klant stond voor 't raam met z'n handen in z'n
zijden, de beenen van elkaar en keek naar buiten. Rijk en welverzorgd
zag hij er uit. Ik nam eerbiedig mijn hoed voor 'm af en hij groette
terug, beleefd en minzaam.




XII.


Ik kom nu zoo gaandeweg tot 't einde. Goddank, zal hier of daar iemand
zeggen. Och, ik wist vooruit dat 't op niet veel zou uitloopen. Waar
loopt tegenwoordig 't leven van een Amsterdammer op uit? In mijn
jongenstijd heb ik vaak genoeg gewenscht, dat er nu eindelijk eens
iets zou gebeuren. Maar er gebeurde nooit iets. Zelfs verhuisd zijn
we nooit. En later....

Alleen Hoyer weet waar de boel op uitloopt. Hij heeft wat geërfd en zit
flink in de duiten. Hij is lid van de S. D. A. P. en leest "Het Volk".

's Avonds zit-i op 't Leesmuseum en leest 't Berliner
Tageblatt. Schilderen doet-i niet meer. Hij weet ook waarom hij niet
meer schildert: wij zijn in een tijd van verval. Een nieuwe kunst is
in opkomst. Daar wacht-i zeker op. Hij brengt ondertusschen Kunst aan
het Volk, hoe, dat weet ik niet. Een metselaar heeft hem eens gevraagd,
"wat-i voor die smoessies kocht." Ook daarvoor had Hoyer een verklaring
"Wij sociaal democraten weten maar al te goed----"

Hij zegt een boel dingen, die erg waar zijn en als je denkt, "nou wordt
't interessant", dan gaat-i niet verder. Op een middag in "Polen",
sprak-i heel veel over "proletarisch sentiment" en "burgerlijke
ideologieën." Ik luisterde maar naar 'm. Eén keer heb ik tegen 'm
gezegd: "'t Is toch mooi dat je alles zoo zeker weten kunt."

Hij ging daar direct op in en ik kon in een half uur niet meer aan 't
woord komen. En 't is inderdaad heel mooi voor iemand die zijn heele
leven lang te doen heeft wat een ander 'm commandeert, zonder dat-i er
zelf veel van snapt en voortdurend wordt gesnauwd en altijd margarine
moet eten en in de benauwde luchten wonen. Als ik maar een beetje
twijfelen mocht, dan zou ik ook wel lid van de S. D. A. P. worden. Eén
geluk: de menschen, die altijd in de benauwde luchten verkeeren,
hebben me niet noodig. En misschien zou 't zonder Hoyer ook nog wel
gaan. 'k Zal toch eens informeeren of 't mag, dat twijfelen.

Met den agentuur en commissiehandel is 't slecht gegaan. Die
commissiehandel was heelemaal larie, dat had Bekker er maar bij laten
zetten omdat 't goed stond. En iemand die Dante vertaald heeft en
gedichtjes gemaakt, al zijn 't er maar dertien, die moet geen agent
van binnen- en buitenlandsche huizen worden. Op een regenachtigen
Decemberdag, toen de lantaarns op de gracht werden opgestoken, vond
ik Bekker scheef aan z'n lessenaar zitten met z'n hand onder z'n
hoofd. De kamer was half donker. Hij bewoog niet. Ik stak 't gas op. De
prullemand stond achter 'm en daarin lag al z'n post van drie dagen,
ongeopend. Met z'n elleboog hat-i de heele rommel erin geschoven,
opzettelijk, zonder er naar te kijken. Z'n bediende hat-i maanden
geleden gedaan gegeven, de telefoon hadden ze weggenomen. Daar
zat-i. Aan de muur hing een lijst met afvaarten van stoombooten,
waarvan de laatste al weer lang was binnengekomen en na dien tijd weer
uitgevaren, herhaalde malen. En op den schoorsteen stond een dik boek,
een prachtuitgave van de Divina Commedia.

Buiten stonden de lantaarns te branden, bleek en vreemd in 't laatste
daglicht, als een wonderlijke vergissing, zooals ze zoo dikwijls
gestaan hadden. Een wonderlijke vergissing leek alles.

Nu zit Bekker weer ergens op een kantoortje. Hij heeft een goeie baas,
die hem respecteert, omdat hij Dante vertaald heeft. Op mooie dagen
stuurt-i Bekker 's middags weg, dan mag-i een beetje in 't zonnetje
wandelen.

Aan den drank is Bekker niet gegaan. Hij lost schaakproblemen op of
slaapt. Een voorstelling van de toekomst heeft-i niet. Hij verlangt
zelfs niet naar zes uur. Dat geeft toch niets. Z'n tractement beurt-i
met een weemoedig welbehagen, met weemoedig welbehagen koopt-i er
dassen en schoenen voor. Z'n kleeren zijn netjes geborsteld. Bij
tijden is hij een weinig ingenomen met zichzelf, om dat-i vroeger
"een geestelijk leven geleid heeft."

Hij ziet nog weleens een schilderijtje. Onlangs kwam ik hem nog
eens tegen. Toen had-i 't over de intocht van de koningin, dat
schilderijtje van Eerelman, waar 't woord "Odol" zoo natuurlijk op
geschilderd staat. Hij vroeg of 't niet een mooi schilderij was om
in een deftige apotheek op te hangen.

Kees loopt nog altijd voor de gasfabriek en verkeert in de benauwde
luchten, waar ik 't zoo even ook over gehad heb. Hij weet niet waar
't volgende kind zal moeten slapen. De kinderen zijn nu nog klein,
maar over een jaar of wat kibbelen ze 's morgens bij die ééne kraan
en dat ééne privaat, zooals dat altijd in district III gegaan is. Hij
tobt met wat Hoyer noemt: "'t Chronische tekort in 't huishouden van
den werkman," en koopt alleen 's Zaterdagsavonds sigaren. 's Zondags
moet-i de kinderen verbieden. Hij moppert dat-i 't zooveel beter had
kunnen hebben, als-i eerder naar z'n vader geluisterd had.

Z'n vrouw is goed voor 'm. Midden in de week heeft-i een schoone
zakdoek. Maar ze zal de lusten niet opwekken van iemand, die niet
aan haar gewend is, zooals Kees. Zes jaar geleden was dat anders.

En op zolder bij z'n vader, waar vroeger z'n hok was, daar hangen nu
de onderlijfjes van z'n zusters te droogen.




XIII.


En Bavink?

Bavink heeft 't tegen die "Godverdomde dingen" afgelegd. Die dingen die
geschilderd wilden wezen en als je dan dacht: "dan moet 't ook maar
gebeuren," dan wilden ze weer niet. Hij begon wat opgang te maken,
toen de strijd al op 't eind liep.

Twee maanden na mijn terugkomst kwam-i me heel kalm vertellen,
dat-i zijn gezicht op Rhenen in stukken had gesneden. En zoo was
't. De rivier, den berg, den Cuneratoren, de bloeiende appelboomen, de
roode daken van Rhenen, de kastanjes met hun witte en roode bloemen,
de bruine beuken en 't molentje ergens in de hoogte, 64 gelijke,
rechthoekige brokken van 15 bij 12-1/2 centimeter hat-i er van
gesneden, met een bot knipmes. Een heel werk was 't geweest.

't Ding had 'm geërgerd. 't Was niks, totaal niks, vodden. Hij wou van
mij weten, waarom iemand schilderde. Hij begreep zelf niets meer. Hij
stak z'n arm uit en wees in de ruimte. Dààr waren de dingen. Hij sloeg
met z'n vuist tegen z'n voorhoofd. En daar waren ze. Er uit wilden ze,
maar ze deden 't niet. Stapelgek werd je ervan.

Bijna een jaar daarna vond ik hem aan 't Centraalstation aan de
Parijzer trein van 8 uur. Hij bracht een of anderen kennis weg, een
haarboer met lange zwarte lokken en heel veel baard, meer haar dan
mensch, en een hoog voorhoofd met niets er achter. De ondergaande zon
stond te schijnen, groot en rood, aan 't eind van de kap stond-i,
er was een rossig schijnsel in de ruiten en 't vernis van de
spoorwagens. Bavink was dronken. De trein vertrok, schoof onder de
kap vandaan en boog even om naar links. Bij 't ombuigen flikkerde
't licht fel op de wagens.

Wij wandelden naar 't eind van 't perron. Een man met een seinlicht
kwamen wij tegen, ik zag, dat hij in 't voorbijloopen naar een
conducteur keek, die daar stond bij een anderen trein en een beweging
maakte van drinken met de hand aan den mond.

Wij stonden stil buiten de kap en keken naar de zon. "Zie je die
zon, Koekebakker?" De zon was bijzonder duidelijk, hij stond recht
voor ons uit en dicht bij, zoo groot en zoo rood was-i nog nooit
geweest. Hij raakte bijna de rails van den spoorweg, hij maakte geen
flikkeringen meer op de dingen, en alleen in de matglazen ruiten van
den locomotievenstal, rechts van den spoorweg, was een dof schijnsel.

"Je denkt dat ik dronken ben?" Dat dacht ik inderdaad. "Het maakt
geen verschil, Koekebakker, als ik nuchter ben, begrijp ik er toch
ook niks van."

"Begrijp jij wat die zon van mij wil? Vier en dertig ondergaande
zonnen heb ik tegen de muur staan, achter elkaar, omgekeerd. En toch
staat-i daar weer iederen avond."

"Als er geen wolken zijn," zei ik. Maar hij liet zich niet afleiden.

"Koekebakker jij bent altijd mijn beste vrind geweest. Ik ken jou
al--hoe lang al?"

"Omtrent dertien jaar Bavink." "Dertien jaar. Dat is lang. Weet je
wat jij doen moet? Doe me een lol. Heb je een hoedendoos?"

Ik zweeg.

"Doe 'm in een hoedendoos, Koekebakker. In een hoedendoos. Ik wil
met vrede gelaten worden. Doe 'm in een hoedendoos, in een ordinaire
hoedendoos. Hij verdient niet beter."

Bavink griende dronkemanstranen. Ik keek hulpeloos rond. Een heer in
een uniformjas en met gele biezen om z'n pet kwam op ons af en sprak
mij aan.

"Ik geloof mijnheer, dat u beter doet, als u dezen heer naar huis
brengt."

Ik salueerde en gaf Bavink een arm. Hij ging gewillig mee. In de
huurauto viel-i in slaap. Op de Nieuwe Zijds-Voorburgwal werd-i even
wakker toen wij door een kuil reden en wilde weer over die hoedendoos
beginnen. Maar meteen viel-i weer in slaap.

Op een morgen zat-i wezenloos te staren voor z'n laatste
zonsondergang. Ik kwam op z'n hok met Hoyer. Hij herkende ons
niet. Hij keek maar naar die zon, een groote, koude, roode zon,
die in wolken onderging.

"Hij kijkt me maar aan, wij begrijpen geen van beiden wat we van
elkaar moeten." Verder kwam-i niet.

Hij is nu in een gesticht voor zenuwpatienten. Hij is heel rustig. Hij
kijkt maar naar boven, naar de lucht of tuurt naar den horizon of
zit in de zon te staren tot z'n oogen pijn doen. Dat mag-i niet,
maar ze kunnen niets met 'm beginnen. Aan 't praten kunnen ze 'm niet
krijgen. Z'n schilderijen doen tegenwoordig aardige prijzen.

En Koekebakkertje is een wijs en bedaard man geworden. Hij schrijft
maar, ontvangt z'n schamel loon en geeft geen ergernis.

Gods troon is nog ongeschokt. Zijn wereld gaat haar gang maar. Af
en toe glimlacht God even om de gewichtige heeren, die denken dat
ze heel wat beteekenen. Nieuwe Titaantjes zijn al weer bezig kleine
rotsblokjes op te stapelen om 'm van z'n verhevenheid te storten en dan
de wereld eens naar hun zin in te richten. Hij lacht maar en denkt:
"Goed zoo jongens, zoo mal als je bent, ben je me toch liever dan
die mooie wijze heeren. 't Spijt me dat je je nek moet breken en dat
ik die heeren moet laten gedijen, maar ik ben ook God maar." En zoo
gaat alles z'n gangetje en wee hem die vraagt: Waarom?






EEN WOORD NA.


Voor hen die gaarne weten hoe het met de liefde gesteld is, wil ik
nog mededeelen, dat Dichtertje's Dora ontstaan is uit de idealisatie
van een jong meisje, waarvoor ik uit de verte de genegenheid van een
oud man voelde.

Toen zij het manuscript gelezen had, vertelde ik haar dat, en haar
antwoord was: "Ik heb toch nooit diabolo gespeeld." Ze zei dit niet
uit coquetterie of uit verlegenheid, ze had er niets van begrepen.


                                                             NESCIO.

5 Jan. 1918.
EOT;
}
                                                                                                                                                                                                                                                                                             <?php

namespace Faker\Provider\nl_NL;

class Address extends \Faker\Provider\Address
{
    protected static $buildingNumber = array('%', '%#', '%##', '%###', '%-?', '%#-?', '%?', '%#?', '%-#', '%#-##');

    protected static $postcodes = array(
        '1013PT', '1015GZ', '1053GS', '1058EG', '1060PM', '1068NE', '1072NL', '1073SK', '1074JA', '1078NH', '1111LW',
        '1121JC', '1141RP', '1141VM', '1161TC', '1183CH', '1187RK', '1188LP', '1271KZ', '1312SG', '1323CW', '1325EZ',
        '1333EJ', '1334DP', '1339VJ', '1351AC', '1352AC', '1354LM', '1356AC', '1391RX', '1406MZ', '1411JM', '1435GS',
        '1443CK', '1444TM', '1448VB', '1505WL', '1509GP', '1531CZ', '1531KA', '1561ZV', '1602EP', '1606BS', '1619KB',
        '1674PG', '1689BJ', '1702LB', '1761GN', '1775BR', '1782SK', '1788WE', '1862BK', '1901CT', '1911CH', '1949AN',
        '1951MS', '1962PL', '1972DA', '2015HA', '2022RM', '2171XJ', '2231BB', '2231DG', '2231NZ', '2242PK', '2245VZ',
        '2261BH', '2262EA', '2264BK', '2264TS', '2266AA', '2274GD', '2316XD', '2332KV', '2333CW', '2403CG', '2512VH',
        '2516XJ', '2518ER', '2521SZ', '2531BH', '2544KR', '2562VH', '2564CJ', '2595BK', '2597PL', '2613DC', '2622DX',
        '2623HS', '2631VK', '2671LD', '2675EE', '2685VZ', '2771JD', '2801JS', '2802ED', '2803ZN', '2841AK', '2903XH',
        '2905PN', '2908KA', '2922AG', '2935RD', '2951JC', '3015XB', '3021WL', '3026RC', '3034VE', '3035CE', '3044AB',
        '3054XL', '3055AK', '3068DL', '3069HH', '3073DW', '3075AH', '3132CS', '3135EX', '3143KB', '3145CN', '3202AN',
        '3208LB', '3209BE', '3222CK', '3223VD', '3232TN', '3235NS', '3241BG', '3247CN', '3252CJ', '3255SC', '3274LD',
        '3312CV', '3317HR', '3319BN', '3319RG', '3351RJ', '3411AK', '3439LB', '3511PL', '3513GS', '3514CR', '3515GC',
        '3527EJ', '3551GH', '3572KA', '3573AL', '3608VJ', '3628AC', '3704MK', '3731EP', '3739JJ', '3741ZC', '3771RK',
        '3824HR', '3843BB', '3871GE', '3882CG', '3892BA', '3904NB', '3981KE', '3985SG', '4011KH', '4021EB', '4103XV',
        '4131NE', '4142WE', '4201BS', '4209SE', '4261ZC', '4283HA', '4307LC', '4334HG', '4337VE', '4371EN', '4382JC',
        '4382NC', '4385AS', '4401CA', '4401CG', '4521BW', '4553NG', '4581CA', '4614BD', '4614GX', '4698BG', '4702HJ',
        '4703LB', '4706CN', '4707WJ', '4735AS', '4793CM', '4797HE', '4811SH', '4814NJ', '4815CJ', '4835GG', '4871DD',
        '4921PK', '5011HS', '5013BE', '5061NA', '5103KD', '5105AC', '5111XN', '5126NT', '5126WR', '5151LR', '5151RZ',
        '5152VB', '5171GH', '5223BK', '5231PS', '5268GE', '5298AL', '5301HE', '5403NJ', '5469AT', '5481NC', '5482XE',
        '5575CS', '5611LP', '5644KR', '5645KR', '5651LX', '5654AX', '5684CP', '5712BR', '5751LD', '5753RJ', '5754GE',
        '5912SP', '6019CW', '6021BT', '6021KJ', '6049BL', '6085EX', '6097DG', '6097ZH', '6118BW', '6163KG', '6164GP',
        '6165XE', '6222BT', '6222VD', '6222VJ', '6226WC', '6365BJ', '6411ND', '6415BX', '6417BV', '6461JD', '6524SR',
        '6534XT', '6538CX', '6538RV', '6541AD', '6581BZ', '6584AM', '6605DP', '6621KN', '6651KG', '6655AE', '6671DV',
        '6673DB', '6716ND', '6741BR', '6822JL', '6823JD', '6871ZM', '6905SG', '6915TT', '6922EG', '6942LX', '6952ET',
        '6961XV', '6971GW', '7009CN', '7011JD', '7051JB', '7121LZ', '7136LH', '7261CN', '7273PP', '7311AL', '7312DG',
        '7314BK', '7315CW', '7323KB', '7361TD', '7391CZ', '7391SG', '7411VR', '7425EB', '7441GB', '7442CW', '7442GX',
        '7481DX', '7481SL', '7544XD', '7557VC', '7558GR', '7574PG', '7606XL', '7607RE', '7615RD', '7622VX', '7627SE',
        '7642EN', '7645AL', '7678RM', '7681ZA', '7707RL', '7722LG', '7722XJ', '7761AJ', '7825VC', '7833JJ', '7906NK',
        '7942JG', '7957DD', '7981BC', '8061BA', '8075AT', '8121HA', '8121SB', '8141HR', '8152BA', '8171JC', '8181VZ',
        '8226HJ', '8231DH', '8231JL', '8252HG', '8262EA', '8265GX', '8302AR', '8321KC', '8322EH', '8421PG', '8431MC',
        '8446CM', '8472DA', '8502CA', '8521DE', '8573WP', '8602XV', '8605AV', '8606XZ', '8701EG', '8701ZE', '8711EJ',
        '8802VB', '8861KZ', '8862AC', '8933EK', '9057LC', '9061AS', '9073LK', '9164LC', '9201TM', '9203PZ', '9269SV',
        '9269SZ', '9289ZH', '9354VD', '9401MA', '9406BM', '9431GV', '9501AM', '9502CX', '9642EA', '9651AR', '9675LR',
        '9712LJ', '9742GT', '9745EH', '9751TA', '9751TS', '9752BK', '9752GE', '9801TA', '9901EH', '9991EG', '9999XK',
    );

    protected static $streetNameFormats = array('{{lastName}}{{streetSuffix}}');

    protected static $streetAddressFormats = array('{{streetName}} {{buildingNumber}}');

    protected static $cityFormats = array('{{cityName}}');

    protected static $addressFormats = array(
        "{{streetAddress}}\n{{postcode}} {{city}}",
    );

    protected static $streetSuffix = array(
        'baan', 'boulevard', 'dreef', 'hof', 'laan', 'pad', 'ring', 'singel', 'steeg', 'straat', 'weg',
    );

    /**
    * Export of BAG (http://bag.vrom.nl/)
    * last updated 2012/11/09
    *
    * @var array
    */
    protected static $cityNames = array(
        "'s Gravenmoer", "'s-Graveland", "'s-Gravendeel", "'s-Gravenhage", "'s-Gravenpolder", "'s-Gravenzande", "'s-Heer Abtskerke", "'s-Heer Arendskerke", "'s-Heer Hendrikskinderen", "'s-Heerenberg", "'s-Heerenbroek", "'s-Heerenhoek", "'s-Hertogenbosch", "'t Goy", "'t Haantje", "'t Harde", "'t Loo Oldebroek", "'t Veld", "'t Waar", "'t Zand", "'t Zandt", '2e Valthermond',
        'Aadorp', 'Aagtekerke', 'Aalden', 'Aalsmeer', 'Aalsmeerderbrug', 'Aalst', 'Aalsum', 'Aalten', 'Aardenburg', 'Aarlanderveen', 'Aarle-Rixtel', 'Aartswoud', 'Abbega', 'Abbekerk', 'Abbenbroek', 'Abbenes', 'Abcoude', 'Achlum', 'Achterveld', 'Achterveld', 'Achthuizen', 'Achtmaal', 'Acquoy', 'Adorp', 'Aduard', 'Aerdenhout', 'Aerdt', 'Afferden L', 'Afferden', 'Agelo', 'Akersloot', 'Akkrum', 'Akmarijp', 'Albergen', 'Alblasserdam', 'Alde Leie', 'Aldeboarn', 'Aldtsjerk', 'Alem', 'Alkmaar', 'Allingawier', 'Almelo', 'Almen', 'Almere', 'Almkerk', 'Alphen aan den Rijn', 'Alphen', 'Alphen', 'Alteveer gem Hoogeveen', 'Alteveer', 'Alteveer', 'Alteveer', 'Altforst', 'Ambt Delden', 'Ameide', 'Amen', 'America', 'Amerongen', 'Amersfoort', 'Ammerstol', 'Ammerzoden', 'Amstelhoek', 'Amstelveen', 'Amstenrade', 'Amsterdam Zuidoost', 'Amsterdam', 'Andel', 'Andelst', 'Anderen', 'Andijk', 'Ane', 'Anerveen', 'Anevelde', 'Angeren', 'Angerlo', 'Anjum', 'Ankeveen', 'Anloo', 'Anna Paulowna', 'Annen', 'Annerveenschekanaal', 'Ansen', 'Ansen', 'Apeldoorn', 'Apeldoorn', 'Appelscha', 'Appeltern', 'Appingedam', 'Arcen', 'Arkel', 'Arnemuiden', 'Arnhem', 'Arum', 'Asch', 'Asperen', 'Assen', 'Assendelft', 'Asten', 'Augsbuurt', 'Augustinusga', 'Austerlitz', 'Avenhorn', 'Axel', 'Azewijn',
        'Baaiduinen', 'Baaium', 'Baak', 'Baambrugge', 'Baard', 'Baarland', 'Baarle-Nassau', 'Baarlo', 'Baarlo', 'Baarn', 'Baars', 'Babberich', 'Babyloniënbroek', 'Bad Nieuweschans', 'Badhoevedorp', 'Baexem', 'Baflo', 'Bakel', 'Bakhuizen', 'Bakkeveen', 'Balgoij', 'Balinge', 'Balk', 'Balkbrug', 'Balloo', 'Balloërveld', 'Ballum', 'Baneheide', 'Banholt', 'Bant', 'Bantega', 'Barchem', 'Barendrecht', 'Barger-Compascuum', 'Barneveld', 'Barsingerhorn', 'Basse', 'Batenburg', 'Bathmen', 'Bavel AC', 'Bavel', 'Bears', 'Bedum', 'Beegden', 'Beek en Donk', 'Beek', 'Beek', 'Beek', 'Beekbergen', 'Beemte Broekland', 'Beers NB', 'Beerta', 'Beerze', 'Beerzerveld', 'Beesd', 'Beesel', 'Beets', 'Beetsterzwaag', 'Beilen', 'Beinsdorp', 'Belfeld', 'Bellingwolde', 'Belt-Schutsloot', 'Beltrum', 'Bemelen', 'Bemmel', 'Beneden-Leeuwen', 'Bennebroek', 'Bennekom', 'Benneveld', 'Benningbroek', 'Benschop', 'Bentelo', 'Benthuizen', 'Bentveld', 'Berg en Dal', 'Berg en Dal', 'Berg en Terblijt', 'Bergambacht', 'Bergeijk', 'Bergen (NH)', 'Bergen L', 'Bergen aan Zee', 'Bergen op Zoom', 'Bergentheim', 'Bergharen', 'Berghem', 'Bergschenhoek', 'Beringe', 'Berkel en Rodenrijs', 'Berkel-Enschot', 'Berkenwoude', 'Berkhout', 'Berlicum', 'Berltsum', 'Bern', 'Best', 'Beugen', 'Beuningen Gld', 'Beuningen', 'Beusichem', 'Beutenaken', 'Beverwijk', 'Biddinghuizen', 'Bierum', 'Biervliet', 'Biervliet', 'Biest-Houtakker', 'Biezenmortel', 'Biggekerke', 'Bilthoven', 'Bingelrade', 'Bitgum', 'Bitgummole', 'Bladel', 'Blankenham', 'Blaricum', 'Blauwestad', 'Blauwhuis', 'Bleiswijk', 'Blesdijke', 'Bleskensgraaf ca', 'Blessum', 'Blije', 'Blijham', 'Blitterswijck', 'Bloemendaal', 'Blokker', 'Blokzijl', 'Boazum', 'Bocholtz', 'Bodegraven', 'Boekel', 'Boelenslaan', 'Boer', 'Boerakker', 'Boerakker', 'Boesingheliede', 'Boijl', 'Boksum', 'Bolsward', 'Bontebok', 'Boornbergum', 'Boornzwaag', 'Borculo', 'Borger', 'Borgercompagnie', 'Borgercompagnie', 'Borgsweer', 'Born', 'Borne', 'Bornerbroek', 'Bornwird', 'Borssele', 'Bosch en Duin', 'Boschoord', 'Boskoop', 'Bosschenhoofd', 'Botlek Rotterdam', 'Bourtange', 'Boven-Leeuwen', 'Bovenkarspel', 'Bovensmilde', 'Boxmeer', 'Boxtel', 'Braamt', 'Brakel', 'Brandwijk', 'Brantgum', 'Breda', 'Bredevoort', 'Breedenbroek', 'Breezand', 'Breezanddijk', 'Breskens', 'Breukelen', 'Breukeleveen', 'Brielle', 'Briltil', 'Britsum', 'Britswert', 'Broek in Waterland', 'Broek op Langedijk', 'Broek', 'Broekhuizen', 'Broekhuizen', 'Broekhuizenvorst', 'Broekland', 'Bronkhorst', 'Bronneger', 'Bronnegerveen', 'Brouwershaven', 'Bruchem', 'Brucht', 'Bruchterveld', 'Bruinehaar', 'Bruinisse', 'Brummen', 'Brunssum', 'Bruntinge', 'Buchten', 'Budel', 'Budel-Dorplein', 'Budel-Schoot', 'Buggenum', 'Buinen', 'Buinerveen', 'Buitenkaag', 'Buitenpost', 'Bunde', 'Bunne', 'Bunnik', 'Bunschoten-Spakenburg', 'Burdaard', 'Buren', 'Buren', 'Burgerbrug', 'Burgerveen', 'Burgh-Haamstede', 'Burgum', 'Burgwerd', 'Burum', 'Bussum', 'Buurmalsen', 'Buurmalsen',
        'Cadier en Keer', 'Cadzand', 'Callantsoog', 'Capelle aan den IJssel', 'Castelre', 'Castenray', 'Casteren', 'Castricum', 'Chaam', 'Clinge', 'Coevorden', 'Colijnsplaat', 'Collendoorn', 'Colmschate', 'Cornwerd', 'Cothen', 'Creil', 'Cromvoirt', 'Cruquius', 'Cuijk', 'Culemborg',
        'Daarle', 'Daarlerveen', 'Dalem', 'Dalen', 'Dalerpeel', 'Dalerveen', 'Dalfsen', 'Dalmsholte', 'Darp', 'De Bilt', 'De Blesse', 'De Bult', 'De Cocksdorp', 'De Falom', 'De Glind', 'De Goorn', 'De Groeve', 'De Heen', 'De Heurne', 'De Hoeve', 'De Kiel', 'De Klomp', 'De Knipe', 'De Koog', 'De Krim', 'De Kwakel', 'De Lier', 'De Meern', 'De Moer', 'De Mortel', 'De Pol', 'De Punt', 'De Rijp', 'De Rips', 'De Schiphorst', 'De Steeg', 'De Tike', 'De Veenhoop', 'De Waal', 'De Weere', 'De Westereen', 'De Wilgen', 'De Wilp', 'De Zilk', 'Dearsum', 'Dedemsvaart', 'Dedgum', 'Deelen', 'Deest', 'Deil', 'Deinum', 'Delden', 'Delfgauw', 'Delfstrahuizen', 'Delft', 'Delfzijl', 'Delwijnen', 'Demen', 'Den Andel', 'Den Bommel', 'Den Burg', 'Den Dolder', 'Den Dungen', 'Den Ham', 'Den Ham', 'Den Helder', 'Den Hoorn', 'Den Hoorn', 'Den Horn', 'Den Hout', 'Den Ilp', 'Den Oever', 'Den Velde', 'Denekamp', 'Deurne', 'Deurningen', 'Deurningen', 'Deursen-Dennenburg', 'Deurze', 'Deventer', 'Didam', 'Dieden', 'Diemen', 'Diepenheim', 'Diepenveen', 'Dieren', 'Diessen', 'Diever', 'Dieverbrug', 'Diffelen', 'Dijken', 'Dinteloord', 'Dinxperlo', 'Diphoorn', 'Dirkshorn', 'Dirksland', 'Dodewaard', 'Doenrade', 'Doesburg', 'Doetinchem', 'Doeveren', 'Doezum', 'Dokkum', 'Doldersum', 'Domburg', 'Donderen', 'Dongen', 'Dongjum', 'Doniaga', 'Donkerbroek', 'Doorn', 'Doornenburg', 'Doornspijk', 'Doorwerth', 'Dordrecht', 'Dorst', 'Drachten', 'Drachten-Azeven', 'Drachtstercompagnie', 'Dreischor', 'Drempt', 'Dreumel', 'Driebergen-Rijsenburg', 'Drieborg', 'Driebruggen', 'Driehuis NH', 'Driehuizen', 'Driel', 'Driewegen', 'Driezum', 'Drijber', 'Drimmelen', 'Drogeham', 'Drogteropslagen', 'Drongelen', 'Dronryp', 'Dronten', 'Drouwen', 'Drouwenermond', 'Drouwenerveen', 'Drunen', 'Druten', 'Duiven', 'Duivendrecht', 'Duizel', 'Dussen', 'Dwingeloo',
        'Eagum', 'Easterein', 'Easterlittens', 'Eastermar', 'Easterwierrum', 'Echt', 'Echteld', 'Echten', 'Echten', 'Echtenerbrug', 'Eck en Wiel', 'Eckelrade', 'Edam', 'Ede', 'Ederveen', 'Ee', 'Eede', 'Eefde', 'Eelde', 'Eelderwolde', 'Eemdijk', 'Eemnes', 'Eemshaven', 'Een', 'Een-West', 'Eenrum', 'Eenum', 'Eerbeek', 'Eersel', 'Ees', 'Eesergroen', 'Eeserveen', 'Eesterga', 'Eesveen', 'Eethen', 'Eext', 'Eexterveen', 'Eexterveenschekanaal', 'Eexterzandvoort', 'Egchel', 'Egmond aan Zee', 'Egmond aan den Hoef', 'Egmond-Binnen', 'Eibergen', 'Eijsden', 'Eindhoven', 'Einighausen', 'Ekehaar', 'Elahuizen', 'Elburg', 'Eldersloo', 'Eleveld', 'Elim', 'Elkenrade', 'Ell', 'Ellecom', 'Ellemeet', 'Ellertshaar', 'Ellewoutsdijk', 'Elp', 'Elsendorp', 'Elshout', 'Elsloo', 'Elsloo', 'Elspeet', 'Elst Ut', 'Elst', 'Emmeloord', 'Emmen', 'Emmer-Compascuum', 'Empe', 'Emst', 'Engwierum', 'Enkhuizen', 'Ens', 'Enschede', 'Enspijk', 'Enter', 'Enumatil', 'Epe', 'Epen', 'Eppenhuizen', 'Epse', 'Erica', 'Erichem', 'Erlecom', 'Erm', 'Ermelo', 'Erp', 'Esbeek', 'Esch', 'Escharen', 'Espel', 'Est', 'Etten', 'Etten-Leur', 'Europoort Rotterdam', 'Eursinge', 'Eursinge', 'Everdingen', 'Evertsoord', 'Ewijk', 'Exloo', 'Exloërveen', 'Exmorra', 'Eygelshoven', 'Eys', 'Ezinge',
        'Farmsum', 'Feanwâlden', 'Feerwerd', 'Feinsum', 'Ferwert', 'Ferwoude', 'Fijnaart', 'Finsterwolde', 'Firdgum', 'Fleringen', 'Fluitenberg', 'Fochteloo', 'Follega', 'Folsgare', 'Formerum', 'Foudgum', 'Foxhol', 'Foxwolde', 'Franeker', 'Frederiksoord', 'Friens', 'Frieschepalen', 'Froombosch',
        'Gaanderen', 'Gaast', 'Gaastmeer', 'Galder', 'Gameren', 'Gapinge', 'Garderen', 'Garmerwolde', 'Garminge', 'Garnwerd', 'Garrelsweer', 'Garsthuizen', 'Garyp', 'Gassel', 'Gasselte', 'Gasselternijveen', 'Gasselternijveenschemond', 'Gastel', 'Gasteren', 'Gauw', 'Geelbroek', 'Geerdijk', 'Geersdijk', 'Geertruidenberg', 'Geervliet', 'Gees', 'Geesbrug', 'Geesteren', 'Geesteren', 'Geeuwenbrug', 'Geffen', 'Geijsteren', 'Geldermalsen', 'Gelderswoude', 'Geldrop', 'Geleen', 'Gellicum', 'Gelselaar', 'Gemert', 'Gemonde', 'Genderen', 'Gendringen', 'Gendt', 'Genemuiden', 'Gennep', 'Gerkesklooster', 'Gersloot', 'Geulle', 'Giesbeek', 'Giessen', 'Giessenburg', 'Gieten', 'Gieterveen', 'Giethmen', 'Giethoorn', 'Gilze', 'Ginnum', 'Glane', 'Glimmen', 'Godlinze', 'Goedereede', 'Goes', 'Goingarijp', 'Goirle', 'Goor', 'Gorinchem', 'Gorredijk', 'Gorssel', 'Gouda', 'Gouderak', 'Goudriaan', 'Goudswaard', 'Goutum', 'Goënga', 'Goëngahuizen', 'Graauw', 'Grafhorst', 'Graft', 'Gramsbergen', 'Grashoek', 'Grathem', 'Grave', 'Greonterp', 'Grevenbicht', 'Griendtsveen', 'Grijpskerk', 'Grijpskerke', 'Groede', 'Groenekan', 'Groeningen', 'Groenlo', 'Groesbeek', 'Groessen', 'Groet', 'Grolloo', 'Groningen', 'Gronsveld', 'Groot-Ammers', 'Grootebroek', 'Grootegast', 'Grootschermer', 'Grou', 'Grubbenvorst', 'Gulpen', 'Guttecoven', 'Gytsjerk',
        'Haaften', 'Haaksbergen', 'Haalderen', 'Haaren', 'Haarle', 'Haarle', 'Haarlem', 'Haarlemmerliede', 'Haarlo', 'Haarsteeg', 'Haarzuilens', 'Haastrecht', 'Haelen', 'Hagestein', 'Haghorst', 'Haler', 'Halfweg', 'Hall', 'Halle', 'Hallum', 'Halsteren', 'Handel', 'Hank', 'Hansweert', 'Hantum', 'Hantumeruitburen', 'Hantumhuizen', 'Hapert', 'Haps', 'Harbrinkhoek', 'Hardenberg', 'Harderwijk', 'Hardinxveld-Giessendam', 'Haren Gn', 'Haren', 'Harfsen', 'Harich', 'Haringhuizen', 'Harkema', 'Harkstede', 'Harlingen', 'Harmelen', 'Harreveld', 'Harskamp', 'Hartwerd', 'Haskerdijken', 'Haskerhorne', 'Hasselt', 'Hattem', 'Hattemerbroek', 'Haule', 'Haulerwijk', 'Hauwert', 'Havelte', 'Havelterberg', 'Hazerswoude-Dorp', 'Hazerswoude-Rijndijk', 'Hedel', 'Hedikhuizen', 'Hee', 'Heeg', 'Heel', 'Heelsum', 'Heelweg', 'Heemserveen', 'Heemskerk', 'Heemstede', 'Heenvliet', 'Heerde', 'Heerenveen', 'Heerewaarden', 'Heerhugowaard', 'Heerjansdam', 'Heerle', 'Heerlen', 'Heesbeen', 'Heesch', 'Heesselt', 'Heeswijk-Dinther', 'Heeten', 'Heeze', 'Hegebeintum', 'Hegelsom', 'Hei- en Boeicop', 'Heibloem', 'Heide', 'Heijen', 'Heijenrath', 'Heijningen', 'Heikant', 'Heilig Landstichting', 'Heiligerlee', 'Heiloo', 'Heinenoord', 'Heinkenszand', 'Heino', 'Hekelingen', 'Hekendorp', 'Helden', 'Helenaveen', 'Hellendoorn', 'Hellevoetsluis', 'Hellouw', 'Hellum', 'Helmond', 'Helvoirt', 'Hem', 'Hemelum', 'Hemmen', 'Hempens', 'Hemrik', 'Hendrik-Ido-Ambacht', 'Hengelo (Gld)', 'Hengelo', 'Hengevelde', 'Hengstdijk', 'Hensbroek', 'Herbaijum', 'Herkenbosch', 'Herkingen', 'Hernen', 'Herpen', 'Herpt', 'Herten', 'Hertme', 'Herveld', 'Herwen', 'Herwijnen', 'Heteren', 'Heukelom', 'Heukelum', 'Heumen', 'Heusden', 'Heusden', 'Heveadorp', 'Heythuysen', 'Hezingen', 'Hiaure', 'Hichtum', 'Hidaard', 'Hierden', 'Hieslum', 'Hijken', 'Hijum', 'Hilaard', 'Hillegom', 'Hilvarenbeek', 'Hilversum', 'Hindeloopen', 'Hinnaard', 'Hippolytushoef', 'Hitzum', 'Hobrede', 'Hoedekenskerke', 'Hoek van Holland', 'Hoek', 'Hoenderloo', 'Hoenderloo', 'Hoensbroek', 'Hoenzadriel', 'Hoevelaken', 'Hoeven', 'Hoge Hexel', 'Hollandsche Rading', 'Hollandscheveld', 'Hollum', 'Holsloot', 'Holten', 'Holthees', 'Holtheme', 'Holthone', 'Holtum', 'Holwerd', 'Holwierde', 'Hommerts', 'Homoet', 'Honselersdijk', 'Hoofddorp', 'Hoofdplaat', 'Hoog Soeren', 'Hoog-Keppel', 'Hoogblokland', 'Hooge Mierde', 'Hooge Zwaluwe', 'Hoogeloon', 'Hoogenweg', 'Hoogerheide', 'Hoogersmilde', 'Hoogersmilde', 'Hoogeveen', 'Hoogezand', 'Hooghalen', 'Hoogkarspel', 'Hoogland', 'Hooglanderveen', 'Hoogmade', 'Hoogvliet Rotterdam', 'Hoogwoud', 'Hoorn', 'Hoorn', 'Hoornaar', 'Hoornsterzwaag', 'Horn', 'Hornhuizen', 'Horssen', 'Horst', 'Houten', 'Houtigehage', 'Houwerzijl', 'Huijbergen', 'Huis ter Heide', 'Huis ter Heide', 'Huisduinen', 'Huisseling', 'Huissen', 'Huizen', 'Huizinge', 'Hulsberg', 'Hulsel', 'Hulshorst', 'Hulst', 'Hulten', 'Hummelo', 'Hunsel', 'Hurdegaryp', 'Hurwenen', 'Húns',
        'IJhorst', 'IJlst', 'IJmuiden', 'IJsselham', 'IJsselmuiden', 'IJsselstein', 'IJzendijke', 'IJzendoorn', 'Idaerd', 'Idsegahuizum', 'Idskenhuizen', 'Idzega', 'Iens', 'Ilpendam', 'Indijk', 'Ingber', 'Ingelum', 'Ingen', 'It Heidenskip', 'Itens', 'Ittervoort', 'Jaarsveld', 'Jabeek', 'Jannum', 'Jellum', 'Jelsum', 'Jirnsum', 'Jislum', 'Jisp', 'Jistrum', 'Jonkerslân', 'Jonkersvaart', 'Joppe', 'Jorwert', 'Joure', 'Jouswier', 'Jubbega', 'Julianadorp', 'Jutrijp',
        'Kaag', 'Kaard', 'Kaatsheuvel', 'Kalenberg', 'Kallenkote', 'Kamerik', 'Kampen', 'Kamperland', 'Kamperveen', 'Kantens', 'Kapel Avezaath', 'Kapel-Avezaath', 'Kapelle', 'Kapellebrug', 'Katlijk', 'Kats', 'Kattendijke', 'Katwijk NB', 'Katwijk', 'Katwoude', 'Kedichem', 'Keent', 'Keijenborg', 'Kekerdom', 'Kelpen-Oler', 'Kerk Avezaath', 'Kerk-Avezaath', 'Kerkdriel', 'Kerkenveld', 'Kerkrade', 'Kerkwerve', 'Kerkwijk', 'Kessel', 'Kesteren', 'Kiel-Windeweer', 'Kilder', 'Kimswerd', 'Kinderdijk', 'Kinnum', 'Klaaswaal', 'Klarenbeek', 'Klarenbeek', 'Klazienaveen', 'Klazienaveen-Noord', 'Klein Zundert', 'Klijndijk', 'Klimmen', 'Kloetinge', 'Kloetinge', 'Klooster Lidlum', 'Kloosterburen', 'Kloosterhaar', 'Kloosterhaar', 'Kloosterzande', 'Klundert', 'Knegsel', 'Koarnjum', 'Kockengen', 'Koedijk', 'Koedijk', 'Koekange', 'Koewacht', 'Kolderwolde', 'Kolham', 'Kolhorn', 'Kollum', 'Kollumerpomp', 'Kollumerzwaag', 'Kommerzijl', 'Koningsbosch', 'Koningslust', 'Koog aan de Zaan', 'Koolwijk', 'Kootstertille', 'Kootwijk', 'Kootwijkerbroek', 'Kornhorn', 'Kornwerderzand', 'Kortehemmen', 'Kortenhoef', 'Kortgene', 'Koudekerk aan den Rijn', 'Koudekerke', 'Koudum', 'Koufurderrige', 'Krabbendijke', 'Kraggenburg', 'Kreileroord', 'Krewerd', 'Krimpen aan de Lek', 'Krimpen aan den IJssel', 'Kring van Dorth', 'Krommenie', 'Kronenberg', 'Kropswolde', 'Kruiningen', 'Kruisland', 'Kudelstaart', 'Kuinre', 'Kuitaart', 'Kwadendamme', 'Kwadijk', 'Kwintsheul', 'Kûbaard',
        'Laag Zuthem', 'Laag-Keppel', 'Laag-Soeren', 'Lage Mierde', 'Lage Vuursche', 'Lage Zwaluwe', 'Lageland', 'Lambertschaag', 'Lamswaarde', 'Landerum', 'Landgraaf', 'Landhorst', 'Landsmeer', 'Langbroek', 'Langedijke', 'Langelille', 'Langelo', 'Langenboom', 'Langerak', 'Langeveen', 'Langeweg', 'Langezwaag', 'Langweer', 'Laren', 'Laren', 'Lathum', 'Lattrop-Breklenkamp', 'Lauwersoog', 'Lauwerzijl', 'Ledeacker', 'Leek', 'Leende', 'Leens', 'Leerbroek', 'Leerdam', 'Leermens', 'Leersum', 'Leeuwarden', 'Leeuwarden', 'Legemeer', 'Leiden', 'Leiderdorp', 'Leidschendam', 'Leimuiden', 'Leimuiden', 'Leimuiderbrug', 'Lekkerkerk', 'Lekkum', 'Lellens', 'Lelystad', 'Lemele', 'Lemelerveld', 'Lemiers', 'Lemmer', 'Lengel', 'Lent', 'Leons', 'Lepelstraat', 'Lettelbert', 'Lettele', 'Leunen', 'Leur', 'Leusden', 'Leuth', 'Leutingewolde', 'Leuvenheim', 'Leveroy', 'Lewedorp', 'Lexmond', 'Lichtaard', 'Lichtenvoorde', 'Liempde', 'Lienden', 'Lierderholthuis', 'Lieren', 'Lierop', 'Lies', 'Lieshout', 'Liessel', 'Lievelde', 'Lieveren', 'Lijnden', 'Limbricht', 'Limmen', 'Linde', 'Linden', 'Linne', 'Linschoten', 'Lioessens', 'Lippenhuizen', 'Lisse', 'Lisserbroek', 'Lith', 'Lithoijen', 'Lobith', 'Lochem', 'Loenen aan de Vecht', 'Loenen', 'Loenersloot', 'Loerbeek', 'Lollum', 'Lomm', 'Longerhouw', 'Loo Gld', 'Loo Gld', 'Loon op Zand', 'Loon', 'Loosbroek', 'Loosdrecht', 'Loozen', 'Lopik', 'Lopikerkapel', 'Loppersum', 'Losdorp', 'Losser', 'Lottum', 'Loënga', 'Lucaswolde', 'Luddeweer', 'Luinjeberd', 'Lunteren', 'Lutjebroek', 'Lutjegast', 'Lutjewinkel', 'Luttelgeest', 'Lutten', 'Luttenberg', 'Luxwoude', 'Luyksgestel', 'Lytsewierrum',
        'Maarheeze', 'Maarn', 'Maarsbergen', 'Maarssen', 'Maartensdijk', 'Maasbommel', 'Maasbracht', 'Maasbree', 'Maasdam', 'Maasdijk', 'Maashees', 'Maasland', 'Maassluis', 'Maastricht', 'Maastricht-Airport', 'Maasvlakte Rotterdam', 'Macharen', 'Made', 'Makkinga', 'Makkum', 'Malden', 'Mander', 'Manderveen', 'Mantgum', 'Mantinge', 'Maren-Kessel', 'Margraten', 'Maria Hoop', 'Mariahout', 'Mariaparochie', 'Marijenkampen', 'Mariënberg', 'Mariënheem', 'Mariënvelde', 'Markelo', 'Marken', 'Markenbinnen', 'Marknesse', 'Marle', 'Marrum', 'Marsum', 'Marum', 'Marwijksoord', 'Mastenbroek', 'Mastenbroek', 'Matsloot', 'Maurik', 'Mechelen', 'Medemblik', 'Meeden', 'Meedhuizen', 'Meerkerk', 'Meerlo', 'Meerssen', 'Meerstad', 'Meeuwen', 'Megchelen', 'Megen', 'Meijel', 'Melderslo', 'Melick', 'Meliskerke', 'Melissant', 'Menaam', 'Mensingeweer', 'Meppel', 'Meppen', 'Merkelbeek', 'Merselo', 'Meteren', 'Meterik', 'Metslawier', 'Mheer', 'Middelaar', 'Middelburg', 'Middelharnis', 'Middelie', 'Middelstum', 'Middenbeemster', 'Middenmeer', 'Midlaren', 'Midlum', 'Midsland', 'Midwolda', 'Midwolde', 'Midwoud', 'Miedum', 'Mierlo', 'Mijdrecht', 'Mijnsheerenland', 'Mildam', 'Milheeze', 'Mill', 'Millingen aan de Rijn', 'Milsbeek', 'Minnertsga', 'Mirns', 'Moddergat', 'Moerdijk', 'Moergestel', 'Moerkapelle', 'Moerstraten', 'Molenaarsgraaf', 'Molenhoek', 'Molenschot', 'Molkwerum', 'Monnickendam', 'Monster', 'Montfoort', 'Montfort', 'Mook', 'Mookhoek', 'Moordrecht', 'Moorveld', 'Morra', 'Muiden', 'Muiderberg', 'Munnekeburen', 'Munnekezijl', 'Munstergeleen', 'Muntendam', 'Mussel', 'Musselkanaal', 'Mûnein',
        'Naaldwijk', 'Naarden', 'Nagele', 'Nederasselt', 'Nederhemert', 'Nederhorst den Berg', 'Nederland', 'Nederweert', 'Nederweert-Eind', 'Neede', 'Neer', 'Neerijnen', 'Neeritter', 'Neerkant', 'Neerlangel', 'Neerloon', 'Nes (Ameland)', 'Nes (Boornsterhem)', 'Nes (Dongeradeel)', 'Netersel', 'Netterden', 'Niawier', 'Nibbixwoud', 'Niebert', 'Niehove', 'Niekerk', 'Niekerk', 'Nietap', 'Nieuw Annerveen', 'Nieuw Beerta', 'Nieuw Heeten', 'Nieuw Namen', 'Nieuw Scheemda', 'Nieuw- en Sint Joosland', 'Nieuw-Amsterdam', 'Nieuw-Balinge', 'Nieuw-Beijerland', 'Nieuw-Buinen', 'Nieuw-Dordrecht', 'Nieuw-Lekkerland', 'Nieuw-Roden', 'Nieuw-Schoonebeek', 'Nieuw-Vennep', 'Nieuw-Vossemeer', 'Nieuw-Weerdinge', 'Nieuwaal', 'Nieuwdorp', 'Nieuwe Niedorp', 'Nieuwe Pekela', 'Nieuwe Wetering', 'Nieuwe-Tonge', 'Nieuwebrug', 'Nieuwediep', 'Nieuwegein', 'Nieuwehorne', 'Nieuwendijk', 'Nieuwer Ter Aa', 'Nieuwerbrug aan den Rijn', 'Nieuwerkerk aan den IJssel', 'Nieuwerkerk', 'Nieuweroord', 'Nieuweroord', 'Nieuwersluis', 'Nieuweschoot', 'Nieuwkoop', 'Nieuwkuijk', 'Nieuwland', 'Nieuwlande Coevorden', 'Nieuwlande', 'Nieuwleusen', 'Nieuwolda', 'Nieuwpoort', 'Nieuwstadt', 'Nieuwveen', 'Nieuwvliet', 'Niezijl', 'Niftrik', 'Nigtevecht', 'Nij Altoenae', 'Nij Beets', 'Nijbroek', 'Nijeberkoop', 'Nijega', 'Nijehaske', 'Nijeholtpade', 'Nijeholtwolde', 'Nijelamer', 'Nijemirdum', 'Nijensleek', 'Nijetrijne', 'Nijeveen', 'Nijhuizum', 'Nijkerk', 'Nijkerkerveen', 'Nijland', 'Nijlande', 'Nijmegen', 'Nijverdal', 'Nispen', 'Nisse', 'Nistelrode', 'Noardburgum', 'Nooitgedacht', 'Noorbeek', 'Noord-Scharwoude', 'Noord-Sleen', 'Noordbeemster', 'Noordbroek', 'Noordeinde Gld', 'Noordeinde', 'Noordeloos', 'Noorden', 'Noordgouwe', 'Noordhoek', 'Noordhorn', 'Noordlaren', 'Noordscheschut', 'Noordwelle', 'Noordwijk', 'Noordwijk', 'Noordwijkerhout', 'Noordwolde', 'Noordwolde', 'Nootdorp', 'Norg', 'Notter', 'Nuenen', 'Nuis', 'Nuland', 'Numansdorp', 'Nunhem', 'Nunspeet', 'Nuth', 'Nutter',
        'Obbicht', 'Obdam', 'Ochten', 'Odijk', 'Odiliapeel', 'Odoorn', 'Odoornerveen', 'Oeffelt', 'Oegstgeest', 'Oene', 'Oentsjerk', 'Offingawier', 'Ohé en Laak', 'Oijen', 'Oirlo', 'Oirsbeek', 'Oirschot', 'Oisterwijk', 'Okkenbroek', 'Olburgen', 'Oldeberkoop', 'Oldebroek', 'Oldeholtpade', 'Oldeholtwolde', 'Oldehove', 'Oldekerk', 'Oldelamer', 'Oldemarkt', 'Oldenzaal', 'Oldenzijl', 'Oldeouwer', 'Oldetrijne', 'Olst', 'Olterterp', 'Ommel', 'Ommen', 'Ommeren', 'Onderdendam', 'Onna', 'Onnen', 'Onstwedde', 'Ooij', 'Ooltgensplaat', 'Oost West en Middelbeers', 'Oost-Graftdijk', 'Oost-Souburg', 'Oostburg', 'Oostdijk', 'Oosteind', 'Oosterbeek', 'Oosterbierum', 'Oosterblokker', 'Oosterend', 'Oosterend', 'Oosterhesselen', 'Oosterhout', 'Oosterhout', 'Oosterland', 'Oosterleek', 'Oosternieland', 'Oosternijkerk', 'Oosterstreek', 'Oosterwijk', 'Oosterwijtwerd', 'Oosterwolde Gld', 'Oosterwolde', 'Oosterzee', 'Oosthem', 'Oosthuizen', 'Oostkapelle', 'Oostknollendam', 'Oostrum', 'Oostrum', 'Oostvoorne', 'Oostwold', 'Oostwold', 'Oostwoud', 'Oostzaan', 'Ootmarsum', 'Opeinde', 'Opende', 'Ophemert', 'Opheusden', 'Opijnen', 'Oploo', 'Opmeer', 'Oppenhuizen', 'Opperdoes', 'Oranje', 'Oranjewoud', 'Orvelte', 'Ospel', 'Oss', 'Ossendrecht', 'Ossenisse', 'Ossenwaard', 'Ossenzijl', 'Oterleek', 'Otterlo', 'Ottersum', 'Ottoland', 'Oud Ade', 'Oud Annerveen', 'Oud Gastel', 'Oud Ootmarsum', 'Oud Zuilen', 'Oud-Alblas', 'Oud-Beijerland', 'Oud-Vossemeer', 'Ouddorp', 'Oude Meer', 'Oude Niedorp', 'Oude Pekela', 'Oude Wetering', 'Oude Willem', 'Oude-Tonge', 'Oudebildtzijl', 'Oudega', 'Oudega', 'Oudega', 'Oudehaske', 'Oudehorne', 'Oudelande', 'Oudemirdum', 'Oudemolen', 'Oudemolen', 'Oudenbosch', 'Oudendijk', 'Oudenhoorn', 'Ouderkerk aan de Amstel', 'Ouderkerk aan den IJssel', 'Oudeschans', 'Oudeschild', 'Oudeschip', 'Oudeschoot', 'Oudesluis', 'Oudewater', 'Oudezijl', 'Oudheusden', 'Oudkarspel', 'Oudkarspel', 'Oudorp', 'Oudwoude', 'Ouwerkerk', 'Ouwster-Nijega', 'Ouwsterhaule', 'Overasselt', 'Overberg', 'Overdinkel', 'Overlangel', 'Overloon', 'Overschild', 'Overslag', 'Overveen', 'Ovezande',
        'Paasloo', 'Paesens', 'Pannerden', 'Panningen', 'Papekop', 'Papendrecht', 'Papenhoven', 'Papenvoort', 'Parrega', 'Paterswolde', 'Peest', 'Peins', 'Peize', 'Peperga', 'Pernis Rotterdam', 'Persingen', 'Pesse', 'Pesse', 'Petten', 'Philippine', 'Piaam', 'Piershil', 'Pieterburen', 'Pietersbierum', 'Pieterzijl', 'Pijnacker', 'Pingjum', 'Plasmolen', 'Poederoijen', 'Poeldijk', 'Polsbroek', 'Poortugaal', 'Poortvliet', 'Poppenwier', 'Posterholt', 'Prinsenbeek', 'Puiflijk', 'Punthorst', 'Purmer', 'Purmer', 'Purmerend', 'Purmerland', 'Puth', 'Putte', 'Putten', 'Puttershoek',
        'Raalte', 'Raamsdonk', 'Raamsdonksveer', 'Raard', 'Radewijk', 'Radio Kootwijk', 'Raerd', 'Randwijk', 'Ransdaal', 'Rasquert', 'Ravenstein', 'Ravenswaaij', 'Ravenswoud', 'Readtsjerk', 'Reahûs', 'Reduzum', 'Reek', 'Reeuwijk', 'Reijmerstok', 'Reitsum', 'Rekken', 'Renesse', 'Renkum', 'Renswoude', 'Ressen', 'Retranchement', 'Reusel', 'Reutum', 'Reuver', 'Rha', 'Rheden', 'Rhee', 'Rheeze', 'Rheezerveen', 'Rhenen', 'Rhenoy', 'Rhoon', 'Ridderkerk', 'Ried', 'Riel', 'Rien', 'Riethoven', 'Rietmolen', 'Rijen', 'Rijkevoort', 'Rijkevoort-De Walsert', 'Rijnsaterwoude', 'Rijnsburg', 'Rijpwetering', 'Rijpwetering', 'Rijs', 'Rijsbergen', 'Rijsenhout', 'Rijssen', 'Rijswijk (GLD)', 'Rijswijk (NB)', 'Rijswijk', 'Rilland', 'Rinsumageast', 'Ritthem', 'Rockanje', 'Roden', 'Roderesch', 'Roderwolde', 'Roelofarendsveen', 'Roermond', 'Rogat', 'Roggel', 'Rohel', 'Rolde', 'Roodeschool', 'Roosendaal', 'Roosteren', 'Rosmalen', 'Rossum', 'Rossum', 'Roswinkel', 'Rotstergaast', 'Rotsterhaule', 'Rotterdam', 'Rotterdam-Albrandswaard', 'Rottevalle', 'Rottum', 'Rottum', 'Rouveen', 'Rozenburg', 'Rozenburg', 'Rozendaal', 'Rucphen', 'Ruigahuizen', 'Ruinen', 'Ruinen', 'Ruinerwold', 'Rumpt', 'Rutten', 'Ruurlo', 'Ryptsjerk',
        'Saaksum', 'Saasveld', 'Saaxumhuizen', 'Sambeek', 'Sandfirden', 'Santpoort-Noord', 'Santpoort-Zuid', 'Sappemeer', 'Sas van Gent', 'Sassenheim', 'Sauwerd', 'Schagen', 'Schagerbrug', 'Schaijk', 'Schalkhaar', 'Schalkwijk', 'Schalsum', 'Schardam', 'Scharendijke', 'Scharmer', 'Scharnegoutum', 'Scharsterbrug', 'Scharwoude', 'Scheemda', 'Scheerwolde', 'Schellinkhout', 'Schelluinen', 'Schermerhorn', 'Scherpenisse', 'Scherpenzeel', 'Scherpenzeel', 'Schettens', 'Scheulder', 'Schiedam', 'Schiermonnikoog', 'Schijf', 'Schijndel', 'Schildwolde', 'Schimmert', 'Schin op Geul', 'Schinnen', 'Schinveld', 'Schipborg', 'Schiphol', 'Schiphol-Rijk', 'Schipluiden', 'Schokland', 'Schoondijke', 'Schoonebeek', 'Schoonhoven', 'Schoonloo', 'Schoonoord', 'Schoonrewoerd', 'Schoorl', 'Schore', 'Schouwerzijl', 'Schraard', 'Schuinesloot', 'Sebaldeburen', 'Sellingen', 'Serooskerke', 'Serooskerke', 'Sevenum', 'Sexbierum', 'Sibculo', 'Sibculo', 'Sibrandabuorren', 'Sibrandahûs', 'Siddeburen', 'Siebengewald', 'Siegerswoude', 'Sijbekarspel', 'Silvolde', 'Simonshaven', 'Simpelveld', 'Sinderen', 'Sint Agatha', 'Sint Annen', 'Sint Anthonis', 'Sint Geertruid', 'Sint Hubert', 'Sint Jansklooster', 'Sint Jansteen', 'Sint Joost', 'Sint Kruis', 'Sint Maarten', 'Sint Maartensbrug', 'Sint Maartensvlotbrug', 'Sint Nicolaasga', 'Sint Odiliënberg', 'Sint Pancras', 'Sint Philipsland', 'Sint-Annaland', 'Sint-Maartensdijk', 'Sint-Michielsgestel', 'Sint-Oedenrode', 'Sintjohannesga', 'Sirjansland', 'Sittard', 'Skingen', 'Slagharen', 'Slappeterp', 'Sleen', 'Sleeuwijk', 'Slenaken', 'Sliedrecht', 'Slijk-Ewijk', 'Slijkenburg', 'Slochteren', 'Slootdorp', 'Sloten', 'Sluis', 'Sluiskil', 'Smakt', 'Smalle Ee', 'Smallebrugge', 'Smilde', 'Smilde', 'Snakkerburen', 'Sneek', 'Snelrewaard', 'Snikzwaag', 'Soerendonk', 'Soest', 'Soesterberg', 'Someren', 'Sommelsdijk', 'Son en Breugel', 'Son', 'Sondel', 'Sonnega', 'Spaarndam gem. Haarlem', 'Spaarndam', 'Spanbroek', 'Spanga', 'Spankeren', 'Spannum', 'Spaubeek', 'Spier', 'Spier', 'Spierdijk', 'Spijk Gn', 'Spijk', 'Spijk', 'Spijkenisse', 'Spijkerboor', 'Spijkerboor', 'Sprang-Capelle', 'Sprundel', 'Spui', 'St. Willebrord', 'St.-Annaparochie', 'St.-Jacobiparochie', "Stad aan 't Haringvliet", 'Stadskanaal', 'Stampersgat', 'Standdaarbuiten', 'Staphorst', 'Starnmeer', 'Startenhuizen', 'Startenhuizen', 'Stavenisse', 'Stavoren', 'Stedum', 'Steenbergen', 'Steenbergen', 'Steendam', 'Steenderen', 'Steenenkamer', 'Steensel', 'Steenwijk', 'Steenwijkerwold', 'Stegeren', 'Steggerda', 'Stein', 'Stellendam', 'Sterksel', 'Stevensbeek', 'Stevensweert', 'Steyl', 'Stieltjeskanaal', 'Stiens', 'Stitswerd', 'Stokkum', 'Stolwijk', 'Stompetoren', 'Stoutenburg Noord', 'Stoutenburg', 'Stramproy', 'Streefkerk', 'Striep', 'Strijbeek', 'Strijen', 'Strijensas', 'Stroe', 'Stroobos', 'Stuifzand', 'Stuifzand', 'Sumar', 'Surhuisterveen', 'Surhuizum', 'Susteren', 'Suwâld', 'Swalmen', 'Sweikhuizen', 'Swichum', 'Swifterbant', 'Swolgen',
        'Taarlo', 'Teeffelen', 'Teerns', 'Tegelen', 'Ten Boer', 'Ten Post', 'Ter Aar', 'Ter Aard', 'Ter Apel', 'Ter Apelkanaal', 'Ter Heijde', 'Ter Idzard', 'Terband', 'Terborg', 'Terheijden', 'Terherne', 'Terhole', 'Terkaple', 'Termunten', 'Termunterzijl', 'Ternaard', 'Terneuzen', 'Teroele', 'Terschuur', 'Tersoal', 'Terwispel', 'Terwolde', 'Teteringen', 'Teuge', 'Thesinge', 'Tholen', 'Thorn', 'Tiel', 'Tiendeveen', 'Tiendeveen', 'Tienhoven', 'Tienhoven', 'Tienray', 'Tijnje', 'Tilburg', 'Tilligte', 'Tinallinge', 'Tinte', 'Tirns', 'Tjalhuizum', 'Tjalleberd', 'Tjerkgaast', 'Tjerkwerd', 'Tjuchem', 'Tolbert', 'Toldijk', 'Tolkamer', 'Tollebeek', 'Tonden', 'Toornwerd', 'Tricht', 'Triemen', 'Tripscompagnie', 'Tubbergen', 'Tuil', 'Tuitjenhorn', 'Tuk', "Tull en 't Waal", 'Twello', 'Twijzel', 'Twijzelerheide', 'Twisk', 'Tynaarlo', 'Tytsjerk', 'Tzum', 'Tzummarum',
        'Ubbena', 'Ubbergen', 'Uddel', 'Uden', 'Udenhout', 'Uffelte', 'Ugchelen', 'Uitdam', 'Uitgeest', 'Uithoorn', 'Uithuizen', 'Uithuizermeeden', 'Uitwellingerga', 'Uitwijk', 'Ulestraten', 'Ulft', 'Ulicoten', 'Ulrum', 'Ulvenhout AC', 'Ulvenhout', 'Ureterp', 'Urk', 'Urmond', 'Ursem gem. S', 'Ursem', 'Usquert', 'Utrecht',
        'Vaals', 'Vaassen', 'Valburg', 'Valkenburg', 'Valkenburg', 'Valkenswaard', 'Valthe', 'Valthermond', 'Varik', 'Varsselder', 'Varsseveld', 'Vasse', 'Veelerveen', 'Veen', 'Veendam', 'Veenendaal', 'Veenhuizen', 'Veeningen', 'Veenklooster', 'Veenoord', 'Veere', 'Veessen', 'Vegelinsoord', 'Veghel', 'Velddriel', 'Velden', 'Veldhoven', 'Velp', 'Velp', 'Velsen-Noord', 'Velsen-Zuid', 'Velserbroek', 'Ven-Zelderheide', 'Venebrugge', 'Venhorst', 'Venhuizen', 'Venlo', 'Venray', 'Vessem', 'Vethuizen', 'Veulen', 'Vianen NB', 'Vianen', 'Vierakker', 'Vierhouten', 'Vierhuizen', 'Vierlingsbeek', 'Vierpolders', 'Vijfhuizen', 'Vijlen', 'Vilsteren', 'Vinkega', 'Vinkel', 'Vinkel', 'Vinkenbuurt', 'Vinkeveen', 'Visvliet', 'Vlaardingen', 'Vlagtwedde', 'Vledder', 'Vledderveen', 'Vledderveen', 'Vleuten', 'Vlieland', 'Vlierden', 'Vlijmen', 'Vlissingen', 'Vlist', 'Vlodrop', 'Voerendaal', 'Vogelenzang', 'Vogelwaarde', 'Volendam', 'Volkel', 'Vollenhove', 'Vondelingenplaat Rotterdam', 'Voorburg', 'Voorhout', 'Voorschoten', 'Voorst', 'Voorst', 'Voorthuizen', 'Vorchten', 'Vorden', 'Vorstenbosch', 'Vortum-Mullem', 'Vragender', 'Vredenheim', 'Vredepeel', 'Vreeland', 'Vries', 'Vriescheloo', 'Vriezenveen', 'Vroomshoop', 'Vrouwenakker', 'Vrouwenparochie', 'Vrouwenpolder', 'Vught', 'Vuren',
        'Waaksens', 'Waal', 'Waalre', 'Waalwijk', 'Waarde', 'Waardenburg', 'Waarder', 'Waardhuizen', 'Waarland', 'Waaxens', 'Wachtum', 'Waddinxveen', 'Wadenoijen', 'Wagenberg', 'Wagenborgen', 'Wageningen', 'Walem', 'Walsoorden', 'Wamel', 'Wanneperveen', 'Wanroij', 'Wanssum', 'Wapenveld', 'Wapse', 'Wapserveen', 'Warder', 'Warffum', 'Warfhuizen', 'Warfstermolen', 'Warmenhuizen', 'Warmond', 'Warns', 'Warnsveld', 'Warstiens', 'Warten', 'Waskemeer', 'Waspik', 'Wassenaar', 'Wateren', 'Watergang', 'Waterhuizen', 'Wateringen', 'Waterlandkerkje', 'Waverveen', 'Wedde', 'Weerselo', 'Weert', 'Weesp', 'Wehe-den Hoorn', 'Wehl', 'Weidum', 'Weiteveen', 'Wekerom', 'Well L', 'Well', 'Wellerlooi', 'Welsum', 'Wemeldinge', 'Wenum Wiesel', 'Wenum Wiesel', 'Wergea', 'Werkendam', 'Werkhoven', 'Wernhout', 'Wervershoof', 'Wesepe', 'Wessem', 'West-Graftdijk', 'West-Terschelling', 'Westbeemster', 'Westbroek', 'Westdorp', 'Westdorpe', 'Westendorp', 'Westerbeek', 'Westerbork', 'Westerbroek', 'Westeremden', 'Westergeest', 'Westerhaar-Vriezenveensewijk', 'Westerhoven', 'Westerland', 'Westerlee', 'Westernieland', 'Westervelde', 'Westervoort', 'Westerwijtwerd', 'Westhem', 'Westhoek', 'Westkapelle', 'Westknollendam', 'Westmaas', 'Westwoud', 'Westzaan', 'Wetering', 'Weteringbrug', 'Wetsens', 'Wetsinge', 'Weurt', 'Wezep', 'Wezup', 'Wezuperbrug', 'Wichmond', 'Wier', 'Wierden', 'Wieringerwaard', 'Wieringerwerf', 'Wierum', 'Wijchen', 'Wijckel', 'Wijdenes', 'Wijdewormer', 'Wijhe', 'Wijk aan Zee', 'Wijk bij Duurstede', 'Wijk en Aalburg', 'Wijlre', 'Wijnaldum', 'Wijnandsrade', 'Wijnbergen', 'Wijngaarden', 'Wijnjewoude', 'Wijster', 'Wilbertoord', 'Wildervank', 'Wilhelminadorp', 'Wilhelminaoord', 'Willemsoord', 'Willemstad', 'Wilnis', 'Wilp', 'Wilsum', 'Winde', 'Windraak', 'Winkel', 'Winneweer', 'Winschoten', 'Winssen', 'Winsum', 'Winsum', 'Wintelre', 'Winterswijk Brinkheurne', 'Winterswijk Corle', 'Winterswijk Henxel', 'Winterswijk Huppel', 'Winterswijk Kotten', 'Winterswijk Meddo', 'Winterswijk Miste', 'Winterswijk Ratum', 'Winterswijk Woold', 'Winterswijk', 'Wirdum Gn', 'Wirdum', 'Wissenkerke', 'Witharen', 'Witmarsum', 'Witte Paarden', 'Wittelte', 'Wittem', 'Witteveen', 'Wiuwert', 'Wjelsryp', 'Woensdrecht', 'Woerden', 'Woerdense Verlaat', 'Wognum', 'Woldendorp', 'Wolfheze', 'Wolphaartsdijk', 'Wolsum', 'Woltersum', 'Wolvega', 'Wommels', 'Wons', 'Workum', 'Wormer', 'Wormerveer', 'Woubrugge', 'Woudbloem', 'Woudenberg', 'Woudrichem', 'Woudsend', 'Wouw', 'Wouwse Plantage', 'Wyns', 'Wytgaard', 'Wâlterswâld', 'Wânswert',
        'Yde', 'Yerseke', 'Ypecolsga', 'Ysbrechtum', 'Ysselsteyn',
        'Zaamslag', 'Zaandam', 'Zaandijk', 'Zalk', 'Zaltbommel', 'Zandberg', 'Zandeweer', 'Zandhuizen', 'Zandpol', 'Zandvoort', 'Zeddam', 'Zeegse', 'Zeeland', 'Zeerijp', 'Zeewolde', 'Zegge', 'Zegveld', 'Zeijen', 'Zeijerveen', 'Zeijerveld', 'Zeist', 'Zelhem', 'Zenderen', 'Zennewijnen', 'Zennewijnen', 'Zetten', 'Zevenaar', 'Zevenbergen', 'Zevenbergschen Hoek', 'Zevenbergschen Hoek', 'Zevenhoven', 'Zevenhuizen', 'Zevenhuizen', 'Zierikzee', 'Zieuwent', 'Zijderveld', 'Zijdewind', 'Zijldijk', 'Zoelen', 'Zoelmond', 'Zoetermeer', 'Zoeterwoude', 'Zonnemaire', 'Zorgvlied', 'Zoutelande', 'Zoutkamp', 'Zuid-Beijerland', 'Zuid-Scharwoude', 'Zuidbroek', 'Zuiddorpe', 'Zuidermeer', 'Zuiderwoude', 'Zuidhorn', 'Zuidlaarderveen', 'Zuidland', 'Zuidlaren', 'Zuidoostbeemster', 'Zuidschermer', 'Zuidveen', 'Zuidveld', 'Zuidvelde', 'Zuidwolde', 'Zuidwolde', 'Zuidzande', 'Zuilichem', 'Zuna', 'Zundert', 'Zurich', 'Zutphen', 'Zuurdijk', 'Zwaag', 'Zwaagdijk-Oost', 'Zwaagdijk-West', 'Zwaanshoek', 'Zwagerbosch', 'Zwammerdam', 'Zwanenburg', 'Zwartebroek', 'Zwartemeer', 'Zwartewaal', 'Zwartsluis', 'Zweeloo', 'Zweins', 'Zwiggelte', 'Zwijndrecht', 'Zwinderen', 'Zwolle', 'de Hoef', 'de Lutte', 'de Wijk', 'de Woude',
    );

    protected static $state = array(
        'Drenthe', 'Gelderland', 'Groningen', 'Flevoland', 'Friesland', 'Noord-Brabant', 'Noord-Holland', 'Overijssel', 'Limburg', 'Utrecht', 'Zeeland', 'Zuid-Holland'
    );

    protected static $country = array(
        'Afghanistan', 'Albanië', 'Algerije', 'Amerikaans-Samoa', 'Andorra', 'Angola', 'Amerikaanse Virgineilanden', 'Anguilla', 'Antartica', 'Antigua en Barbuda', 'Argentinië', 'Armenië', 'Aruba', 'Australië', 'Azerbeidzjan',
        'Bahamas', 'Bahrein', 'Bangladesh', 'Barbados', 'België', 'Belize', 'Benin', 'Bermuda', 'Bhutan', 'Bolivia', 'Bosnië-Herzegovina', 'Botswana', 'Bouvet Eiland (Bouvetøya)', 'Brazilië', 'Britse Maagdeneilanden', 'Brunei Darussalam', 'Bulgarije', 'Burkina Faso', 'Burundi',
        'Cambodja', 'Canada', 'Centraal-Afrikaanse Republiek', 'Chili', 'China', 'Christmaseiland', 'Cocoseilanden', 'Colombia', 'Comoren', 'Congo', 'Cookeilanden', 'Costa Rica', 'Cuba', 'Cyprus',
        'Denemarken', 'Djibouti', 'Dominica', 'Dominicaanse Republiek', 'Duitsland',
        'Ecuador', 'Egypte', 'El salvador', 'Equatoriaal-Guinea', 'Eritrea', 'Estland', 'Ethiopië',
        'Faroe Eilanden', 'Falklandeilanden', 'Fiji', 'Finland', 'Frankrijk', 'Frans-Guyana', 'Frans-Polynesië', 'Franse Zuidelijke en Antarctische Gebieden',
        'Gabon', 'Gambia', 'Georgië', 'Ghana', 'Gibraltar', 'Griekenland', 'Groenland', 'Grenada', 'Guadeloupe', 'Guam', 'Guatemala', 'Guernsey', 'Guinee', 'Guinee-Bissau', 'Guyana',
        'Haïti', 'Heard en McDonaldeilanden', 'Honduras', 'Hong Kong', 'Hongarije',
        'IJsland', 'India', 'Indonesië', 'Iran', 'Irak', 'Ierland', 'Man', 'Israel', 'Ivoorkust', 'Italië',
        'Jamaica', 'Japan', 'Jersey', 'Jordanië', 'Jemen',
        'Kazachstan', 'Kenia', 'Kleinere afgelegen eilanden van de Verenigde Staten', 'Kiribati', 'Korea', 'Koeweit', 'Kirgizië', 'Kameroen', 'Kaapverdië', 'Kaaimaneilanden', 'Kroatië',
        'Laos', 'Letland', 'Libanon', 'Lesotho', 'Liberia', 'Libië', 'Liechtenstein', 'Litouwen', 'Luxemburg',
        'Macau', 'Macedonië', 'Madagascar', 'Malawi', 'Maleisië', 'Maldiven', 'Mali', 'Malta', 'Marshalleilanden', 'Martinique', 'Mauritus', 'Mauritania', 'Mayotte', 'Mexico', 'Micronesië', 'Moldavië', 'Monaco', 'Mongolië', 'Montenegro', 'Monsterrat', 'Marokko', 'Mozambique', 'Myanmar',
        'Namibië', 'Nauru', 'Nepal', 'Nederlandse Antillen', 'Nederland', 'Nieuw-Caledonië', 'Nieuw-Zeeland', 'Nicaragua', 'Niger', 'Nigeria', 'Niue', 'Norfolk', 'Noordelijke Marianen', 'Noorwegen',
        'Oman', 'Oostenrijk', 'Oeganda', 'Oekraïne', 'Oezbakistan',
        'Pakistan', 'Palau', 'Palestina', 'Panama', 'Papoea-Nieuw-Guinea', 'Paraguay', 'Peru', 'Filipijnen', 'Pitcairneilanden', 'Polen', 'Portugal', 'Puerto Rico',
        'Qatar',
        'Réunion', 'Romania', 'Rusland', 'Rwanda',
        'Sint-Bartholomeus', 'Sint-Helena', 'Saint Kitts en Nevis', 'Saint Lucia', 'Sint Maarten', 'Saint-Pierre en Miquelon', 'Saint Vincent en de Grenadines', 'Samoa', 'San Marino', 'Sao Tomé en Principe', 'Saoedi-Arabië', 'Senegal', 'Servië', 'Seychellen', 'Sierra Leone', 'Singapore', 'Slovenië', 'Salomonseilanden', 'Somalië', 'Spanje', 'Sri Lanka', 'Soedan', 'Suriname', 'Spitsbergen en Jan Mayen', 'Swaziland', 'Zweden', 'Zwitserland', 'Syrië',
        'Taiwan', 'Tadzjikistan', 'Tanzania', 'Thailand', 'Tsjaad', 'Timor-Leste', 'Togo', 'Tokelau-eilanden', 'Tonga', 'Trinidad en Trobago', 'Tunesië', 'Turkije', 'Turkmenistan', 'Turks- en Caicoseilanden', 'Tuvalu', 'Tsjechische Republiek',
        'Uruguay',
        'Vanuatu', 'Venezuela', 'Verenigde Arabische Emiraten', 'Verenigd Koninkrijk', 'Verenigde Staten van Amerika', 'Vaticaanstad', 'Vietnam',
        'Wallis en Futuna', 'Westerlijke Shara', 'Wit-Rusland',
        'Zambia', 'Zuid-Afrika', 'Zuid-Georgia en de Zuidelijke Sandwicheilanden', 'Zimbabwe'
    );

    /**
    * @see parent
    */
    public static function buildingNumber()
    {
        return static::bothify(static::randomElement(static::$buildingNumber));
    }

    /**
     * @example 'Gelderland'
     */
    public static function state()
    {
        return static::randomElement(static::$state);
    }

    /**
    * @see parent
    */
    public function cityName()
    {
        return static::randomElement(static::$cityNames);
    }
    
    public static function postcode()
    {
        return static::randomElement(static::$postcodes);
    }
}
