<?php

namespace Faker\ORM\CakePHP;

class Populator
{

    protected $generator;
    protected $entities = [];
    protected $quantities = [];
    protected $guessers = [];

    /**
     * @param \Faker\Generator $generator
     */
    public function __construct(\Faker\Generator $generator)
    {
        $this->generator = $generator;
    }

    /**
     * @return \Faker\Generator
     */
    public function getGenerator()
    {
        return $this->generator;
    }

    /**
     * @return array
     */
    public function getGuessers()
    {
        return $this->guessers;
    }

    /**
     * @return $this
     */
    public function removeGuesser($name)
    {
        if ($this->guessers[$name]) {
            unset($this->guessers[$name]);
        }
        return $this;
    }

    /**
     * @return $this
     * @throws \Exception
     */
    public function addGuesser($class)
    {
        if (!is_object($class)) {
            $class = new $class($this->generator);
        }

        if (!method_exists($class, 'guessFormat')) {
            throw new \Exception('Missing required custom guesser method: ' . get_class($class) . '::guessFormat()');
        }

        $this->guessers[get_class($class)] = $class;
        return $this;
    }

    /**
     * @param array $customColumnFormatters
     * @param array $customModifiers
     * @return $this
     */
    public function addEntity($entity, $number, $customColumnFormatters = [], $customModifiers = [])
    {
        if (!$entity instanceof EntityPopulator) {
            $entity = new EntityPopulator($entity);
        }

        $entity->columnFormatters = $entity->guessColumnFormatters($this);
        if ($customColumnFormatters) {
            $entity->mergeColumnFormattersWith($customColumnFormatters);
        }

        $entity->modifiers = $entity->guessModifiers($this);
        if ($customModifiers) {
            $entity->mergeModifiersWith($customModifiers);
        }

        $class = $entity->class;
        $this->entities[$class] = $entity;
        $this->quantities[$class] = $number;
        return $this;
    }

    /**
     * @param array $options
     * @return array
     */
    public function execute($options = [])
    {
        $insertedEntities = [];

        foreach ($this->quantities as $class => $number) {
            for ($i = 0; $i < $number; $i++) {
                $insertedEntities[$class][] = $this->entities[$class]->execute($class, $insertedEntities, $options);
            }
        }

        return $insertedEntities;
    }
}
         <?php

namespace Faker\ORM\CakePHP;

class ColumnTypeGuesser
{
    protected $generator;

    public function __construct(\Faker\Generator $generator)
    {
        $this->generator = $generator;
    }

    /**
     * @return \Closure|null
     */
    public function guessFormat($column, $table)
    {
        $generator = $this->generator;
        $schema = $table->schema();

        switch ($schema->columnType($column)) {
            case 'boolean':
                return function () use ($generator) {
                    return $generator->boolean;
                };
            case 'integer':
                return function () {
                    return mt_rand(0, intval('2147483647'));
                };
            case 'biginteger':
                return function () {
                    return mt_rand(0, intval('9223372036854775807'));
                };
            case 'decimal':
            case 'float':
                return function () use ($generator) {
                    return $generator->randomFloat();
                };
            case 'uuid':
                return function () use ($generator) {
                    return $generator->uuid();
                };
            case 'string':
                $columnData = $schema->column($column);
                $length = $columnData['length'];
                return function () use ($generator, $length) {
                    return $generator->text($length);
                };
            case 'text':
                return function () use ($generator) {
                    return $generator->text();
                };
            case 'date':
            case 'datetime':
            case 'timestamp':
            case 'time':
                return function () use ($generator) {
                    return $generator->datetime();
                };

            case 'binary':
            default:
                return null;
        }
    }
}
