<?php $request = app('Illuminate\Http\Request'); ?>
<!-- Left side column. contains the sidebar -->
<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
        <ul class="sidebar-menu">
            
            <?php if(Auth::user()->roles[0]->name == "administrator"): ?>
                <div class="user-panel">
                    <div class="pull-left image">
                    <img src="<?php echo e(url('backend/images/admin.png')); ?>" class="img-circle" alt="Admin Image">
                    </div>
                    <div class="pull-left info">
                    <p>Administrator</p>
                    <a href="#"><i class="fa fa-circle text-success"></i> <?php echo app('translator')->getFromJson('global.app_online'); ?></a>
                    </div>
                </div>
            <?php elseif(Auth::user()->roles[0]->name == "owner"): ?>
                <div class="user-panel">
                    <div class="pull-left image">
                    <img src="<?php echo e(url('backend/images/manager.png')); ?>" class="img-circle" alt="Manager Image">
                    </div>
                    <div class="pull-left info">
                    <p>Owner</p>
                    <a href="#"><i class="fa fa-circle text-success"></i> <?php echo app('translator')->getFromJson('global.app_online'); ?></a>
                    </div>
                </div>
            <?php else: ?>
                <div class="user-panel">
                    <div class="pull-left image">
                    <img src="<?php echo e(url('backend/images/manager.png')); ?>" class="img-circle" alt="Manager Image">
                    </div>
                    <div class="pull-left info">
                    <p>Manager</p>
                    <a href="#"><i class="fa fa-circle text-success"></i> <?php echo app('translator')->getFromJson('global.app_online'); ?></a>
                    </div>
                </div>
            <?php endif; ?>

            <li class="<?php echo e($request->segment(1) == 'home' ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/admin')); ?>">
                    <i class="fa fa-dashboard"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.app_dashboard'); ?></span>
                </a>
            </li>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('website_manage')): ?>
            <li class="treeview">
                <a href="#">
                    <i class="fa fa-globe"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.website-management.title'); ?></span>
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                </a>
                <ul class="treeview-menu">
                    <li class="treeview <?php echo e($request->segment(2) == 'imagehome'|| $request->segment(2) == 'client'|| $request->segment(2) == 'review' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.permissions.index')); ?>">
                            <i class="fa fa-home"></i> 
                            <?php echo app('translator')->getFromJson('global.website-management.fields.home'); ?>
                            <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                            </span>
                        </a>
                        <ul class="treeview-menu" style="display: block;">
                             <li class="<?php echo e($request->segment(2) == 'imagehome' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.managehome.index_image')); ?>">
                                <i class="fa fa-circle-o"></i> 
                                    <?php echo app('translator')->getFromJson('global.website-management.fields.home_image'); ?>
                                </a>
                            </li>
                            <li class="<?php echo e($request->segment(2) == 'client' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.managehome.index_client')); ?>">
                                <i class="fa fa-circle-o"></i> 
                                    <?php echo app('translator')->getFromJson('global.website-management.fields.home_client'); ?>
                                </a>
                            </li>
                            <li class="<?php echo e($request->segment(2) == 'review' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.managehome.index_review')); ?>">
                                <i class="fa fa-circle-o"></i> 
                                    <?php echo app('translator')->getFromJson('global.website-management.fields.home_review'); ?>
                                </a>
                            </li>
                             <!-- <li class="<?php echo e($request->segment(2) == 'service' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.managehome.index_newcar')); ?>">
                                <i class="fa fa-circle-o"></i> 
                                    <?php echo app('translator')->getFromJson('global.website-management.fields.home_newcar'); ?>
                                </a>
                            </li>                            
                            <li class="<?php echo e($request->segment(2) == 'promotion' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.managehome.index_promotion')); ?>">
                                <i class="fa fa-circle-o"></i> 
                                    <?php echo app('translator')->getFromJson('global.website-management.fields.home_promotion'); ?>
                                </a>
                            </li>  -->
                        </ul>
                    </li>
                    <li class="<?php echo e($request->segment(2) == 'service' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.managehome.index_service')); ?>">
                        <i class="fa fa-circle-o"></i> 
                            <?php echo app('translator')->getFromJson('global.website-management.fields.home_service'); ?>
                        </a>
                    </li>
                    <li class="<?php echo e($request->segment(2) == 'package' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.managehome.index_package')); ?>">
                        <i class="fa fa-circle-o"></i> 
                            <?php echo app('translator')->getFromJson('global.website-management.fields.home_package'); ?>
                        </a>
                    </li>
                    <li class="<?php echo e($request->segment(2) == 'managecontact' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.managecontact.index')); ?>">
                            <i class="fa fa-phone-square"></i>
                            <span class="title">
                                <?php echo app('translator')->getFromJson('global.website-management.fields.contact'); ?>
                            </span>
                        </a>
                    </li>
                    <li class="<?php echo e($request->segment(2) == 'manageblog' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.manageblog.index')); ?>">
                            <i class="fa fa-eye"></i>
                            <span class="title">
                                <?php echo app('translator')->getFromJson('global.website-management.fields.blog'); ?>
                            </span>
                        </a>
                    </li>
                    
                </ul>
            </li>
            <?php endif; ?>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users_manage')): ?>
            <li class="treeview">
                <a href="#">
                    <i class="fa fa-users"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.user-management.title'); ?></span>
                    <span class="pull-right-container">
                        <i class="fa fa-angle-left pull-right"></i>
                    </span>
                </a>
                <ul class="treeview-menu">
                    <li class="<?php echo e($request->segment(2) == 'permissions' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.permissions.index')); ?>">
                            <i class="fa fa-briefcase"></i>
                            <span class="title">
                                <?php echo app('translator')->getFromJson('global.permissions.title'); ?>
                            </span>
                        </a>
                    </li>
                    <li class="<?php echo e($request->segment(2) == 'roles' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.roles.index')); ?>">
                            <i class="fa fa-briefcase"></i>
                            <span class="title">
                                <?php echo app('translator')->getFromJson('global.roles.title'); ?>
                            </span>
                        </a>
                    </li>
                    <li class="<?php echo e($request->segment(2) == 'users' ? 'active active-sub' : ''); ?>">
                        <a href="<?php echo e(route('admin.users.index')); ?>">
                            <i class="fa fa-user"></i>
                            <span class="title">
                                <?php echo app('translator')->getFromJson('global.users.title'); ?>
                            </span>
                        </a>
                    </li>
                </ul>
            </li>
            <?php endif; ?>

            <li class="<?php echo e($request->segment(1) == 'change_password' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('auth.change_password')); ?>">
                    <i class="fa fa-key"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.users.fields.change_password'); ?></span>
                </a>
            </li>

            <li>
                <a href="<?php echo e(url('/')); ?>">
                    <i class="fa fa-home"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.app_website'); ?></span>
                </a>
            </li>

            <li>
                <a href="#logout" onclick="$('#logout').submit();">
                    <i class="fa fa-arrow-left"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('global.app_logout'); ?></span>
                </a>
            </li>
        </ul>
    </section>
</aside>
<?php echo Form::open(['route' => 'auth.logout', 'style' => 'display:none;', 'id' => 'logout']); ?>

<button type="submit"><?php echo app('translator')->getFromJson('global.logout'); ?></button>
<?php echo Form::close(); ?>

