<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('frontendcontent'); ?>

<!-- Breadcrumbs Block -->
<div class="block breadcrumbs">
    <div class="container">
        <ul class="breadcrumb">
            <li><a href="index.html">Home</a></li>
            <li><a href="blog-posts.html">Blog</a></li>
            <li><?php echo e($blog->header); ?></li>
        </ul>
    </div>
</div>
<!-- //Breadcrumbs Block -->
<div class="block">
    <h2 class="text-center h-lg h-decor">Blog Posts</h2>
    <div class="container">
        <div class="row">
            <div class="col-md-9 aside">
                <div class="blog-post single">
                    <div class="post-image">
                        <a href="blog-post-page.html"><img src="<?php echo e(asset($imageblog[0]->image_url)); ?>" alt=""></a>
                    </div>
                    <ul class="post-meta">
                        <li class="post-meta-date"><?php echo e(date("d F, Y", strtotime($blog->created_at))); ?></li>
                        
                    </ul>
                    <h2 class="post-title"><?php echo e($blog->header); ?></h2>
                    <div class="post-author">by Admin</div>
                    <div class="post-content" align="justify">
                        <?php echo $blog->detail; ?>

                    </div>
                </div>
                
                <div class="divider-lg"></div>
                <h2>สอบถามข้อมูลและติชมบริการ</h2>
                <?php echo Form::open(['method' => 'POST', 'route' => ['store_contactmessage']]); ?>

                    <div class="inputs-col">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="input-wrapper">
                                    <input type="text" class="input-custom input-full" name="name" placeholder="กรุณากรอกชื่อของคุณ*">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="input-wrapper">
                                    <input type="text" class="input-custom input-full" name="tel" placeholder="กรุณากรอกเบอร์โทรศัพท์ / อีเมล์ / ไอดีไลน์ ที่ต้องการให้ติดต่อกลับ*">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="input-wrapper">
                        <textarea class="textarea-custom input-full" name="message" placeholder="กรุณากรอกข้อความของคุณ*"></textarea>
                    </div>
                    <button type="submit" class="btn btn-border">ส่งข้อความ</button>
                <?php echo Form::close(); ?>

                <div class="divider divider-lg"></div>
            </div>
            <div class="col-md-3 aside">
                
                <div class="side-block">
                    <h3>โพสต์ที่น่าสนใจ</h3>
                    <?php if(count($randomblog) > 0): ?>
                        <?php $__currentLoopData = $randomblog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="blog-post post-preview">
                                <div class="post-image">
                                    <a href="<?php echo e(route('blog-detail',[$item->id])); ?>"><img src="<?php echo e(asset($item->imageblog[0]->image_url)); ?>" alt=""></a>
                                </div>
                                <ul class="post-meta">
                                    <li class="post-meta-date"><?php echo e(date("d F, Y", strtotime($item->created_at))); ?></li>
                                    
                                </ul>
                                <h4 class="post-title"><a href="<?php echo e(route('blog-detail',[$item->id])); ?>"><?php echo e($item->header); ?></a></h4>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>                    
                        <div class="blog-post post-preview">
                            <div class="post-image">
                                <a href="blog-post-page.html"><img src="<?php echo e(asset('frontend/assets/images/blog/blog-post-featured-1.jpg')); ?>" alt=""></a>
                            </div>
                            <ul class="post-meta">
                                <li class="post-meta-date">16 December, 2017</li>
                                <li class="pull-right post-meta-reviews"><i class="icon icon-speech-bubble"></i><span>3</span></li>
                            </ul>
                            <h4 class="post-title"><a href="blog-post-page.html">New Cleaning With Hydrogen Peroxide</a></h4>
                        </div>
                        <div class="blog-post post-preview">
                            <div class="post-image">
                                <a href="blog-post-page.html"><img src="<?php echo e(asset('frontend/assets/images/blog/blog-post-featured-2.jpg')); ?>" alt=""></a>
                            </div>
                            <ul class="post-meta">
                                <li class="post-meta-date">16 December, 2017</li>
                                <li class="pull-right post-meta-reviews"><i class="icon icon-speech-bubble"></i><span>3</span></li>
                            </ul>
                            <h4 class="post-title"><a href="blog-post-page.html">A Quick Kitchen-Cleaning Mission for Monday</a></h4>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontendjavascript'); ?> 
    <script>
        $(document).ready(function () {
            $('#confirm').click(function(e){   

                let name = $('#name').val();
                let tel = $('#tel').val();
                let line = $('#line').val();
                let appoint = $('#appoint').val();
                let detail = $('#detail').val();

                if (name == "") {
                    swal("กรุณากรอกชื่อ","","warning");
                } else if (tel == "") {
                    swal("กรุณากรอกเบอร์ติดต่อ","","warning");
                } else if (line == "") {
                    swal("กรุณากรอกไอดีไลน์","","warning");
                } else if (appoint == "") {
                    swal("กรุณากรอกวันที่สะดวกเข้ามาชมรถ","","warning");
                } else if (detail == "") {
                    swal("กรุณากรอกรายละเอียด","","warning");
                } else {
                    $.ajax({ 
                        url: '<?php echo e(url("inquiry")); ?>', 
                        type: "POST",
                        data: { "name" : name, "tel" : tel, "appoint" : appoint, "detail" : detail, "line" : line},
                        success: function(data, statusText, resObject) {
                            
                            if (data) {    

                                if(data === true){
                                    swal("นัดหมายสำเร็จ โปรดรอการติดต่อกลับ","","success");
                                    $('#name').val("");
                                    $('#tel').val("");
                                    $('#line').val("");
                                    $('#appoint').val("");
                                    $('#detail').val("");
                                }else{
                                    swal("เกิดข้อผิดพลาด กรุณาลองใหม่","","error");
                                }
                                                                
                            }
                            return false;
                        },
                        error: function (jqXHR, exception) {
                            getErrorMessage(jqXHR, exception);
                        },
                        complete: function() {      
                            // Do something when success or error.                                           
                        }
                    });
                }

            })
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>