<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <div class="box box-danger">
        <div class="box-header with-border">
            <h3 class="box-title"><b><?php echo app('translator')->getFromJson('global.app_list'); ?><?php echo app('translator')->getFromJson('global.website-management.fields.work'); ?></b></h3>
            <div class="box-tools">
                
            </div>
        </div>
        <div class="box-body table-responsive">
            <?php if($message = Session::get('success')): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fa fa-check"></i><?php echo e($message); ?></h5>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('del-success')): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fa fa-check"></i><?php echo e($message); ?></h5>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <table class="table table-bordered table-striped <?php echo e(count($work) > 0 ? 'datatable' : ''); ?>">
                <thead>
                    <tr>
                        
                        <th><?php echo app('translator')->getFromJson('global.website-management.fields.work_name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.website-management.fields.work_position'); ?></th>
                        <th>&nbsp;</th>

                    </tr>
                </thead>
                
                <tbody>
                    <?php if(count($work) > 0): ?>
                        <?php $__currentLoopData = $work; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-entry-id="<?php echo e($item->id); ?>">
                                
                                <td>
                                    <?php
                                        $resultStr = mb_substr($item->name, 0, 20);
                                    ?>
                                    <?php echo e($resultStr); ?> 
                                </td>
                                <td><?php echo e($item->position); ?></td>
                                <td  style="text-align:center;">
                                    <a href="<?php echo e(route('admin.managehome.view_work',[$item->id])); ?>" class="btn btn-xs btn-info"><?php echo app('translator')->getFromJson('global.app_view'); ?></a>
                                    
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;"><?php echo app('translator')->getFromJson('global.app_no_entries_in_table'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <div class="box box-danger">
        <div class="box-header with-border">
            <h3 class="box-title"><b><?php echo app('translator')->getFromJson('global.app_list'); ?><?php echo app('translator')->getFromJson('global.website-management.fields.contact'); ?></b></h3>
            <div class="box-tools">
                
            </div>
        </div>
        <div class="box-body table-responsive">
            <?php if($message = Session::get('success')): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fa fa-check"></i><?php echo e($message); ?></h5>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('del-success')): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fa fa-check"></i><?php echo e($message); ?></h5>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <table class="table table-bordered table-striped <?php echo e(count($contactmessage) > 0 ? 'datatable' : ''); ?>">
                <thead>
                    <tr>
                        
                        <th><?php echo app('translator')->getFromJson('global.website-management.fields.work_name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.website-management.fields.home_promotion_detail'); ?></th>
                        <th>&nbsp;</th>

                    </tr>
                </thead>
                
                <tbody>
                    <?php if(count($contactmessage) > 0): ?>
                        <?php $__currentLoopData = $contactmessage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-entry-id="<?php echo e($item->id); ?>">
                                
                                <td><?php echo e($item->name); ?></td>
                                <td>
                                    <?php
                                        $resultStr = mb_substr($item->message, 0, 20);
                                    ?>
                                    <?php echo e($resultStr); ?> 
                                </td>
                                <td  style="text-align:center;">
                                    <a href="<?php echo e(route('admin.managehome.view_contactmessage',[$item->id])); ?>" class="btn btn-xs btn-info"><?php echo app('translator')->getFromJson('global.app_view'); ?></a>
                                    
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;"><?php echo app('translator')->getFromJson('global.app_no_entries_in_table'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        //window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.managegallery.mass_destroy')); ?>';
        $(document).ready(function(){
            $('.alert-dismissible').fadeOut(2500);
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>