<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <div class="box box-danger">
        <div class="box-header with-border">
            <h3 class="box-title"><b><?php echo app('translator')->getFromJson('global.app_list'); ?><?php echo app('translator')->getFromJson('global.website-management.fields.blog'); ?></b></h3>
            <div class="box-tools">
                <a href="<?php echo e(route('admin.manageblog.create')); ?>" class="btn btn-sm btn-success"><?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>            
            </div>
            
        </div>
        <div class="box-body table-responsive">
            <?php if($message = Session::get('success')): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fa fa-check"></i><?php echo e($message); ?></h5>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($message = Session::get('del-success')): ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fa fa-check"></i><?php echo e($message); ?></h5>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <table class="table table-bordered table-striped <?php echo e(count($blog) > 0 ? 'datatable' : ''); ?> dt-select">
                <thead>
                    <tr>
                        <th style="text-align:center;"><input type="checkbox" id="select-all" /></th>
                        <th><?php echo app('translator')->getFromJson('global.website-management.fields.blog_header'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.website-management.fields.blog_status'); ?></th>
                        <th>&nbsp;</th>

                    </tr>
                </thead>
                
                <tbody>
                    <?php if(count($blog) > 0): ?>
                        <?php $__currentLoopData = $blog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-entry-id="<?php echo e($item->id); ?>">
                                <td></td>

                                <td><?php echo e($item->header); ?></td>
                                <td><?php echo app('translator')->getFromJson('global.website-management.fields.home_promotion_'.$item->status); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.manageblog.edit',[$item->id])); ?>" class="btn btn-xs btn-info"><?php echo app('translator')->getFromJson('global.app_edit'); ?></a>
                                    <?php echo Form::open(array(
                                        'style' => 'display: inline-block;',
                                        'method' => 'DELETE',
                                        'onsubmit' => "return confirm('".trans("global.app_are_you_sure")."');",
                                        'route' => ['admin.manageblog.destroy', $item->id])); ?>

                                    <?php echo Form::submit(trans('global.app_delete'), array('class' => 'btn btn-xs btn-danger')); ?>

                                    <?php echo Form::close(); ?>

                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" style="text-align:center;"><?php echo app('translator')->getFromJson('global.app_no_entries_in_table'); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.manageblog.mass_destroy')); ?>';
        $(document).ready(function(){
            $('.alert-dismissible').fadeOut(2500);
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>