<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('frontendcontent'); ?>

<!-- Breadcrumbs Block -->
<div class="block breadcrumbs">
    <div class="container">
        <ul class="breadcrumb">
            <li><a href="index.html">Home</a></li>
            <li>Contact Us</li>
        </ul>
    </div>
</div>
<!-- //Breadcrumbs Block -->
<h1 class="text-center h-decor">ติดต่อเรา</h1>
<div class="block fullwidth no-pad">
    <div class="container">
        
        <div id="mapX" class="google-map"></div>
    </div>
</div>
<div class="block">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <h2>ข้อมูลสำนักงาน</h2>
                <div class="contact-info-sm">
                    <h5>ที่ตั้งสำนักงาน</h5>
                    <i class="icon icon-map-marker"></i><?php echo e($contact->address1); ?>

                    <br><?php echo e($contact->address2); ?> <?php echo e($contact->address3); ?> 
                    <br><?php echo e($contact->address4); ?> 
                    <br><?php echo e($contact->address5); ?>

                </div>
                <div class="contact-info-sm">
                    <h5>โทรศัพท์</h5>
                    <i class="icon icon-technology"></i>สายตรง: <?php echo e($contact->phone1); ?><br>มือถือ: <?php echo e($contact->phone2); ?>

                </div>
                <div class="contact-info-sm">
                    <h5>เวลาเปิดทำการ</h5>
                    <i class="icon icon-clock"></i>เปิดทำการทุกวัน
                    <br>เวลา: 08:00 น. – 17:00 น.
                </div>
                <div class="divider"></div>
                <h5>Look for us on</h5>
                <ul class="social-list">
                    
                    <li><a href="http://facebook.com/<?php echo e($contact->facebook); ?>"><img src="<?php echo e(asset('frontend/assets/images/facebook.png')); ?>" width="43" alt=""></a></li>
                    <li><a href="http://www.wanchai-cleaning.com"><img src="<?php echo e(asset('frontend/assets/images/ig.png')); ?>" width="40" alt=""></a></li>
                    <li><a href="http://lin.ee/2bZzNjY"><img src="<?php echo e(asset('frontend/assets/images/line.png')); ?>" width="40" alt=""></a></li>
                    
                </ul>
            </div>
            <div class="divider visible-sm visible-xs"></div>
            <div class="col-md-8">
                <h2 class="text-center h-lg h-decor">สอบถามข้อมูลและติชมบริการ</h2>
                <?php echo Form::open(['method' => 'POST', 'route' => ['store_contactmessage']]); ?>

                
                    <div class="successform text-center">
                        <p>Your message was sent successfully!</p>
                    </div>
                    <div class="errorform text-center">
                        <p>Something went wrong, try refreshing and submitting the form again.</p>
                    </div>
                    <div class="input-wrapper">
                        <input type="text" class="input-custom input-full" name="name" placeholder="กรุณากรอกชื่อของคุณ">
                    </div>
                    <div class="input-wrapper">
                        <input type="text" class="input-custom input-full" name="tel" placeholder="กรุณากรอกเบอร์โทรศัพท์ / อีเมล์ / ไอดีไลน์ ที่ต้องการให้ติดต่อกลับ">
                    </div>
                    <div class="input-wrapper">
                        <textarea class="textarea-custom input-full" name="message" placeholder="กรุณากรอกข้อความของคุณ"></textarea>
                    </div>
                    <div class="text-center">
                        <button type="submit" class="btn">ส่งข้อความ</button>
                    </div>
                
                <?php echo Form::close(); ?>

            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontendjavascript'); ?> 
        
    <script>
       //--Map--// 
        var position={lat:<?php echo e($contact->lat_map); ?>,lng:<?php echo e($contact->lng_map); ?> };
        function initMap(){
            var map = new google.maps.Map(document.getElementById('mapX'),{
                zoom: 13,
                center:position
            });
            var marker = new google.maps.Marker({
                position: position,
                map: map,
                title:"<?php echo e(trans('global.global_header')); ?>",
                draggable:true
            });

            var info = new google.maps.InfoWindow({
                content : '<p align="center" style="width:200px;"><b><?php echo e(trans("global.global_header")); ?></b></p>'
            });
            info.open(map,marker);
            var infoedit = new google.maps.InfoWindow({
                content : '<p align="center" style="width:200px; color:red; font-family:"Segoe UI Web";><b>>>ตำแหน่งใหม่<<</b></p>'
            });
        }
        //--End Map--//   

        $(document).ready(function () {
            $('#confirm').click(function(e){   

                let name = $('#name').val();
                let tel = $('#tel').val();
                let line = $('#line').val();
                let appoint = $('#appoint').val();
                let detail = $('#detail').val();

                if (name == "") {
                    swal("กรุณากรอกชื่อ","","warning");
                } else if (tel == "") {
                    swal("กรุณากรอกเบอร์ติดต่อ","","warning");
                } else if (line == "") {
                    swal("กรุณากรอกไอดีไลน์","","warning");
                } else if (appoint == "") {
                    swal("กรุณากรอกวันที่สะดวกเข้ามาชมรถ","","warning");
                } else if (detail == "") {
                    swal("กรุณากรอกรายละเอียด","","warning");
                } else {
                    $.ajax({ 
                        url: '<?php echo e(url("inquiry")); ?>', 
                        type: "POST",
                        data: { "name" : name, "tel" : tel, "appoint" : appoint, "detail" : detail, "line" : line},
                        success: function(data, statusText, resObject) {
                            
                            if (data) {    

                                if(data === true){
                                    swal("นัดหมายสำเร็จ โปรดรอการติดต่อกลับ","","success");
                                    $('#name').val("");
                                    $('#tel').val("");
                                    $('#line').val("");
                                    $('#appoint').val("");
                                    $('#detail').val("");
                                }else{
                                    swal("เกิดข้อผิดพลาด กรุณาลองใหม่","","error");
                                }
                                                                
                            }
                            return false;
                        },
                        error: function (jqXHR, exception) {
                            getErrorMessage(jqXHR, exception);
                        },
                        complete: function() {      
                            // Do something when success or error.                                           
                        }
                    });
                }

            })
            
            
        });
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBINVRX-GNF4z1l8CPFrJL5dhIGY96a9-k&callback=initMap"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>