<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use App\Blog;
use App\ImageBlog;
use Response;
use Image;
use Auth;
use LogActivity;

class ManageblogController extends Controller
{
    public function user()
    {
        $user = Auth::user();
        return $user;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        $blog = Blog::all();
        return view('admin.blog.index',compact('blog'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        return view('admin.blog.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        $newblog = new Blog;
        $newblog->header = $request->header;
        $newblog->detail = $request->detail;
        $newblog->status = $request->status;
        $newblog->save();

        if($request->hasFile('blog_image')) {

            //get filename with extension
            $filenamewithextension = $request->blog_image->getClientOriginalName();
            
            //get filename without extension
            $filename = pathinfo($filenamewithextension, PATHINFO_FILENAME);
    
            //get file extension
            $extension = $request->blog_image->getClientOriginalExtension();
    
            //filename to store
            $filenametostore = $filename.'_'.time().'.'.$extension;

            //get file size
            $filesize = filesize($request->blog_image);

            //Upload File
            $imgwidth = 500;
            $path = 'image_blog/'.$filenametostore;
            $img = Image::make($request->blog_image->getRealPath());
            if($img->width()>$imgwidth){ 
                // See the docs - http://image.intervention.io/api/resize
                // resize the image to a width of 300 and constrain aspect ratio (auto height)
                $img->resize($imgwidth, null, function ($constraint) {
                    $constraint->aspectRatio();
                });
                
            }

            $img->save($path);
            
            $imageblog = new ImageBlog;
            $imageblog->blog_id = $newblog->id;
            $imageblog->image_name = $filenametostore;
            $imageblog->image_size = $filesize;
            $imageblog->image_url = $path;
            $imageblog->save();
        }

        LogActivity::addToLog('Create Blog By '.$this->user()->name);

        $blog = Blog::all();
        return redirect()->route('admin.manageblog.index', compact('blog'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        $blog = Blog::findOrFail($id);
        $imageblog = ImageBlog::where('blog_id',$id)->get();
        return view('admin.blog.edit', compact('blog','imageblog'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        $editblog = Blog::findOrFail($id);
        $editblog->header = $request->header;
        $editblog->detail = $request->detail;
        $editblog->status = $request->status;
        $editblog->save();

        if($request->hasFile('blog_image')) {            

            $oldimageBlog = ImageBlog::where('blog_id',$id)->first();
            unlink($oldimageBlog->image_url);
            ImageBlog::where('blog_id',$id)->delete();

            //get filename with extension
            $filenamewithextension = $request->blog_image->getClientOriginalName();
    
            //get filename without extension
            $filename = pathinfo($filenamewithextension, PATHINFO_FILENAME);
    
            //get file extension
            $extension = $request->blog_image->getClientOriginalExtension();
    
            //filename to store
            $filenametostore = $filename.'_'.time().'.'.$extension;
            //$filenametostore = 'blog/'.time();

            //get file size
            $filesize = filesize($request->blog_image);

            //Upload File
            $imgwidth = 500;
            $path = 'image_blog/'.$filenametostore;
            $img = Image::make($request->blog_image->getRealPath());
            if($img->width()>$imgwidth){ 
                // See the docs - http://image.intervention.io/api/resize
                // resize the image to a width of 300 and constrain aspect ratio (auto height)
                $img->resize($imgwidth, null, function ($constraint) {
                    $constraint->aspectRatio();
                });

            }

            $img->save($path);
            
            $imageblog = new ImageBlog;
            $imageblog->blog_id = $editblog->id;
            $imageblog->image_name = $filenametostore;
            $imageblog->image_size = $filesize;
            $imageblog->image_url = $path;
            $imageblog->save();
        }

        LogActivity::addToLog('Update Blog ID:'.$id.' By '.$this->user()->name);

        $blog = Blog::all();
        return redirect()->route('admin.manageblog.index', compact('blog'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        $oldblog = Blog::findOrFail($id);
        $groupImageBlog = ImageBlog::where('blog_id',$id)->get();
        $oldblog->delete();

        foreach ($groupImageBlog as $key) {
            $imageBlog = ImageBlog::findOrFail($key->id);
            unlink($imageBlog->image_url);
            $imageBlog->delete();
        }

        LogActivity::addToLog('Delete Blog By '.$this->user()->name);

        $blog = Blog::all();
        return redirect()->route('admin.manageblog.index', compact('blog'));
    }

    public function countImgBlog(Request $request)
    {
        $countImageBlog = ImageBlog::where('blog_id',$request->id)->count();
        return Response::json(array($countImageBlog)); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroyImage(Request $request)
    {
        $imageBlog = ImageBlog::findOrFail($request->key);
        unlink($imageBlog->image_url);
        $imageBlog->delete();
        LogActivity::addToLog('Delete Image in Blog By '.$this->user()->name);
        return "{}";
    }

    /**
     * Delete all selected User at once.
     *
     * @param Request $request
     */
    public function massDestroy(Request $request)
    {
        if (! Gate::allows('website_manage')) {
            return abort(401);
        }

        if ($request->input('ids')) {
            $entriesBlog = Blog::whereIn('id', $request->input('ids'))->get();
            $entriesImageBlog = ImageBlog::whereIn('blog_id', $request->input('ids'))->get();

            foreach ($entriesBlog as $blogentry) {
                $blogentry->delete();
            }

            foreach ($entriesImageBlog as $imageblogentry) {
                unlink($imageblogentry->image_url);
                $imageblogentry->delete();
            }
        }

        LogActivity::addToLog('Mass Delete Blog By '.$this->user()->name);

    }
    
}
